/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.remapper;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MemberRef {
    @NotNull
    private final String desc;
    @NotNull
    private final String name;
    @NotNull
    private final String owner;

    public MemberRef(@NotNull String owner, @NotNull String name, @NotNull String desc) {
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    @Contract(pure=true)
    public boolean equals(Object obj) {
        if (obj instanceof MemberRef) {
            MemberRef other = (MemberRef)obj;
            return other.owner.equals(this.owner) && other.name.equals(this.name) && other.desc.equals(this.desc);
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public String getDesc() {
        return this.desc;
    }

    @NotNull
    @Contract(pure=true)
    public String getName() {
        return this.name;
    }

    @NotNull
    @Contract(pure=true)
    public String getOwner() {
        return this.owner;
    }

    @Contract(pure=true)
    public int hashCode() {
        return this.owner.hashCode() ^ this.name.hashCode() ^ this.desc.hashCode();
    }

    @NotNull
    @Contract(pure=true)
    public String toString() {
        return this.owner + "." + this.name + " " + this.desc;
    }
}

