/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.remapper;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.stianloader.remapper.MappingLookup;
import org.stianloader.remapper.MappingSink;
import org.stianloader.remapper.MemberRef;

public class SimpleMappingLookup
implements MappingLookup,
MappingSink {
    private final Map<String, String> classNames = new HashMap<String, String>();
    private final Map<MemberRef, String> memberNames = new HashMap<MemberRef, String>();
    private final Map<MemberRef, String[]> parameterNames = new HashMap<MemberRef, String[]>();

    @Override
    @NotNull
    public String getRemappedClassName(@NotNull String srcName) {
        return this.classNames.getOrDefault(srcName, srcName);
    }

    @Override
    @Nullable
    public String getRemappedClassNameFast(@NotNull String srcName) {
        return this.classNames.get(srcName);
    }

    @Override
    @NotNull
    public String getRemappedFieldName(@NotNull String srcOwner, @NotNull String srcName, @NotNull String srcDesc) {
        return this.memberNames.getOrDefault(new MemberRef(srcOwner, srcName, srcDesc), srcName);
    }

    @Override
    @NotNull
    public String getRemappedMethodName(@NotNull String srcOwner, @NotNull String srcName, @NotNull String srcDesc) {
        return this.memberNames.getOrDefault(new MemberRef(srcOwner, srcName, srcDesc), srcName);
    }

    @Override
    @Nullable
    public String getRemappedParameterName(@NotNull String srcOwner, @NotNull String srcName, @NotNull String srcDesc, int paramIndex, boolean isStatic) {
        String[] params = this.parameterNames.get(new MemberRef(srcOwner, srcName, srcDesc));
        return params == null ? null : params[paramIndex];
    }

    @Override
    @Contract(mutates="this", pure=false, value="_, _ -> this")
    @NotNull
    public SimpleMappingLookup remapClass(@NotNull String srcName, @NotNull String dstName) {
        this.classNames.put(srcName, dstName);
        return this;
    }

    @Override
    @Contract(mutates="this", pure=false, value="_, _ -> this")
    @NotNull
    public SimpleMappingLookup remapMember(@NotNull MemberRef srcRef, @NotNull String dstName) {
        if (srcRef.getDesc().codePointAt(0) == 40) {
            if (dstName.equals("<init>") || dstName.equals("<clinit>")) {
                if (dstName.equals(srcRef.getName())) {
                    return this;
                }
                throw new IllegalArgumentException("Illegal destination name for src member " + srcRef + ": " + dstName);
            }
            if (srcRef.getName().equals("<init>") || srcRef.getName().equals("<clinit>")) {
                throw new IllegalArgumentException("Illegal attempt at renaming src member " + srcRef + " to " + dstName);
            }
        }
        this.memberNames.put(srcRef, dstName);
        return this;
    }

    @Override
    @NotNull
    public MappingSink remapParameter(@NotNull String srcOwner, @NotNull String srcMethodName, @NotNull String srcDesc, int paramIndex, @NotNull String destParamName) {
        this.parameterNames.compute(new MemberRef(srcOwner, destParamName, srcDesc), (key, parameters) -> {
            if (parameters == null) {
                parameters = new String[Type.getArgumentCount((String)srcDesc)];
            }
            parameters[paramIndex] = destParamName;
            return parameters;
        });
        return this;
    }
}

