/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.stianknn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.stianknn.PointObjectPair;
import org.stianloader.stianknn.SpatialIndexKNN;

public class SpatialQueryArray<@NotNull E>
implements SpatialIndexKNN<E> {
    private final float cellHeight;
    private final int cellStripSize;
    private final float cellWidth;
    private final float maxX;
    private final float maxY;
    private final float minX;
    private final float minY;
    private final List<PointObjectPair<E>>[] points;
    private final ResultContainer<E> rc;
    private final int verticalCellCount;

    public SpatialQueryArray(Collection<PointObjectPair<E>> points, float minX, float minY, float maxX, float maxY, float cellWidth, float cellHeight) {
        this.maxX = maxX;
        this.maxY = maxY;
        this.minX = minX;
        this.minY = minY;
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.cellStripSize = (int)((this.maxX - this.minX) / this.cellWidth) + 1;
        this.verticalCellCount = (int)((this.maxY - this.minY) / this.cellHeight) + 1;
        this.rc = new ResultContainer(40);
        this.points = new List[this.cellStripSize * this.verticalCellCount];
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new ArrayList<PointObjectPair<E>>();
        }
        for (PointObjectPair<E> pair : points) {
            int cellX = Math.max(0, (int)((Math.min(pair.x, this.maxX) - this.minX) / this.cellWidth));
            int cellY = Math.max(0, (int)((Math.min(pair.y, this.maxY) - this.minY) / this.cellHeight));
            this.points[cellY * this.cellStripSize + cellX].add(pair);
        }
    }

    @Override
    @Nullable
    public E query1nn(float x, float y) {
        AtomicReference ref = new AtomicReference();
        this.queryKnn(x, y, 1, (Consumer<E>)((Consumer<Object>)ref::set));
        return (E)ref.get();
    }

    @Override
    public void queryKnn(float x, float y, int nearestNeighbours, @NotNull @NotNull Consumer<@NotNull E> out) {
        int cellX = Math.max(0, (int)((Math.min(x, this.maxX) - this.minX) / this.cellWidth));
        int cellY = Math.max(0, (int)((Math.min(y, this.maxY) - this.minY) / this.cellHeight));
        this.rc.reset(nearestNeighbours);
        List<PointObjectPair<E>> values = this.points[cellY * this.cellStripSize + cellX];
        for (int i = 0; i < values.size(); ++i) {
            PointObjectPair<E> pop = values.get(i);
            float x2 = x - pop.x;
            float y2 = y - pop.y;
            float dst2 = x2 * x2 + y2 * y2;
            if (this.rc.found < nearestNeighbours) {
                this.rc.addValueNotFull(dst2, pop.object);
                continue;
            }
            if (!(dst2 < this.rc.maxDist2)) continue;
            this.rc.addValueFull(dst2, pop.object);
        }
        float cellMinX = (float)cellX * this.cellWidth + this.minX;
        float cellMaxX = cellMinX + this.cellWidth;
        float cellMinY = (float)cellY * this.cellHeight + this.minY;
        float cellMaxY = cellMinY + this.cellHeight;
        float nearestCellBorderX = Math.min(Math.abs(x - cellMinX), Math.abs(x - cellMaxX));
        float nearestCellBorderY = Math.min(Math.abs(x - cellMinY), Math.abs(x - cellMaxY));
        float nearestCellBorderDist = Math.min(nearestCellBorderX, nearestCellBorderY);
        if (this.rc.found != nearestNeighbours || this.rc.maxDist2 > nearestCellBorderDist * nearestCellBorderDist) {
            int cellXLow = cellX;
            int cellXUp = cellX;
            int cellYLow = cellY;
            int cellYUp = cellY;
            while (true) {
                int cY;
                float dst2;
                float y2;
                float x2;
                PointObjectPair<E> pop;
                int i;
                int cx;
                int startX = cellXLow;
                boolean shrinkX = false;
                if (cellXLow > 0) {
                    --startX;
                    shrinkX = true;
                }
                int endX = cellXUp;
                boolean growX = false;
                if (cellXUp < this.cellStripSize - 1) {
                    ++endX;
                    growX = true;
                }
                int startY = cellYLow;
                boolean shrinkY = false;
                if (cellYLow > 0) {
                    --startY;
                    shrinkY = true;
                }
                int endY = cellYUp;
                boolean growY = false;
                if (cellYUp < this.verticalCellCount - 1) {
                    ++endY;
                    growY = true;
                }
                if (shrinkY) {
                    for (cx = startX; cx <= endX; ++cx) {
                        values = this.points[startY * this.cellStripSize + cx];
                        for (i = 0; i < values.size(); ++i) {
                            pop = values.get(i);
                            x2 = x - pop.x;
                            y2 = y - pop.y;
                            dst2 = x2 * x2 + y2 * y2;
                            if (this.rc.found < nearestNeighbours) {
                                this.rc.addValueNotFull(dst2, pop.object);
                                continue;
                            }
                            if (!(dst2 < this.rc.maxDist2)) continue;
                            this.rc.addValueFull(dst2, pop.object);
                        }
                    }
                }
                if (growY) {
                    for (cx = startX; cx <= endX; ++cx) {
                        values = this.points[endY * this.cellStripSize + cx];
                        for (i = 0; i < values.size(); ++i) {
                            pop = values.get(i);
                            x2 = x - pop.x;
                            y2 = y - pop.y;
                            dst2 = x2 * x2 + y2 * y2;
                            if (this.rc.found < nearestNeighbours) {
                                this.rc.addValueNotFull(dst2, pop.object);
                                continue;
                            }
                            if (!(dst2 < this.rc.maxDist2)) continue;
                            this.rc.addValueFull(dst2, pop.object);
                        }
                    }
                }
                if (shrinkX) {
                    for (cY = cellYLow; cY <= cellYUp; ++cY) {
                        values = this.points[cY * this.cellStripSize + startX];
                        for (i = 0; i < values.size(); ++i) {
                            pop = values.get(i);
                            x2 = x - pop.x;
                            y2 = y - pop.y;
                            dst2 = x2 * x2 + y2 * y2;
                            if (this.rc.found < nearestNeighbours) {
                                this.rc.addValueNotFull(dst2, pop.object);
                                continue;
                            }
                            if (!(dst2 < this.rc.maxDist2)) continue;
                            this.rc.addValueFull(dst2, pop.object);
                        }
                    }
                }
                if (growX) {
                    for (cY = cellYLow; cY <= cellYUp; ++cY) {
                        values = this.points[cY * this.cellStripSize + endX];
                        for (i = 0; i < values.size(); ++i) {
                            pop = values.get(i);
                            x2 = x - pop.x;
                            y2 = y - pop.y;
                            dst2 = x2 * x2 + y2 * y2;
                            if (this.rc.found < nearestNeighbours) {
                                this.rc.addValueNotFull(dst2, pop.object);
                                continue;
                            }
                            if (!(dst2 < this.rc.maxDist2)) continue;
                            this.rc.addValueFull(dst2, pop.object);
                        }
                    }
                }
                if (growX || shrinkX) {
                    nearestCellBorderX += this.cellWidth;
                }
                if (growY || shrinkY) {
                    nearestCellBorderY += this.cellHeight;
                } else if (!growX && !shrinkX) break;
                nearestCellBorderDist = Math.min(nearestCellBorderX, nearestCellBorderY);
                float distSqr = nearestCellBorderDist * nearestCellBorderDist;
                if (this.rc.found == nearestNeighbours && this.rc.maxDist2 < distSqr) break;
                cellYLow = Math.max(0, cellYLow - 1);
                cellYUp = Math.min(this.verticalCellCount - 1, cellYUp + 1);
                cellXLow = Math.max(0, cellXLow - 1);
                cellXUp = Math.min(this.cellStripSize - 1, cellXUp + 1);
            }
        }
        for (int i = 0; i < this.rc.found; ++i) {
            @Nullable T object = this.rc.result.get((int)i).object;
            assert (object != null);
            out.accept(object);
        }
    }

    private static class ResultContainer<T> {
        public int found;
        public float maxDist2;
        public List<Results<T>> result;

        ResultContainer(int neighbours) {
            this.result = new ArrayList<Results<T>>(neighbours);
            this.found = 0;
            this.maxDist2 = Float.POSITIVE_INFINITY;
            for (int i = 0; i < neighbours; ++i) {
                this.result.add(new Results());
            }
        }

        void addValueFull(float dist2, T obj) {
            Results<T> r = this.result.get(this.found - 1);
            r.distance2 = dist2;
            r.object = obj;
            for (int prevFound = this.found - 2; prevFound >= 0; --prevFound) {
                Results<T> prevObj = this.result.get(prevFound);
                if (!(prevObj.distance2 > r.distance2)) break;
                this.result.set(prevFound + 1, prevObj);
                this.result.set(prevFound, r);
            }
            this.maxDist2 = this.result.get((int)(this.found - 1)).distance2;
        }

        void addValueNotFull(float dist2, T obj) {
            Results<T> r = this.result.get(this.found);
            r.distance2 = dist2;
            r.object = obj;
            for (int prevFound = this.found - 1; prevFound >= 0; --prevFound) {
                Results<T> prevObj = this.result.get(prevFound);
                if (!(prevObj.distance2 > r.distance2)) break;
                this.result.set(prevFound + 1, prevObj);
                this.result.set(prevFound, r);
            }
            this.maxDist2 = this.result.get((int)this.found++).distance2;
        }

        void reset(int nearestNeighbours) {
            this.found = 0;
            this.maxDist2 = Float.POSITIVE_INFINITY;
            while (this.result.size() < nearestNeighbours) {
                this.result.add(new Results());
            }
        }
    }

    private static class Results<T> {
        public float distance2;
        @Nullable
        public T object;

        private Results() {
        }
    }
}

