/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.deobf;

import de.geolykt.starloader.deobf.ClassWrapper;
import de.geolykt.starloader.deobf.ClassWrapperPool;
import de.geolykt.starloader.deobf.DescString;
import de.geolykt.starloader.deobf.FieldReference;
import de.geolykt.starloader.deobf.IntermediaryGenerator;
import de.geolykt.starloader.deobf.JavaInterop;
import de.geolykt.starloader.deobf.LIFOQueue;
import de.geolykt.starloader.deobf.MethodReference;
import de.geolykt.starloader.deobf.OPHelper;
import de.geolykt.starloader.deobf.SignatureNode;
import de.geolykt.starloader.deobf.StackElement;
import de.geolykt.starloader.deobf.StackWalker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Oaktree {
    public static final Set<String> COLLECTIONS = JavaInterop.modifableSet("Ljava/util/Vector;", "Ljava/util/List;", "Ljava/util/ArrayList;", "Ljava/util/Collection;", "Ljava/util/AbstractCollection;", "Ljava/util/AbstractList;", "Ljava/util/AbstractSet;", "Ljava/util/AbstractQueue;", "Ljava/util/HashSet;", "Ljava/util/Set;", "Ljava/util/Queue;", "Ljava/util/concurrent/ArrayBlockingQueue;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljava/util/concurrent/DelayQueue;", "Ljava/util/concurrent/LinkedBlockingQueue;", "Ljava/util/concurrent/LinkedBlockingQueue;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Ljava/util/concurrent/SynchronousQueue;", "Ljava/util/concurrent/BlockingQueue;", "Ljava/util/concurrent/BlockingDeque", "Ljava/util/concurrent/LinkedBlockingDeque;", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Ljava/util/Deque", "Ljava/util/ArrayDeque;");
    public static final Set<String> ITERABLES = JavaInterop.modifableSet("Ljava/util/Vector;", "Ljava/util/List;", "Ljava/util/ArrayList;", "Ljava/util/Collection;", "Ljava/util/AbstractCollection;", "Ljava/util/AbstractList;", "Ljava/util/AbstractSet;", "Ljava/util/AbstractQueue;", "Ljava/util/HashSet;", "Ljava/util/Set;", "Ljava/util/Queue;", "Ljava/util/concurrent/ArrayBlockingQueue;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljava/util/concurrent/DelayQueue;", "Ljava/util/concurrent/LinkedBlockingQueue;", "Ljava/util/concurrent/LinkedBlockingQueue;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Ljava/util/concurrent/SynchronousQueue;", "Ljava/util/concurrent/BlockingQueue;", "Ljava/util/concurrent/BlockingDeque", "Ljava/util/concurrent/LinkedBlockingDeque;", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Ljava/util/Deque", "Ljava/util/ArrayDeque;", "Ljava/util/Iterable;");
    public static final Set<String> JAVA_KEYWORDS = JavaInterop.unmodifableSet("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");
    public static final int VISIBILITY_MODIFIERS = 7;
    private final Map<String, ClassNode> nameToNode = new HashMap<String, ClassNode>();
    private final List<ClassNode> nodes = new ArrayList<ClassNode>();
    private final ClassWrapperPool wrapperPool;

    @Nullable
    @Contract(pure=true)
    public static final String getReturnedClass(String methodDesc) {
        if (methodDesc.codePointBefore(methodDesc.length()) != 59) {
            return null;
        }
        int closingBracket = methodDesc.indexOf(41);
        if (closingBracket == -1) {
            throw new IllegalArgumentException("The descriptor: \"" + methodDesc + "\" is probably not a method descriptor.");
        }
        int indexOfL = methodDesc.indexOf(76, closingBracket);
        if (indexOfL != -1) {
            return methodDesc.substring(indexOfL + 1, methodDesc.length() - 1);
        }
        return null;
    }

    @Nullable
    @Contract(pure=true)
    private static final String getClassName(String fieldDesc) {
        int indexOfL = fieldDesc.indexOf(76);
        if (++indexOfL == 0) {
            return null;
        }
        return fieldDesc.substring(indexOfL, fieldDesc.length() - 1);
    }

    public static void main(@NotNull String[] args) {
        long start = System.currentTimeMillis();
        if (args.length < 2) {
            System.err.println("Not enough arguments. The first argument is the source jar, the second one the target jar.");
            return;
        }
        try {
            Oaktree oakTree = new Oaktree();
            JarFile file = new JarFile(args[0]);
            oakTree.index(file);
            file.close();
            oakTree.definalizeAnonymousClasses();
            oakTree.fixInnerClasses();
            oakTree.fixParameterLVT();
            oakTree.guessFieldGenerics();
            oakTree.inferMethodGenerics();
            oakTree.inferConstructorGenerics();
            oakTree.fixForeachOnArray();
            oakTree.fixComparators(true);
            oakTree.guessAnonymousClasses();
            oakTree.fixSwitchMaps();
            long startStep = System.currentTimeMillis();
            oakTree.applyInnerclasses();
            System.out.println("Applied inner class nodes to referencing classes. (" + (System.currentTimeMillis() - startStep) + " ms)");
            if (args.length == 3 && Boolean.valueOf(args[2]).booleanValue()) {
                IntermediaryGenerator gen = new IntermediaryGenerator(Paths.get("map.tiny", new String[0]), Paths.get(args[1], new String[0]), oakTree.nodes);
                gen.addResources(new File(args[0]));
                gen.useAlternateClassNaming(Boolean.getBoolean("oaktree.cli.alternateClassNaming"));
                gen.remapClassesV2();
                gen.doProposeEnumFieldsV2();
                long startGetters = System.currentTimeMillis();
                gen.remapGetters();
                System.out.println("Getters remapped in " + (System.currentTimeMillis() - startGetters) + " ms");
                gen.deobfuscate();
            } else {
                FileOutputStream os = new FileOutputStream(args[1]);
                oakTree.write(os);
                os.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.printf("Finished processing in record pace: Only %d ms!\n", System.currentTimeMillis() - start);
    }

    public Oaktree() {
        this(JavaInterop.newURLClassloader("Oaktree ClassWrapper Pool Classloader", new URL[0], Oaktree.class.getClassLoader()));
    }

    public Oaktree(ClassLoader classWrapperClassloader) {
        this.wrapperPool = new ClassWrapperPool(this.nameToNode, classWrapperClassloader);
    }

    public void applyInnerclasses() {
        HashMap<String, InnerClassNode> innerClassNodes = new HashMap<String, InnerClassNode>();
        block0: for (ClassNode node : this.nodes) {
            for (InnerClassNode icn : node.innerClasses) {
                if (!icn.name.equals(node.name)) continue;
                innerClassNodes.put(node.name, icn);
                continue block0;
            }
        }
        HashSet<String> encounteredClasses = new HashSet<String>();
        for (ClassNode node : this.nodes) {
            encounteredClasses.clear();
            for (InnerClassNode icn : node.innerClasses) {
                encounteredClasses.add(icn.name);
            }
            for (MethodNode method : node.methods) {
                if (method.instructions == null) continue;
                for (AbstractInsnNode insn : method.instructions) {
                    InnerClassNode icn;
                    if (!(insn instanceof MethodInsnNode)) continue;
                    MethodInsnNode methodRef = (MethodInsnNode)insn;
                    if (!encounteredClasses.add(methodRef.owner) || (icn = (InnerClassNode)innerClassNodes.get(methodRef.owner)) == null) continue;
                    node.innerClasses.add(icn);
                }
            }
        }
    }

    public void definalizeAnonymousClasses() {
        for (ClassNode node : this.nodes) {
            int dollarIndex = node.name.indexOf(36);
            if (dollarIndex == -1 || !Character.isDigit(node.name.codePointAt(dollarIndex + 1))) continue;
            node.access &= 0xFFFFFFEF;
        }
    }

    public void fixComparators(boolean resolveTRArtifact) {
        block0: for (ClassNode node : this.nodes) {
            if (node.signature != null || node.interfaces.size() != 1 || !((String)node.interfaces.get(0)).equals("java/util/Comparator")) continue;
            for (MethodNode method : node.methods) {
                if ((method.access & 0x1000) == 0 || !method.name.equals("compare") || !method.desc.equals("(Ljava/lang/Object;Ljava/lang/Object;)I")) continue;
                AbstractInsnNode insn = method.instructions.getFirst();
                while (insn instanceof LabelNode || insn instanceof LineNumberNode) {
                    insn = insn.getNext();
                }
                if (insn.getOpcode() != 25) {
                    throw new IllegalStateException("invalid bridge method: unexpected opcode");
                }
                VarInsnNode aloadThis = (VarInsnNode)insn;
                if (aloadThis.var != 0) {
                    throw new IllegalStateException("invalid bridge method: unexpected variable loaded");
                }
                if ((insn = insn.getNext()).getOpcode() != 25) {
                    throw new IllegalStateException("invalid bridge method: unexpected opcode");
                }
                if ((insn = insn.getNext()).getOpcode() != 192) {
                    throw new IllegalStateException("invalid bridge method: unexpected opcode");
                }
                if ((insn = insn.getNext()).getOpcode() != 25) {
                    throw new IllegalStateException("invalid bridge method: unexpected opcode");
                }
                if ((insn = insn.getNext()).getOpcode() != 192) {
                    throw new IllegalStateException("invalid bridge method: unexpected opcode");
                }
                if ((insn = insn.getNext()).getOpcode() != 182) {
                    throw new IllegalStateException("invalid bridge method: unexpected opcode");
                }
                MethodInsnNode invokevirtual = (MethodInsnNode)insn;
                if ((insn = insn.getNext()).getOpcode() != 172) {
                    throw new IllegalStateException("invalid bridge method: unexpected opcode");
                }
                boolean methodCallIsInvalid = true;
                for (MethodNode m : node.methods) {
                    if (!m.name.equals(invokevirtual.name) || !m.desc.equals(invokevirtual.desc)) continue;
                    methodCallIsInvalid = false;
                    break;
                }
                if (methodCallIsInvalid) {
                    if (resolveTRArtifact) {
                        invokevirtual.name = "compare";
                    } else {
                        throw new IllegalStateException("invalid bridge method: method does not exist (consider setting resolveTRArtifact to true)");
                    }
                }
                String generics = invokevirtual.desc.substring(1, invokevirtual.desc.indexOf(59));
                node.signature = "Ljava/lang/Object;Ljava/util/Comparator<" + generics + ";>;";
                method.access |= 0x40;
                continue block0;
            }
        }
    }

    public int fixForeachOnArray() {
        int addedLVTs = 0;
        for (ClassNode node : this.nodes) {
            for (MethodNode method : node.methods) {
                AbstractInsnNode instruction = method.instructions.getFirst();
                while (instruction != null) {
                    if (instruction instanceof VarInsnNode && OPHelper.isVarStore(instruction.getOpcode())) {
                        VarInsnNode arrayStore = (VarInsnNode)instruction;
                        AbstractInsnNode next = arrayStore.getNext();
                        if (!(next instanceof VarInsnNode) || !OPHelper.isVarLoad(next.getOpcode()) || ((VarInsnNode)next).var != arrayStore.var) {
                            instruction = next;
                            continue;
                        }
                        if (!((next = next.getNext()) instanceof InsnNode) || next.getOpcode() != 190) {
                            instruction = next;
                            continue;
                        }
                        if (!((next = next.getNext()) instanceof VarInsnNode) || next.getOpcode() != 54) {
                            instruction = next;
                            continue;
                        }
                        VarInsnNode arrayLengthStore = (VarInsnNode)next;
                        if (!((next = next.getNext()) instanceof InsnNode) || next.getOpcode() != 3) {
                            instruction = next;
                            continue;
                        }
                        if (!((next = next.getNext()) instanceof VarInsnNode) || next.getOpcode() != 54) {
                            instruction = next;
                            continue;
                        }
                        VarInsnNode indexStore = (VarInsnNode)next;
                        next = next.getNext();
                        while (next instanceof FrameNode || next instanceof LabelNode) {
                            next = next.getNext();
                        }
                        if (!(next instanceof VarInsnNode) || next.getOpcode() != 21 || ((VarInsnNode)next).var != indexStore.var) {
                            instruction = next;
                            continue;
                        }
                        if (!((next = next.getNext()) instanceof VarInsnNode) || next.getOpcode() != 21 || ((VarInsnNode)next).var != arrayLengthStore.var) {
                            instruction = next;
                            continue;
                        }
                        if (!((next = next.getNext()) instanceof JumpInsnNode) || next.getOpcode() != 162) {
                            instruction = next;
                            continue;
                        }
                        JumpInsnNode jumpToEnd = (JumpInsnNode)next;
                        if (!((next = next.getNext()) instanceof VarInsnNode) || !OPHelper.isVarLoad(next.getOpcode()) || ((VarInsnNode)next).var != arrayStore.var) {
                            instruction = next;
                            continue;
                        }
                        VarInsnNode arrayLoad = (VarInsnNode)next;
                        if (!((next = next.getNext()) instanceof VarInsnNode) || next.getOpcode() != 21 || ((VarInsnNode)next).var != indexStore.var) {
                            instruction = next;
                            continue;
                        }
                        if (!((next = next.getNext()) instanceof InsnNode && OPHelper.isArrayLoad(next.getOpcode()) && OPHelper.isVarSimilarType(next.getOpcode(), arrayLoad.getOpcode()))) {
                            instruction = next;
                            continue;
                        }
                        if (!((next = next.getNext()) instanceof VarInsnNode && OPHelper.isVarStore(next.getOpcode()) && OPHelper.isVarSimilarType(next.getOpcode(), arrayStore.getOpcode()))) {
                            instruction = next;
                            continue;
                        }
                        VarInsnNode objectStore = (VarInsnNode)next;
                        instruction = next = next.getNext();
                        boolean validForEachLoop = true;
                        while (true) {
                            if (next == null) {
                                System.err.println("Method " + node.name + "." + method.name + method.desc + " has a cursed for loop.");
                                break;
                            }
                            if (next instanceof VarInsnNode && ((VarInsnNode)next).var == indexStore.var) {
                                validForEachLoop = false;
                                break;
                            }
                            if (next instanceof LabelNode && jumpToEnd.label.equals(next)) break;
                            next = next.getNext();
                        }
                        if (!validForEachLoop) continue;
                        AbstractInsnNode previous = arrayStore.getPrevious();
                        if (previous == null) {
                            System.err.println("Method " + node.name + "." + method.name + method.desc + " has invalid bytecode.");
                            continue;
                        }
                        String arrayDesc = null;
                        if (previous instanceof MethodInsnNode) {
                            MethodInsnNode methodInvocation = (MethodInsnNode)previous;
                            arrayDesc = methodInvocation.desc.substring(methodInvocation.desc.lastIndexOf(41) + 1);
                        } else if (previous instanceof FieldInsnNode) {
                            arrayDesc = ((FieldInsnNode)previous).desc;
                        } else if (previous instanceof TypeInsnNode) {
                            arrayDesc = previous.getOpcode() == 189 ? "[L" + ((TypeInsnNode)previous).desc + ";" : ((TypeInsnNode)previous).desc;
                        } else if (previous instanceof VarInsnNode && OPHelper.isVarLoad(previous.getOpcode())) {
                            VarInsnNode otherArrayInstance = (VarInsnNode)previous;
                            while (previous != null) {
                                if (previous instanceof VarInsnNode && ((VarInsnNode)previous).var == otherArrayInstance.var && OPHelper.isVarStore(previous.getOpcode())) {
                                    AbstractInsnNode origin = previous.getPrevious();
                                    if (origin instanceof VarInsnNode && OPHelper.isVarLoad(origin.getOpcode())) {
                                        otherArrayInstance = (VarInsnNode)origin;
                                        continue;
                                    }
                                    if (origin instanceof MethodInsnNode) {
                                        MethodInsnNode methodInvocation = (MethodInsnNode)origin;
                                        arrayDesc = methodInvocation.desc.substring(methodInvocation.desc.lastIndexOf(41) + 1);
                                        break;
                                    }
                                    if (origin instanceof FieldInsnNode) {
                                        arrayDesc = ((FieldInsnNode)origin).desc;
                                        break;
                                    }
                                    if (!(origin instanceof TypeInsnNode)) break;
                                    if (origin.getOpcode() == 189) {
                                        arrayDesc = "[L" + ((TypeInsnNode)origin).desc + ";";
                                        break;
                                    }
                                    arrayDesc = ((TypeInsnNode)origin).desc;
                                    break;
                                }
                                previous = previous.getPrevious();
                            }
                        }
                        if (arrayDesc == null) continue;
                        if (arrayDesc.charAt(0) != '[') {
                            System.err.println("Method " + node.name + "." + method.name + method.desc + " has invalid bytecode.");
                            System.err.println("Guessed type: " + arrayDesc + ", but expected an array. Array found at index " + arrayStore.var);
                            continue;
                        }
                        LabelNode startObjectStoreLabel = new LabelNode();
                        method.instructions.insertBefore((AbstractInsnNode)objectStore, (AbstractInsnNode)startObjectStoreLabel);
                        LocalVariableNode localVar = new LocalVariableNode("var" + objectStore.var, arrayDesc.substring(1), null, startObjectStoreLabel, jumpToEnd.label, objectStore.var);
                        method.localVariables.add(localVar);
                        ++addedLVTs;
                        continue;
                    }
                    instruction = instruction.getNext();
                }
            }
        }
        return addedLVTs;
    }

    public void fixInnerClasses() {
        HashMap<String, InnerClassNode> splitInner = new HashMap<String, InnerClassNode>();
        HashSet<String> enums = new HashSet<String>();
        HashMap parents = new HashMap();
        for (ClassNode classNode : this.nodes) {
            parents.put(classNode.name, new ArrayList());
            if (!classNode.superName.equals("java/lang/Enum")) continue;
            enums.add(classNode.name);
        }
        for (ClassNode classNode : this.nodes) {
            InnerClassNode innerClassNode;
            boolean skip;
            if (enums.contains(classNode.superName)) {
                skip = false;
                for (InnerClassNode innerNode : classNode.innerClasses) {
                    if (!classNode.name.equals(innerNode.name)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                InnerClassNode innerNode = new InnerClassNode(classNode.name, null, null, 16400);
                ((List)parents.get(classNode.superName)).add(innerNode);
                classNode.outerClass = classNode.superName;
                classNode.innerClasses.add(innerNode);
                continue;
            }
            if (!classNode.name.contains("$")) continue;
            skip = false;
            for (InnerClassNode innernode : classNode.innerClasses) {
                if (!innernode.name.equals(classNode.name)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            int lastSeperator = classNode.name.lastIndexOf(36);
            String outerNode = classNode.name.substring(0, lastSeperator++);
            String innerMost = classNode.name.substring(lastSeperator);
            if (innerMost.matches("^[0-9]+$")) {
                innerClassNode = new InnerClassNode(classNode.name, null, null, classNode.access & 0xFFFFFFDF);
                classNode.outerClass = outerNode;
            } else {
                boolean staticInnerClass = false;
                boolean implicitStatic = false;
                if (!staticInnerClass) {
                    implicitStatic = staticInnerClass = (classNode.access & 0x200) != 0 || (classNode.access & 0x10000) != 0 || (classNode.access & 0x4000) != 0 && classNode.superName.equals("java/lang/Enum");
                }
                if (!staticInnerClass) {
                    ClassNode outerClassNode = this.nameToNode.get(outerNode);
                    implicitStatic = staticInnerClass = outerClassNode != null && (outerClassNode.access & 0x200) != 0;
                }
                if (!staticInnerClass) {
                    boolean staticConstructor = false;
                    for (MethodNode method : classNode.methods) {
                        if (!method.name.equals("<init>")) continue;
                        int outernodeLen = outerNode.length();
                        if (outernodeLen + 2 > method.desc.length()) {
                            staticConstructor = true;
                            break;
                        }
                        String arg = method.desc.substring(2, outernodeLen + 2);
                        if (arg.equals(outerNode)) continue;
                        staticConstructor = true;
                        break;
                    }
                    if (staticConstructor) {
                        staticInnerClass = true;
                        implicitStatic = false;
                    }
                }
                if (staticInnerClass && !implicitStatic) {
                    for (FieldNode field : classNode.fields) {
                        if ((field.access & 0x10) == 0 || !field.name.startsWith("this$")) continue;
                        System.err.println("Falsely identified " + classNode.name + " as static inner class.");
                        staticInnerClass = false;
                    }
                }
                int innerClassAccess = classNode.access & 0xFFFFFFDF;
                if (!staticInnerClass) {
                    classNode.outerClass = outerNode;
                } else {
                    innerClassAccess |= 8;
                }
                innerClassNode = new InnerClassNode(classNode.name, outerNode, innerMost, innerClassAccess);
            }
            ((List)parents.get(outerNode)).add(innerClassNode);
            splitInner.put(classNode.name, innerClassNode);
            classNode.innerClasses.add(innerClassNode);
        }
        for (ClassNode classNode : this.nodes) {
            ArrayList<InnerClassNode> innerNodesToAdd = new ArrayList<InnerClassNode>();
            for (Object field : classNode.fields) {
                InnerClassNode innerNode;
                String descriptor = ((FieldNode)field).desc;
                if (descriptor.length() < 4 || (innerNode = (InnerClassNode)splitInner.get(descriptor = descriptor.charAt(0) == '[' ? descriptor.substring(2, descriptor.length() - 1) : descriptor.substring(1, descriptor.length() - 1))) == null) continue;
                if (innerNode.innerName == null && !((FieldNode)field).name.startsWith("this$")) {
                    System.err.println(String.format("Unlikely field descriptor for field \"%s\" with descriptor %s in class %s", ((FieldNode)field).name, ((FieldNode)field).desc, classNode.name));
                }
                innerNodesToAdd.add(innerNode);
            }
            HashSet<String> entryNames = new HashSet<String>();
            for (InnerClassNode inner : innerNodesToAdd) {
                if (!entryNames.add(inner.name)) continue;
                classNode.innerClasses.add(inner);
            }
        }
        for (Map.Entry entry : parents.entrySet()) {
            HashSet<String> entryNames = new HashSet<String>();
            ArrayList<InnerClassNode> toRemove = new ArrayList<InnerClassNode>();
            for (InnerClassNode inner : (List)entry.getValue()) {
                if (entryNames.add(inner.name)) continue;
                toRemove.add(inner);
            }
            toRemove.forEach(((List)entry.getValue())::remove);
            ClassNode node = this.nameToNode.get(entry.getKey());
            for (InnerClassNode innerEntry : (List)entry.getValue()) {
                boolean skip = false;
                for (InnerClassNode inner : node.innerClasses) {
                    if (!inner.name.equals(innerEntry.name)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                node.innerClasses.add(innerEntry);
            }
        }
    }

    public void fixParameterLVT() {
        for (ClassNode node : this.nodes) {
            for (MethodNode method : node.methods) {
                int i;
                List locals = method.localVariables;
                List params = method.parameters;
                if (method.desc.indexOf(41) == 1 && params == null || (method.access & 0x400) != 0 || !Objects.requireNonNull(locals).isEmpty()) continue;
                if (params == null) {
                    String name;
                    method.parameters = new ArrayList();
                    params = method.parameters;
                    DescString description = new DescString(method.desc);
                    ArrayList<String> types = new ArrayList<String>();
                    while (description.hasNext()) {
                        types.add(description.nextType());
                    }
                    HashMap<String, Integer> nameFrequency = new HashMap<String, Integer>();
                    String[] names = new String[types.size()];
                    for (i = 0; i < types.size(); ++i) {
                        String type = (String)types.get(i);
                        name = null;
                        switch (type.charAt(0)) {
                            case 'L': {
                                int classNameBegin = type.lastIndexOf(47) + 1;
                                classNameBegin = Math.max(classNameBegin, type.lastIndexOf(36, classNameBegin) + 1);
                                String typeName = type.substring(classNameBegin, type.length() - 1);
                                name = typeName.length() == 1 ? JavaInterop.codepointToString(Character.toLowerCase(typeName.codePointAt(0))) : JavaInterop.codepointToString(Character.toLowerCase(typeName.codePointAt(0))) + typeName.substring(1);
                                if (name.length() < 3) {
                                    if (types.size() == 1) {
                                        name = "argument";
                                        break;
                                    }
                                    name = "argument" + i;
                                    break;
                                }
                                if (!JAVA_KEYWORDS.contains(name)) break;
                                name = name + i;
                                break;
                            }
                            case '[': {
                                name = "arr";
                                break;
                            }
                            case 'F': {
                                name = "float" + i;
                                break;
                            }
                            case 'D': {
                                name = "double" + i;
                                break;
                            }
                            case 'Z': {
                                name = "boolean" + i;
                                break;
                            }
                            case 'B': {
                                name = "byte" + i;
                                break;
                            }
                            case 'C': {
                                name = "character";
                                break;
                            }
                            case 'S': {
                                name = "short" + i;
                                break;
                            }
                            case 'I': {
                                name = "integer";
                                break;
                            }
                            case 'J': {
                                name = "long" + i;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown type: " + type);
                            }
                        }
                        names[i] = name;
                        nameFrequency.compute(name, (key, oldVal) -> {
                            int n;
                            if (oldVal == null) {
                                n = 1;
                            } else {
                                oldVal = oldVal + 1;
                                n = oldVal;
                            }
                            return n;
                        });
                    }
                    HashMap<String, Integer> nameIndex = new HashMap<String, Integer>();
                    for (int i2 = 0; i2 < names.length; ++i2) {
                        name = names[i2];
                        nameIndex.compute(name, (key, oldVal) -> {
                            int n;
                            if (oldVal == null) {
                                n = 0;
                            } else {
                                oldVal = oldVal + 1;
                                n = oldVal;
                            }
                            return n;
                        });
                        if ((Integer)nameFrequency.get(name) == 1) {
                            params.add(new ParameterNode(name, 0));
                            continue;
                        }
                        params.add(new ParameterNode(name + nameIndex.get(name), 0));
                    }
                }
                int localVariableIndex = 0;
                if ((method.access & 8) == 0) {
                    ++localVariableIndex;
                }
                DescString description = new DescString(method.desc);
                LabelNode start = new LabelNode();
                LabelNode end = new LabelNode();
                for (i = 0; i < params.size(); ++i) {
                    String type = description.nextType();
                    LocalVariableNode a = new LocalVariableNode(((ParameterNode)params.get((int)i)).name, type, null, start, end, localVariableIndex);
                    char c = type.charAt(0);
                    localVariableIndex = c == 'D' || c == 'J' ? (localVariableIndex += 2) : ++localVariableIndex;
                    locals.add(a);
                }
            }
        }
    }

    public int fixSwitchMaps() {
        HashMap<FieldReference, String> deobfNames = new HashMap<FieldReference, String>();
        for (ClassNode node : this.nodes) {
            AbstractInsnNode instruction;
            if (node.superName == null || !node.superName.equals("java/lang/Object") || !node.interfaces.isEmpty() || node.fields.size() != 1 || node.methods.size() != 1) continue;
            MethodNode method = (MethodNode)node.methods.get(0);
            FieldNode field = (FieldNode)node.fields.get(0);
            if (!method.name.equals("<clinit>") || !method.desc.equals("()V") || !field.desc.equals("[I") || (field.access & 8) == 0) continue;
            FieldReference fieldRef = new FieldReference(node.name, field);
            String enumName = null;
            for (instruction = method.instructions.getFirst(); instruction != null; instruction = instruction.getNext()) {
                FieldInsnNode fieldInstruction;
                if (!(instruction instanceof FieldInsnNode) || instruction.getOpcode() != 178 || !fieldRef.equals(new FieldReference(fieldInstruction = (FieldInsnNode)instruction))) continue;
                AbstractInsnNode next = instruction.getNext();
                while (next instanceof FrameNode || next instanceof LabelNode) {
                    next = next.getNext();
                }
                if (!(next instanceof FieldInsnNode) || next.getOpcode() != 178) continue;
                if (enumName == null) {
                    enumName = ((FieldInsnNode)next).owner;
                    continue;
                }
                if (enumName.equals(((FieldInsnNode)next).owner)) continue;
                enumName = null;
                break;
            }
            if (enumName == null || fieldRef.getName().indexOf(36) != -1) continue;
            String newName = "$SwitchMap$" + enumName.replace('/', '$');
            deobfNames.put(fieldRef, newName);
            for (instruction = method.instructions.getFirst(); instruction != null; instruction = instruction.getNext()) {
                FieldInsnNode fieldInsn;
                if (!(instruction instanceof FieldInsnNode) || (fieldInsn = (FieldInsnNode)instruction).getOpcode() != 178 && fieldInsn.getOpcode() != 179 || !fieldInsn.owner.equals(node.name) || !fieldRef.equals(new FieldReference(fieldInsn))) continue;
                fieldInsn.name = newName;
            }
            field.name = newName;
        }
        for (ClassNode node : this.nodes) {
            HashSet<String> addedInnerClassNodes = new HashSet<String>();
            for (InnerClassNode icn : node.innerClasses) {
                addedInnerClassNodes.add(icn.name);
            }
            for (MethodNode method : node.methods) {
                AbstractInsnNode instruction = method.instructions.getFirst();
                while (instruction != null) {
                    if (instruction instanceof FieldInsnNode && instruction.getOpcode() == 178) {
                        FieldInsnNode fieldInstruction = (FieldInsnNode)instruction;
                        if (fieldInstruction.owner.equals(node.name)) {
                            instruction = instruction.getNext();
                            continue;
                        }
                        FieldReference fRef = new FieldReference(fieldInstruction);
                        String newName = (String)deobfNames.get(fRef);
                        if (newName != null) {
                            fieldInstruction.name = newName;
                            if (!addedInnerClassNodes.contains(fRef.getOwner())) {
                                ClassNode outermostClassnode = node;
                                block8: while (true) {
                                    if (outermostClassnode.outerClass != null) {
                                        outermostClassnode = this.nameToNode.get(outermostClassnode.outerClass);
                                        continue;
                                    }
                                    for (InnerClassNode icn : outermostClassnode.innerClasses) {
                                        if (!icn.name.equals(outermostClassnode.name) || icn.outerName == null) continue;
                                        outermostClassnode = this.nameToNode.get(icn.outerName);
                                        continue block8;
                                    }
                                    break;
                                }
                                InnerClassNode innerClassNode = new InnerClassNode(fRef.getOwner(), outermostClassnode.name, null, 4120);
                                ClassNode switchmapNode = this.nameToNode.get(fRef.getOwner());
                                String currentNestParent = null;
                                for (InnerClassNode icn : switchmapNode.innerClasses) {
                                    if (!icn.name.equals(switchmapNode.name)) continue;
                                    currentNestParent = icn.outerName;
                                }
                                outermostClassnode.innerClasses.add(innerClassNode);
                                node.innerClasses.add(innerClassNode);
                                if (currentNestParent == null) {
                                    switchmapNode.innerClasses.add(innerClassNode);
                                } else if (!currentNestParent.equals(outermostClassnode.name)) {
                                    System.out.println("(WARN) Got a collision for switchmap class " + switchmapNode.name + " (" + newName + "). Currently: " + currentNestParent + ", proposed: " + outermostClassnode.name);
                                }
                            }
                        }
                    }
                    instruction = instruction.getNext();
                }
            }
        }
        return deobfNames.size();
    }

    public List<ClassNode> getClassNodesDirectly() {
        return this.nodes;
    }

    @Contract(value="-> new", pure=true)
    public Map<String, MethodReference> guessAnonymousClasses() {
        HashMap<String, MethodReference> anonymousClasses = new HashMap<String, MethodReference>();
        HashSet<String> potentialAnonymousClasses = new HashSet<String>();
        HashSet<FieldReference> syntheticFields = new HashSet<FieldReference>();
        block0: for (ClassNode node : this.nodes) {
            if ((node.access & 7) != 0) continue;
            if (node.innerClasses != null) {
                for (InnerClassNode icn : node.innerClasses) {
                    if (!icn.name.equals(node.name)) continue;
                    continue block0;
                }
            }
            potentialAnonymousClasses.add(node.name);
            for (FieldNode field : node.fields) {
                if ((field.access & 0x1000) == 0) continue;
                syntheticFields.add(new FieldReference(node.name, field));
            }
        }
        for (ClassNode node : this.nodes) {
            for (FieldNode field : node.fields) {
                String className;
                if ((field.access & 0x1000) != 0 || (className = Oaktree.getClassName(field.desc)) == null) continue;
                potentialAnonymousClasses.remove(className);
                anonymousClasses.remove(className);
            }
            for (MethodNode method : node.methods) {
                DescString descString = new DescString(method.desc);
                while (descString.hasNext()) {
                    String className = Oaktree.getClassName(descString.nextType());
                    if (className == null || className.equals(node.name)) continue;
                    potentialAnonymousClasses.remove(className);
                    anonymousClasses.remove(className);
                }
                if (method.instructions == null) continue;
                for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    if (insn instanceof FieldInsnNode) {
                        FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                        if (syntheticFields.contains(new FieldReference(fieldInsn))) continue;
                        String className = Oaktree.getClassName(fieldInsn.desc);
                        if (className != null && !className.equals(node.name)) {
                            potentialAnonymousClasses.remove(className);
                            anonymousClasses.remove(className);
                        }
                        if ((className = fieldInsn.owner) == null || className.equals(node.name)) continue;
                        potentialAnonymousClasses.remove(className);
                        anonymousClasses.remove(className);
                        continue;
                    }
                    if (!(insn instanceof MethodInsnNode)) continue;
                    MethodInsnNode methodInsn = (MethodInsnNode)insn;
                    if (methodInsn.name.equals("<init>")) {
                        if (anonymousClasses.containsKey(methodInsn.owner)) {
                            potentialAnonymousClasses.remove(methodInsn.owner);
                            anonymousClasses.remove(methodInsn.owner);
                            continue;
                        }
                        if (!potentialAnonymousClasses.contains(methodInsn.owner)) continue;
                        if (methodInsn.desc.startsWith(node.name, 2)) {
                            anonymousClasses.put(methodInsn.owner, new MethodReference(node.name, method));
                            continue;
                        }
                        anonymousClasses.remove(methodInsn.owner);
                        potentialAnonymousClasses.remove(methodInsn.owner);
                        continue;
                    }
                    String returnClass = Oaktree.getReturnedClass(methodInsn.desc);
                    if (returnClass != null) {
                        potentialAnonymousClasses.remove(returnClass);
                        anonymousClasses.remove(returnClass);
                    }
                    potentialAnonymousClasses.remove(methodInsn.owner);
                    anonymousClasses.remove(methodInsn.owner);
                }
            }
        }
        return anonymousClasses;
    }

    public Map<MethodReference, ClassWrapper> analyseLikelyMethodReturnCollectionGenerics() {
        final HashMap<MethodReference, ClassWrapper> signatures = new HashMap<MethodReference, ClassWrapper>();
        final HashMap stackSignatureTypes = new HashMap();
        for (ClassNode node : this.nodes) {
            for (MethodNode method : node.methods) {
                ClassWrapper returnType;
                String returnedClass;
                if ((method.access & 8) == 0 || method.signature != null || (returnedClass = Oaktree.getReturnedClass(method.desc)) == null || (returnType = this.wrapperPool.optGet(returnedClass)) == null || !returnType.getAllImplementatingInterfaces().contains("java/util/Collection")) continue;
                stackSignatureTypes.clear();
                final MethodReference methodRef = new MethodReference(node.name, method);
                StackWalker.walkStack(node, method, new StackWalker.StackWalkerConsumer(){

                    @Override
                    public void preCalculation(AbstractInsnNode instruction, LIFOQueue<StackElement> stack) {
                        ClassWrapper mergeSignature;
                        if (instruction instanceof MethodInsnNode) {
                            ClassWrapper methodOwner;
                            MethodInsnNode methodInsn = (MethodInsnNode)instruction;
                            if (methodInsn.name.equals("add") && (methodOwner = Oaktree.this.wrapperPool.get(methodInsn.owner)).getAllImplementatingInterfaces().contains("java/util/Collection")) {
                                StackElement collection = stack.getDelegateList().get(1);
                                StackElement insertedElement = stack.getHead();
                                ClassWrapper oldSignature = (ClassWrapper)stackSignatureTypes.get(collection);
                                ClassWrapper insertedElementWrapper = Oaktree.this.wrapperPool.get(insertedElement.type.substring(1, insertedElement.type.length() - 1));
                                ClassWrapper wrapper = oldSignature != null ? Oaktree.this.wrapperPool.getCommonSuperClass(insertedElementWrapper, oldSignature) : insertedElementWrapper;
                                stackSignatureTypes.put(collection, wrapper);
                            }
                        } else if (instruction.getOpcode() == 176 && (mergeSignature = (ClassWrapper)stackSignatureTypes.get(stack.getHead())) != null) {
                            ClassWrapper oldSignature = (ClassWrapper)signatures.get(methodRef);
                            if (oldSignature == null) {
                                signatures.put(methodRef, mergeSignature);
                            } else {
                                signatures.put(methodRef, Oaktree.this.wrapperPool.getCommonSuperClass(oldSignature, mergeSignature));
                            }
                        }
                    }

                    @Override
                    public void postCalculation(AbstractInsnNode instruction, LIFOQueue<StackElement> stack) {
                    }
                });
            }
        }
        signatures.values().removeIf(wrapper -> wrapper.getSuper() == null);
        return signatures;
    }

    public Map<String, String> getProposedLocalClassNames(String localClassNamePrefix, BiPredicate<String, String> condition, boolean applyInnerClassNodes) {
        HashMap<String, List> mappings = new HashMap<String, List>();
        HashSet unmappedInnerClasses = new HashSet();
        this.guessLocalClasses().forEach((inner, outer) -> {
            if (!condition.test((String)outer, (String)inner)) {
                return;
            }
            mappings.compute((String)outer, (key, list) -> {
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(inner);
                return list;
            });
            unmappedInnerClasses.add(inner);
        });
        HashMap<String, String> mappedNames = new HashMap<String, String>();
        while (unmappedInnerClasses.size() != 0) {
            int oldSize = unmappedInnerClasses.size();
            mappings.forEach((outer, inners) -> {
                if (unmappedInnerClasses.contains(outer)) {
                    return;
                }
                inners.sort(String::compareTo);
                int counter = 0;
                ClassNode outerNode = this.nameToNode.get(outer);
                for (String inner : inners) {
                    ClassNode innerNode = this.nameToNode.get(inner);
                    String innerName = localClassNamePrefix + counter++;
                    if (applyInnerClassNodes) {
                        InnerClassNode icn = new InnerClassNode(inner, outer, innerName, innerNode.access);
                        outerNode.innerClasses.add(icn);
                        innerNode.innerClasses.add(icn);
                    }
                    mappedNames.put(inner, mappedNames.getOrDefault(outer, (String)outer) + '$' + innerName);
                    unmappedInnerClasses.remove(inner);
                }
            });
            if (unmappedInnerClasses.size() != oldSize) continue;
            break;
        }
        return mappedNames;
    }

    public int guessAnonymousInnerClasses() {
        LinkedHashMap<String, AbstractMap.SimpleImmutableEntry<String, MethodNode>> candidates = new LinkedHashMap<String, AbstractMap.SimpleImmutableEntry<String, MethodNode>>();
        for (ClassNode node : this.nodes) {
            int dollarIndex;
            Object field2;
            if ((node.access & 7) != 0) continue;
            boolean skipClass = false;
            Object outerClassReference = null;
            for (Object field2 : node.fields) {
                if ((((FieldNode)field2).access & 0x1010) != 4112 || (((FieldNode)field2).access & 7) != 0) continue;
                if (outerClassReference != null) {
                    skipClass = true;
                    break;
                }
                outerClassReference = field2;
            }
            if (skipClass || outerClassReference == null) continue;
            MethodNode constructor = null;
            field2 = node.methods.iterator();
            while (field2.hasNext()) {
                MethodNode method = (MethodNode)field2.next();
                if (!method.name.equals("<init>")) continue;
                if (constructor != null) {
                    skipClass = true;
                    break;
                }
                if ((method.access & 7) != 0) {
                    skipClass = true;
                    break;
                }
                constructor = method;
            }
            if (skipClass || constructor == null) continue;
            DescString desc = new DescString(constructor.desc);
            skipClass = true;
            while (desc.hasNext()) {
                String type = desc.nextType();
                if (!type.equals(((FieldNode)outerClassReference).desc)) continue;
                skipClass = false;
                break;
            }
            if (skipClass || (dollarIndex = node.name.indexOf(36)) != -1 && !Character.isDigit(node.name.codePointAt(dollarIndex + 1))) continue;
            candidates.put(node.name, null);
        }
        for (ClassNode node : this.nodes) {
            for (MethodNode method : node.methods) {
                for (AbstractInsnNode instruction = method.instructions.getFirst(); instruction != null; instruction = instruction.getNext()) {
                    if (!(instruction instanceof MethodInsnNode) || !((MethodInsnNode)instruction).name.equals("<init>")) continue;
                    MethodInsnNode methodInvocation = (MethodInsnNode)instruction;
                    String owner = methodInvocation.owner;
                    if (!candidates.containsKey(owner)) continue;
                    if (owner.equals(node.name)) {
                        candidates.remove(owner);
                        continue;
                    }
                    Map.Entry invoker = (Map.Entry)((HashMap)candidates).get(owner);
                    if (invoker == null) {
                        candidates.put(owner, new AbstractMap.SimpleImmutableEntry<String, MethodNode>(node.name, method));
                        continue;
                    }
                    if (((String)invoker.getKey()).equals(node.name) && ((MethodNode)invoker.getValue()).name.equals(method.name) && ((MethodNode)invoker.getValue()).desc.equals(method.desc)) continue;
                    candidates.remove(owner);
                }
            }
        }
        for (ClassNode node : this.nodes) {
            for (FieldNode field : node.fields) {
                if (field.desc.length() == 1 || (field.access & 0x1000) != 0 || field.desc.codePointAt(field.desc.lastIndexOf(91) + 1) != 76) continue;
                String className = field.desc.substring(field.desc.lastIndexOf(91) + 2, field.desc.length() - 1);
                candidates.remove(className);
            }
        }
        int addedInners = 0;
        for (Map.Entry candidate : ((HashMap)candidates).entrySet()) {
            String inner = (String)candidate.getKey();
            Map.Entry outer = (Map.Entry)candidate.getValue();
            if (outer == null) continue;
            ClassNode innerNode = this.nameToNode.get(inner);
            if (innerNode == null) {
                throw new IllegalStateException("Unable to find class: " + inner);
            }
            ClassNode outernode = this.nameToNode.get(outer.getKey());
            MethodNode outerMethod = (MethodNode)outer.getValue();
            if (outernode == null) continue;
            boolean hasInnerClassInfoInner = false;
            boolean hasInnerClassInfoOuter = false;
            for (InnerClassNode icn : innerNode.innerClasses) {
                if (!icn.name.equals(inner)) continue;
                hasInnerClassInfoInner = true;
                break;
            }
            for (InnerClassNode icn : outernode.innerClasses) {
                if (!icn.name.equals(inner)) continue;
                hasInnerClassInfoOuter = true;
                break;
            }
            if (hasInnerClassInfoInner && hasInnerClassInfoOuter) continue;
            if (hasInnerClassInfoInner || hasInnerClassInfoOuter) {
                throw new IllegalStateException("Partially applied inner classes found");
            }
            InnerClassNode newInnerClassNode = new InnerClassNode(inner, outernode.name, null, 32);
            if (!hasInnerClassInfoInner) {
                innerNode.outerMethod = outerMethod.name;
                innerNode.outerMethodDesc = outerMethod.desc;
                innerNode.outerClass = outernode.name;
                innerNode.innerClasses.add(newInnerClassNode);
            }
            if (!hasInnerClassInfoOuter) {
                outernode.innerClasses.add(newInnerClassNode);
            }
            ++addedInners;
        }
        return addedInners;
    }

    public int guessFieldGenerics() {
        HashMap<FieldReference, SignatureNode> newFieldSignatures = new HashMap<FieldReference, SignatureNode>();
        int addedFieldSignatures = 0;
        for (ClassNode node : this.nodes) {
            for (FieldNode field : node.fields) {
                if (field.signature != null || !ITERABLES.contains(field.desc)) continue;
                newFieldSignatures.put(new FieldReference(node.name, field), null);
            }
        }
        for (ClassNode node : this.nodes) {
            for (MethodNode method : node.methods) {
                AbstractInsnNode instruction = method.instructions.getFirst();
                while (instruction != null) {
                    if (instruction instanceof FieldInsnNode) {
                        FieldInsnNode fieldNode = (FieldInsnNode)instruction;
                        FieldReference key = new FieldReference(fieldNode);
                        AbstractInsnNode next = instruction.getNext();
                        if (!newFieldSignatures.containsKey(key) || !(next instanceof MethodInsnNode)) {
                            instruction = next;
                            continue;
                        }
                        MethodInsnNode iteratorMethod = (MethodInsnNode)next;
                        next = next.getNext();
                        if (iteratorMethod.itf || !iteratorMethod.name.equals("iterator") || !iteratorMethod.desc.equals("()Ljava/util/Iterator;") || !(next instanceof VarInsnNode)) {
                            instruction = next;
                            continue;
                        }
                        VarInsnNode storeInstruction = (VarInsnNode)next;
                        if (!((next = next.getNext()) instanceof LabelNode)) {
                            instruction = next;
                            continue;
                        }
                        next = next.getNext();
                        while (next instanceof FrameNode || next instanceof LineNumberNode) {
                            next = next.getNext();
                        }
                        if (!(next instanceof VarInsnNode)) {
                            instruction = next;
                            continue;
                        }
                        VarInsnNode loadInstruction = (VarInsnNode)next;
                        next = next.getNext();
                        if (loadInstruction.var != storeInstruction.var || loadInstruction.getOpcode() != 25 || storeInstruction.getOpcode() != 58 || !(next instanceof MethodInsnNode)) {
                            instruction = next;
                            continue;
                        }
                        MethodInsnNode hasNextInstruction = (MethodInsnNode)next;
                        next = next.getNext();
                        if (!(hasNextInstruction.itf && hasNextInstruction.owner.equals("java/util/Iterator") && hasNextInstruction.name.equals("hasNext") && hasNextInstruction.desc.equals("()Z") && next instanceof JumpInsnNode)) {
                            instruction = next;
                            continue;
                        }
                        JumpInsnNode loopEndJump = (JumpInsnNode)next;
                        LabelNode loopEndLabel = loopEndJump.label;
                        if (!((next = next.getNext()) instanceof VarInsnNode)) {
                            instruction = next;
                            continue;
                        }
                        loadInstruction = (VarInsnNode)next;
                        next = next.getNext();
                        if (loadInstruction.var != storeInstruction.var || loadInstruction.getOpcode() != 25 || storeInstruction.getOpcode() != 58 || !(next instanceof MethodInsnNode)) {
                            instruction = next;
                            continue;
                        }
                        MethodInsnNode getNextInstruction = (MethodInsnNode)next;
                        next = next.getNext();
                        if (!(getNextInstruction.itf && getNextInstruction.owner.equals("java/util/Iterator") && getNextInstruction.name.equals("next") && getNextInstruction.desc.equals("()Ljava/lang/Object;") && next instanceof TypeInsnNode)) {
                            instruction = next;
                            continue;
                        }
                        TypeInsnNode checkCastInstruction = (TypeInsnNode)next;
                        next = next.getNext();
                        if (checkCastInstruction.getOpcode() != 192) {
                            instruction = next;
                            continue;
                        }
                        String suggestion = "L" + checkCastInstruction.desc + ";";
                        SignatureNode suggestedSignature = new SignatureNode(fieldNode.desc, suggestion);
                        SignatureNode currentlySuggested = (SignatureNode)newFieldSignatures.get(key);
                        instruction = next;
                        if (currentlySuggested != null) {
                            if (!suggestedSignature.equals(currentlySuggested)) {
                                --addedFieldSignatures;
                                System.out.println("Contested signatures for " + key);
                                newFieldSignatures.remove(key);
                                continue;
                            }
                        } else {
                            ++addedFieldSignatures;
                            newFieldSignatures.put(key, suggestedSignature);
                        }
                        if (!(next instanceof VarInsnNode) || next.getOpcode() != 58) continue;
                        VarInsnNode iteratedObject = (VarInsnNode)next;
                        List localVars = method.localVariables;
                        boolean alreadyDeclaredLVT = false;
                        for (LocalVariableNode var0 : localVars) {
                            if (var0.index != iteratedObject.var || !var0.desc.equals(suggestion)) continue;
                            alreadyDeclaredLVT = true;
                            break;
                        }
                        if (alreadyDeclaredLVT) continue;
                        LabelNode firstDeclaration = new LabelNode();
                        method.instructions.insertBefore((AbstractInsnNode)iteratedObject, (AbstractInsnNode)firstDeclaration);
                        LocalVariableNode lvtNode = new LocalVariableNode("var" + iteratedObject.var, suggestion, null, firstDeclaration, loopEndLabel, iteratedObject.var);
                        localVars.add(lvtNode);
                        continue;
                    }
                    instruction = instruction.getNext();
                }
            }
        }
        HashMap<FieldReference, AbstractMap.SimpleImmutableEntry<ClassWrapper, String>> collectionSignatures = new HashMap<FieldReference, AbstractMap.SimpleImmutableEntry<ClassWrapper, String>>();
        for (ClassNode classNode : this.nodes) {
            for (MethodNode method : classNode.methods) {
                AbstractInsnNode insn = method.instructions.getFirst();
                while (insn != null) {
                    if (insn instanceof FieldInsnNode) {
                        String signatureDesc;
                        AbstractInsnNode next = insn.getNext();
                        if (insn.getOpcode() != 180 && insn.getOpcode() != 178) {
                            insn = next;
                            continue;
                        }
                        FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                        FieldReference fref = new FieldReference(fieldInsn);
                        if (newFieldSignatures.get(fref) != null) {
                            insn = next;
                            continue;
                        }
                        if (collectionSignatures.containsKey(fref) && collectionSignatures.get(fref) == null) {
                            insn = next;
                            continue;
                        }
                        if (next == null || next.getOpcode() != 187) {
                            insn = next;
                            continue;
                        }
                        TypeInsnNode newInsn = (TypeInsnNode)next;
                        for (next = next.getNext(); !(next == null || next.getOpcode() == 183 && ((MethodInsnNode)next).name.equals("<init>") && ((MethodInsnNode)next).owner.equals(newInsn.desc)); next = next.getNext()) {
                        }
                        if (next == null) {
                            insn = newInsn.getNext();
                            continue;
                        }
                        if ((next = next.getNext()) == null || !(next instanceof MethodInsnNode)) {
                            insn = insn.getNext();
                            continue;
                        }
                        MethodInsnNode collectionAdd = (MethodInsnNode)next;
                        if (!collectionAdd.name.equals("add") || !COLLECTIONS.contains("L" + collectionAdd.owner + ";")) {
                            insn = next;
                            continue;
                        }
                        Type type = Type.getObjectType((String)newInsn.desc);
                        String internalClassName = type.getSort() == 9 ? type.getElementType().getInternalName() : type.getInternalName();
                        ClassWrapper wrapper = this.wrapperPool.get(internalClassName);
                        Map.Entry oldEntry = (Map.Entry)collectionSignatures.get(fref);
                        if (oldEntry != null) {
                            ClassWrapper common = this.wrapperPool.getCommonSuperClass(wrapper, (ClassWrapper)oldEntry.getKey());
                            if (common != wrapper) {
                                if (common == oldEntry.getKey()) {
                                    signatureDesc = (String)oldEntry.getValue();
                                } else {
                                    StringBuilder b = new StringBuilder();
                                    for (int i = 0; i < newInsn.desc.length() && newInsn.desc.codePointAt(i) == 91; ++i) {
                                        b.append('[');
                                    }
                                    b.append('L');
                                    b.append(common.getName());
                                    b.append(';');
                                    signatureDesc = b.toString();
                                }
                                wrapper = common;
                            } else {
                                signatureDesc = type.getDescriptor();
                            }
                            collectionSignatures.put(fref, new AbstractMap.SimpleImmutableEntry<ClassWrapper, String>(common, signatureDesc));
                        } else {
                            signatureDesc = type.getDescriptor();
                            collectionSignatures.put(fref, new AbstractMap.SimpleImmutableEntry<ClassWrapper, String>(wrapper, signatureDesc));
                        }
                    }
                    insn = insn.getNext();
                }
            }
        }
        for (Map.Entry entry : collectionSignatures.entrySet()) {
            ++addedFieldSignatures;
            newFieldSignatures.put((FieldReference)entry.getKey(), new SignatureNode(((FieldReference)entry.getKey()).getDesc(), (String)((Map.Entry)entry.getValue()).getValue()));
        }
        for (ClassNode classNode : this.nodes) {
            for (FieldNode field : classNode.fields) {
                SignatureNode result;
                if (field.signature != null || !ITERABLES.contains(field.desc) || (result = (SignatureNode)newFieldSignatures.get(new FieldReference(classNode.name, field))) == null) continue;
                field.signature = result.toString();
            }
        }
        return addedFieldSignatures;
    }

    public Map<String, String> guessLocalClasses() {
        HashMap<String, String> localClasses = new HashMap<String, String>();
        block0: for (ClassNode node : this.nodes) {
            for (InnerClassNode icn : node.innerClasses) {
                if (!icn.name.equals(node.name)) continue;
                continue block0;
            }
            String this0FieldDesc = null;
            String this0FieldName = null;
            for (Object method : node.methods) {
                if (!((MethodNode)method).name.equals("<init>")) continue;
                if (((MethodNode)method).desc.codePointAt(1) != 76) continue block0;
                String outerClassDesc = ((MethodNode)method).desc.substring(1, ((MethodNode)method).desc.indexOf(59, 3) + 1);
                if (this0FieldDesc != null && !outerClassDesc.equals(this0FieldDesc)) continue block0;
                this0FieldDesc = outerClassDesc;
                AbstractInsnNode insn = ((MethodNode)method).instructions.getFirst();
                while (insn.getOpcode() == -1) {
                    insn = insn.getNext();
                }
                if (insn.getOpcode() != 25 || ((VarInsnNode)insn).var != 0 || (insn = insn.getNext()).getOpcode() != 25 || ((VarInsnNode)insn).var != 1 || (insn = insn.getNext()).getOpcode() != 181) continue block0;
                FieldInsnNode putFieldInsn = (FieldInsnNode)insn;
                if (!this0FieldDesc.equals(putFieldInsn.desc) || this0FieldName != null && !this0FieldName.equals(putFieldInsn.name)) continue block0;
                this0FieldName = putFieldInsn.name;
            }
            if (this0FieldDesc == null || this0FieldName == null) continue;
            boolean resolvedField = false;
            for (FieldNode field : node.fields) {
                if ((field.access & 0x1000) == 0 || !field.name.equals(this0FieldName) || !field.desc.equals(this0FieldDesc)) continue;
                resolvedField = true;
                break;
            }
            if (!resolvedField) continue;
            int lastIndexOfSlash = node.name.lastIndexOf(47);
            if (this0FieldDesc.length() <= lastIndexOfSlash + 1 || this0FieldDesc.codePointAt(lastIndexOfSlash + 1) != 47 || !this0FieldDesc.startsWith(node.name.substring(0, lastIndexOfSlash), 1)) continue;
            localClasses.put(node.name, this0FieldDesc.substring(1, this0FieldDesc.length() - 1));
        }
        return localClasses;
    }

    public void index(JarFile file) {
        Enumeration<JarEntry> entries = file.entries();
        if (!entries.hasMoreElements()) {
            return;
        }
        JarEntry entry = entries.nextElement();
        while (entries.hasMoreElements()) {
            if (entry.getName().endsWith(".class")) {
                ClassReader reader;
                try {
                    InputStream is = file.getInputStream(entry);
                    reader = new ClassReader(is);
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                ClassNode node = new ClassNode();
                reader.accept((ClassVisitor)node, 0);
                this.nodes.add(node);
                this.nameToNode.put(node.name, node);
            }
            entry = entries.nextElement();
        }
    }

    public void inferConstructorGenerics() {
        HashMap constructors = new HashMap();
        for (ClassNode node : this.nodes) {
            block1: for (MethodNode method : node.methods) {
                if (method.signature != null || !method.name.equals("<init>") || method.desc.codePointAt(1) == 41) continue;
                DescString descString = new DescString(method.desc);
                while (descString.hasNext()) {
                    if (!ITERABLES.contains(descString.nextType())) continue;
                    constructors.put(new MethodReference(node.name, method), null);
                    continue block1;
                }
            }
        }
        for (ClassNode node : this.nodes) {
            for (MethodNode method : node.methods) {
                if (method.instructions == null) continue;
                AbstractInsnNode insn = method.instructions.getFirst();
                while (insn != null) {
                    if (insn.getOpcode() == 183) {
                        AbstractInsnNode insn2;
                        MethodInsnNode ctorCall = (MethodInsnNode)insn;
                        if (!ctorCall.name.equals("<init>")) {
                            insn = insn.getNext();
                            continue;
                        }
                        MethodReference ctorReference = new MethodReference(ctorCall);
                        if (!constructors.containsKey(ctorReference)) {
                            insn = insn.getNext();
                            continue;
                        }
                        TypeInsnNode newCall = null;
                        for (insn2 = insn.getPrevious(); insn2 != null; insn2 = insn2.getPrevious()) {
                            if (insn2.getOpcode() == 89) {
                                if (insn2.getPrevious().getOpcode() != 187) break;
                                TypeInsnNode new2 = (TypeInsnNode)insn2.getPrevious();
                                if (!new2.desc.equals(ctorReference.getOwner())) break;
                                newCall = new2;
                                break;
                            }
                            if (insn2.getOpcode() != 184 && insn2.getOpcode() != 178) break;
                        }
                        if (newCall == null || insn2 == null) {
                            insn = insn.getNext();
                            continue;
                        }
                        ArrayList<String> ourArgs = new ArrayList<String>();
                        insn2 = insn2.getNext();
                        boolean invalidate = false;
                        while (insn2 != ctorCall) {
                            if (insn2.getOpcode() == 184) {
                                MethodInsnNode invokestaticInsn = (MethodInsnNode)insn2;
                                if (invokestaticInsn.desc.codePointAt(1) != 41) {
                                    invalidate = true;
                                    break;
                                }
                                if (!ITERABLES.contains(invokestaticInsn.desc.substring(2))) {
                                    ourArgs.add(null);
                                    insn2 = insn2.getNext();
                                    continue;
                                }
                                ourArgs.add("");
                            } else if (insn2.getOpcode() == 178) {
                                FieldInsnNode getstaticInsn = (FieldInsnNode)insn2;
                                if (!ITERABLES.contains(getstaticInsn.desc)) {
                                    ourArgs.add(null);
                                    insn2 = insn2.getNext();
                                    continue;
                                }
                                ClassNode ownerNode = this.nameToNode.get(getstaticInsn.owner);
                                if (ownerNode == null) {
                                    ourArgs.add("");
                                    insn2 = insn2.getNext();
                                    continue;
                                }
                                String fetchedSignature = null;
                                for (FieldNode ownerField : ownerNode.fields) {
                                    if (!ownerField.name.equals(getstaticInsn.name) || !ownerField.desc.equals(getstaticInsn.desc)) continue;
                                    fetchedSignature = ownerField.signature;
                                    break;
                                }
                                if (fetchedSignature == null) {
                                    ourArgs.add("");
                                    insn2 = insn2.getNext();
                                    continue;
                                }
                                int startSign = fetchedSignature.indexOf(60);
                                int endSign = fetchedSignature.indexOf(62);
                                ourArgs.add(fetchedSignature.substring(startSign, endSign + 1));
                            }
                            insn2 = insn2.getNext();
                        }
                        if (!invalidate) {
                            List old = (List)constructors.get(ctorReference);
                            if (old != null) {
                                if (old.size() != ourArgs.size()) {
                                    throw new IllegalStateException("Argument sizes do not match.");
                                }
                                for (int i = 0; i < old.size(); ++i) {
                                    String oldElement = (String)old.get(i);
                                    String newElement = (String)ourArgs.get(i);
                                    if (oldElement == null || newElement == null) {
                                        ourArgs.set(i, null);
                                        continue;
                                    }
                                    if (newElement.isEmpty()) {
                                        ourArgs.set(i, oldElement);
                                        continue;
                                    }
                                    if (oldElement.isEmpty() || oldElement.equals(newElement)) continue;
                                    ourArgs.set(i, null);
                                }
                            }
                            constructors.put(ctorReference, ourArgs);
                        }
                    }
                    insn = insn.getNext();
                }
            }
        }
        HashMap<FieldReference, String> fieldSignatures = new HashMap<FieldReference, String>();
        StringBuilder signatureAssembler = new StringBuilder();
        for (ClassNode node : this.nodes) {
            for (MethodNode method : node.methods) {
                List argumentSignatures;
                if (method.signature != null || (argumentSignatures = (List)constructors.get(new MethodReference(node.name, method))) == null) continue;
                int[] parameterIndices = new int[argumentSignatures.size() + 1];
                DescString plainDescriptor = new DescString(method.desc);
                signatureAssembler.setLength(0);
                signatureAssembler.append('(');
                int paramIndex = 1;
                for (int i = 0; i < argumentSignatures.size(); ++i) {
                    String type = plainDescriptor.nextType();
                    if (type.codePointAt(0) == 76) {
                        parameterIndices[i + 1] = paramIndex++;
                        signatureAssembler.append(type.substring(0, type.length() - 1));
                        String argSignature = (String)argumentSignatures.get(i);
                        if (argSignature != null) {
                            signatureAssembler.append(argSignature);
                        }
                        signatureAssembler.append(';');
                        continue;
                    }
                    if (type.codePointAt(0) == 68 || type.codePointAt(0) == 74) {
                        parameterIndices[i + 1] = paramIndex;
                        paramIndex += 2;
                    } else {
                        parameterIndices[i + 1] = paramIndex++;
                    }
                    signatureAssembler.append(type);
                }
                if (plainDescriptor.hasNext()) {
                    System.err.println("Signature for method " + node.name + "." + method.name + method.desc + " could not be completed fully because some parameters are missing.");
                    continue;
                }
                signatureAssembler.append(')');
                signatureAssembler.append('V');
                method.signature = signatureAssembler.toString();
                boolean[] damagedParams = new boolean[argumentSignatures.size() + 1];
                int[] localToParam = new int[paramIndex];
                for (int i = 0; i < parameterIndices.length; ++i) {
                    localToParam[parameterIndices[i]] = i;
                }
                damagedParams[0] = true;
                int loadedParameter = -1;
                for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    if (insn instanceof VarInsnNode) {
                        VarInsnNode varInsn = (VarInsnNode)insn;
                        if (OPHelper.isVarLoad(varInsn.getOpcode())) {
                            if (varInsn.var < localToParam.length) {
                                loadedParameter = localToParam[varInsn.var];
                                if (loadedParameter < damagedParams.length) continue;
                                loadedParameter = -1;
                                continue;
                            }
                            loadedParameter = -1;
                            continue;
                        }
                        if (varInsn.var >= localToParam.length || localToParam[varInsn.var] >= damagedParams.length) continue;
                        damagedParams[localToParam[varInsn.var]] = true;
                        continue;
                    }
                    if (insn instanceof FieldInsnNode) {
                        FieldInsnNode fieldInsn;
                        if (loadedParameter >= damagedParams.length || loadedParameter == -1 || damagedParams[loadedParameter] || (fieldInsn = (FieldInsnNode)insn).getOpcode() != 181 && fieldInsn.getOpcode() != 179) continue;
                        FieldReference fref = new FieldReference(fieldInsn);
                        if (fieldSignatures.containsKey(fref)) {
                            String oldProposal = (String)fieldSignatures.get(fref);
                            String suggested = (String)argumentSignatures.get(loadedParameter - 1);
                            if (oldProposal == null || suggested == null || suggested.isEmpty() || oldProposal.equals(suggested)) continue;
                            fieldSignatures.put(fref, null);
                            continue;
                        }
                        fieldSignatures.put(fref, (String)argumentSignatures.get(loadedParameter - 1));
                        continue;
                    }
                    loadedParameter = -1;
                }
            }
        }
        for (ClassNode node : this.nodes) {
            for (FieldNode field : node.fields) {
                FieldReference fref;
                String suggested;
                if (field.signature != null || (suggested = (String)fieldSignatures.get(fref = new FieldReference(node.name, field))) == null) continue;
                signatureAssembler.setLength(0);
                signatureAssembler.append(field.desc.substring(0, field.desc.length() - 1)).append(suggested).append(';');
                field.signature = signatureAssembler.toString();
            }
        }
    }

    public int inferMethodGenerics() {
        int addedMethodSignatures = 0;
        HashMap<FieldReference, ArrayList<MethodNode>> getterRefs = new HashMap<FieldReference, ArrayList<MethodNode>>();
        for (ClassNode classNode : this.nodes) {
            for (MethodNode method : classNode.methods) {
                AbstractInsnNode insn;
                String rawObject;
                String returnValue;
                int indexOfL;
                if (method.signature != null || method.instructions.size() == 0 || method.desc.codePointAt(1) != 41 || (indexOfL = (returnValue = method.desc.substring(2)).indexOf(76)) == -1 || !ITERABLES.contains(rawObject = returnValue.substring(indexOfL))) continue;
                for (insn = method.instructions.getLast().getPrevious(); insn != null && insn.getOpcode() != 176; insn = insn.getPrevious()) {
                }
                if (insn != null || !((insn = method.instructions.getLast().getPrevious()) instanceof FieldInsnNode)) continue;
                ArrayList<MethodNode> old = (ArrayList<MethodNode>)getterRefs.get(new FieldReference((FieldInsnNode)insn));
                if (old == null) {
                    old = new ArrayList<MethodNode>();
                    getterRefs.put(new FieldReference((FieldInsnNode)insn), old);
                }
                old.add(method);
            }
        }
        for (ClassNode node : this.nodes) {
            for (FieldNode field : node.fields) {
                List references;
                if (field.signature == null || !ITERABLES.contains(field.desc) || (references = (List)getterRefs.get(new FieldReference(node.name, field))) == null) continue;
                for (MethodNode reference : references) {
                    reference.signature = "()" + field.signature;
                    ++addedMethodSignatures;
                }
            }
        }
        return addedMethodSignatures;
    }

    public void invalidateNameCaches() {
        this.nameToNode.clear();
        for (ClassNode node : this.nodes) {
            this.nameToNode.put(node.name, node);
        }
        this.wrapperPool.invalidateNameCaches();
    }

    public void lambdaStreamGenericSignatureGuessing(Map<FieldReference, ClassWrapper> fields, Map<MethodReference, ClassWrapper> methods) {
        for (ClassNode node : this.nodes) {
            for (MethodNode method : node.methods) {
                if (method.instructions == null) continue;
                AbstractInsnNode insn = method.instructions.getFirst();
                while (insn != null) {
                    ClassWrapper old;
                    ClassWrapper cw;
                    ClassWrapper streamInsnOwner;
                    if (!(insn instanceof FieldInsnNode && fields != null || insn instanceof MethodInsnNode && methods != null)) {
                        insn = insn.getNext();
                        continue;
                    }
                    AbstractInsnNode source = insn;
                    insn = source.getNext();
                    while (insn.getOpcode() == -1) {
                        insn = insn.getNext();
                    }
                    if (insn.getOpcode() != 185 && insn.getOpcode() != 182) continue;
                    MethodInsnNode streamInsn = (MethodInsnNode)insn;
                    if (!streamInsn.name.equals("stream") || !streamInsn.desc.equals("()Ljava/util/stream/Stream;") || (streamInsnOwner = this.wrapperPool.optGet(streamInsn.owner)) == null || !streamInsnOwner.getAllImplementatingInterfaces().contains("java/util/Collection")) continue;
                    insn = streamInsn.getNext();
                    while (insn.getOpcode() == -1) {
                        insn = insn.getNext();
                    }
                    if (!(insn instanceof InvokeDynamicInsnNode)) continue;
                    InvokeDynamicInsnNode streamOp = (InvokeDynamicInsnNode)insn;
                    Type desc = (Type)streamOp.bsmArgs[streamOp.bsmArgs.length - 1];
                    DescString descString2 = new DescString(desc.getDescriptor());
                    if (!descString2.hasNext()) continue;
                    String arg = descString2.nextType();
                    if (descString2.hasNext() || (cw = this.wrapperPool.optGet(arg.substring(1, arg.length() - 1))) == null) continue;
                    if (source instanceof FieldInsnNode) {
                        FieldReference fref = new FieldReference((FieldInsnNode)source);
                        old = fields.get(fref);
                        if (old != null) {
                            cw = this.wrapperPool.getCommonSuperClass(cw, old);
                        }
                        fields.put(fref, cw);
                    } else if (source instanceof MethodInsnNode) {
                        MethodReference mref = new MethodReference((MethodInsnNode)source);
                        old = methods.get(mref);
                        if (old != null) {
                            cw = this.wrapperPool.getCommonSuperClass(cw, old);
                        }
                        methods.put(mref, cw);
                    }
                    insn = insn.getNext();
                }
            }
        }
    }

    public void write(OutputStream out) throws IOException {
        JarOutputStream jarOut = new JarOutputStream(out);
        for (ClassNode node : this.nodes) {
            ClassWriter writer = new ClassWriter(0);
            node.accept((ClassVisitor)writer);
            jarOut.putNextEntry(new ZipEntry(node.name + ".class"));
            jarOut.write(writer.toByteArray());
            jarOut.closeEntry();
        }
        jarOut.close();
    }

    public void write(@NotNull OutputStream out, @NotNull Path resources) throws IOException {
        if (Files.notExists(resources, new LinkOption[0])) {
            throw new IOException("The path (" + resources.toString() + ") specified by \"resources\" does not exist.");
        }
        JarOutputStream jarOut = new JarOutputStream(out);
        for (ClassNode node : this.nodes) {
            ClassWriter writer = new ClassWriter(0);
            node.accept((ClassVisitor)writer);
            jarOut.putNextEntry(new ZipEntry(node.name + ".class"));
            jarOut.write(writer.toByteArray());
            jarOut.closeEntry();
        }
        try (ZipInputStream zipIn = new ZipInputStream(Files.newInputStream(resources, new OpenOption[0]));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                block20: {
                    block18: {
                        int ch4;
                        int ch3;
                        int ch2;
                        int ch1;
                        block19: {
                            if (!entry.getName().endsWith(".class")) break block18;
                            ch1 = zipIn.read();
                            if ((ch1 | (ch2 = zipIn.read()) | (ch3 = zipIn.read()) | (ch4 = zipIn.read())) >= 0) break block19;
                            jarOut.putNextEntry(entry);
                            if (ch1 != -1) {
                                jarOut.write(ch1);
                                if (ch2 != -1) {
                                    jarOut.write(ch2);
                                    if (ch3 != -1) {
                                        jarOut.write(ch3);
                                        if (ch4 != -1) {
                                            throw new IOException(String.format("Unexpected header: [%d, %d, %d, %d]", ch1, ch2, ch3, ch4));
                                        }
                                    }
                                }
                            }
                            break block20;
                        }
                        if (ch1 == 202 && ch2 == 254 && ch3 == 186 && ch4 == 190) break block20;
                    }
                    jarOut.putNextEntry(entry);
                    JavaInterop.transferTo(zipIn, jarOut);
                }
                entry = zipIn.getNextEntry();
            }
        }
        jarOut.close();
    }
}

