/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.deobf;

import de.geolykt.starloader.deobf.ClassWrapperPool;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ClassWrapper {
    private final boolean itf;
    private final String name;
    private final ClassWrapperPool pool;
    private final String[] superInterfaces;
    private final String superName;
    private Set<String> allInterfacesCache;

    protected ClassWrapper(String name, String superName, String[] superInterfaces, boolean isInterface, ClassWrapperPool pool) {
        this.name = name;
        this.pool = pool;
        if (name.equals("java/lang/Object")) {
            this.itf = false;
            this.superInterfaces = new String[0];
            this.superName = null;
        } else {
            this.superName = superName;
            this.superInterfaces = superInterfaces;
            this.itf = isInterface;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassWrapper) {
            return ((ClassWrapper)obj).getName().equals(this.getName());
        }
        return false;
    }

    public Set<String> getAllImplementatingInterfaces() {
        if (this.allInterfacesCache == null) {
            if (this.superName == null) {
                this.allInterfacesCache = Collections.emptySet();
                return this.allInterfacesCache;
            }
            this.allInterfacesCache = new HashSet<String>();
            for (String interfaceName : this.getSuperInterfacesName()) {
                this.allInterfacesCache.addAll(this.pool.get(interfaceName).getAllImplementatingInterfaces());
            }
            if (this.itf) {
                this.allInterfacesCache.add(this.name);
            } else {
                this.allInterfacesCache.addAll(this.pool.get(this.superName).getAllImplementatingInterfaces());
            }
        }
        return this.allInterfacesCache;
    }

    public String getName() {
        return this.name;
    }

    public String getSuper() {
        return this.superName;
    }

    public String[] getSuperInterfacesName() {
        return this.superInterfaces;
    }

    public ClassWrapper getSuperWrapper() {
        String superName = this.getSuper();
        if (superName == null) {
            throw new IllegalStateException(this.name + " does not have a super type.");
        }
        return this.pool.get(superName);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isInterface() {
        return this.itf;
    }

    public String toString() {
        return String.format("ClassWrapper[name=%s, itf=%b, extends=%s, implements=%s]", this.name, this.itf, this.superName, Arrays.toString(this.superInterfaces));
    }
}

