/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.deobf;

import de.geolykt.starloader.deobf.ClassWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.tree.ClassNode;

public class ClassWrapperPool {
    protected final ClassLoader loader;
    protected final Map<String, ClassNode> nodes;
    protected final Map<String, ClassWrapper> wrappers;

    public ClassWrapperPool(Map<String, ClassNode> nodes, ClassLoader cl) {
        this.nodes = nodes;
        this.wrappers = new HashMap<String, ClassWrapper>();
        this.loader = cl;
    }

    public void addClassnode(ClassNode node) {
        this.nodes.put(node.name, node);
    }

    public boolean canAssign(ClassWrapper superType, ClassWrapper subType) {
        String name = superType.getName();
        if (superType.isInterface()) {
            return this.isImplementingInterface(subType, name);
        }
        while (subType != null) {
            if (name.equals(subType.getName()) || name.equals(subType.getSuper())) {
                return true;
            }
            if (subType.getName().equals("java/lang/Object")) {
                return false;
            }
            subType = subType.getSuperWrapper();
        }
        return false;
    }

    public ClassWrapper get(String className) {
        ClassWrapper wrapper = this.wrappers.get(className);
        if (wrapper != null) {
            return wrapper;
        }
        if (className.equals("java/lang/Object")) {
            wrapper = new ClassWrapper("java/lang/Object", null, new String[0], false, this);
            this.wrappers.put("java/lang/Object", wrapper);
            return wrapper;
        }
        ClassNode asmNode = this.nodes.get(className);
        if (asmNode == null) {
            Class<?> clazz;
            try {
                clazz = Class.forName(className.replace('/', '.'), false, this.loader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Unable to resolve class: " + className, e);
            }
            boolean itf = clazz.isInterface();
            String superName = itf ? "java/lang/Object" : clazz.getSuperclass().getName().replace('.', '/');
            Class<?>[] interfaces = clazz.getInterfaces();
            String[] superInterfaces = new String[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                superInterfaces[i] = interfaces[i].getName().replace('.', '/');
            }
            wrapper = new ClassWrapper(className, superName, superInterfaces, itf, this);
            this.wrappers.put(className, wrapper);
            return wrapper;
        }
        String[] superInterfaces = asmNode.interfaces.toArray(new String[0]);
        boolean itf = (asmNode.access & 0x200) != 0;
        wrapper = new ClassWrapper(className, asmNode.superName, superInterfaces, itf, this);
        this.wrappers.put(className, wrapper);
        return wrapper;
    }

    public ClassWrapper getCommonSuperClass(ClassWrapper class1, ClassWrapper class2) {
        if (class1.getName().equals("java/lang/Object")) {
            return class1;
        }
        if (class2.getName().equals("java/lang/Object")) {
            return class2;
        }
        if (this.canAssign(class1, class2)) {
            return class1;
        }
        if (this.canAssign(class2, class1)) {
            return class2;
        }
        if (class1.isInterface() || class2.isInterface()) {
            return this.get("java/lang/Object");
        }
        return this.getCommonSuperClass(class1, this.get(class2.getSuper()));
    }

    public void invalidateNameCaches() {
        ArrayList<ClassNode> nodes = new ArrayList<ClassNode>(this.nodes.values());
        this.nodes.clear();
        this.wrappers.clear();
        for (ClassNode node : nodes) {
            this.addClassnode(node);
        }
    }

    public boolean isImplementingInterface(ClassWrapper clazz, String interfaceName) {
        if (clazz.getName().equals("java/lang/Object")) {
            return false;
        }
        for (String interfaces : clazz.getSuperInterfacesName()) {
            if (interfaces.equals(interfaceName)) {
                return true;
            }
            if (!this.isImplementingInterface(this.get(interfaces), interfaceName)) continue;
            return true;
        }
        if (clazz.isInterface()) {
            return false;
        }
        return this.isImplementingInterface(clazz.getSuperWrapper(), interfaceName);
    }

    public ClassWrapper optGet(String className) {
        ClassWrapper wrapper = this.wrappers.get(className);
        if (wrapper != null) {
            return wrapper;
        }
        if (className.equals("java/lang/Object")) {
            wrapper = new ClassWrapper("java/lang/Object", null, new String[0], false, this);
            this.wrappers.put("java/lang/Object", wrapper);
            return wrapper;
        }
        ClassNode asmNode = this.nodes.get(className);
        if (asmNode == null) {
            Class<?> clazz;
            try {
                clazz = Class.forName(className.replace('/', '.'), false, this.loader);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            boolean itf = clazz.isInterface();
            String superName = itf ? "java/lang/Object" : clazz.getSuperclass().getName().replace('.', '/');
            Class<?>[] interfaces = clazz.getInterfaces();
            String[] superInterfaces = new String[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                superInterfaces[i] = interfaces[i].getName().replace('.', '/');
            }
            wrapper = new ClassWrapper(className, superName, superInterfaces, itf, this);
            this.wrappers.put(className, wrapper);
            return wrapper;
        }
        String[] superInterfaces = asmNode.interfaces.toArray(new String[0]);
        boolean itf = (asmNode.access & 0x200) != 0;
        wrapper = new ClassWrapper(className, asmNode.superName, superInterfaces, itf, this);
        this.wrappers.put(className, wrapper);
        return wrapper;
    }
}

