/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve.exclusion;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.stianloader.picoresolve.exclusion.Excluder;

public class ExclusionContainer<T extends Excluder>
implements Excluder {
    @NotNull
    public static final ExclusionContainer<?> EMPTY = new ExclusionContainer(ExclusionMode.ALL, Collections.emptyList(), false);
    @NotNull
    private final @NotNull List<@NotNull T> children = new CopyOnWriteArrayList<T>();
    @NotNull
    private final ExclusionMode mode;
    private final boolean mutable;

    @NotNull
    public static <T extends Excluder> ExclusionContainer<T> empty() {
        return EMPTY;
    }

    public ExclusionContainer(@NotNull ExclusionMode mode) {
        this.mutable = true;
        this.mode = Objects.requireNonNull(mode, "\"mode\" may not be null");
    }

    public ExclusionContainer(@NotNull ExclusionMode mode, @NotNull @NotNull Collection<@NotNull ? extends T> exclusions, boolean mutable) {
        this.children.addAll(exclusions);
        this.mutable = mutable;
        this.mode = Objects.requireNonNull(mode, "\"mode\" may not be null");
    }

    public ExclusionContainer<T> addChild(@NotNull T child) {
        if (!this.mutable) {
            throw new IllegalStateException("Container is not mutable.");
        }
        this.children.add(child);
        return this;
    }

    @Contract(pure=true)
    @NotNull
    public ExclusionMode getMode() {
        return this.mode;
    }

    @Override
    public boolean isExcluding(String group, String artifact) {
        if (this.mode == ExclusionMode.ALL) {
            if (this.children.isEmpty()) {
                return false;
            }
            for (Excluder child : this.children) {
                if (child.isExcluding(group, artifact)) continue;
                return false;
            }
            return true;
        }
        for (Excluder child : this.children) {
            if (!child.isExcluding(group, artifact)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public boolean isMutable() {
        return this.mutable;
    }

    public static enum ExclusionMode {
        ALL,
        ANY;

    }
}

