/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.util.smap;

import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.micromixin.transform.internal.util.smap.AbstractSMAPSection;

public class FileSection
extends AbstractSMAPSection {
    private final List<FileSectionEntry> entries;

    public FileSection(List<FileSectionEntry> entries) {
        this.entries = entries;
    }

    @Override
    @NotNull
    @Contract(mutates="param1", pure=false, value="!null -> param1; null -> fail")
    public StringBuilder pushContents(@NotNull StringBuilder sharedBuilder) {
        sharedBuilder.append("*F\r");
        for (FileSectionEntry entry : this.entries) {
            entry.pushContents(sharedBuilder);
        }
        return sharedBuilder;
    }

    public static class FileSectionEntry {
        private final int sourceId;
        @NotNull
        private final String sourceName;
        @Nullable
        private final String sourcePath;

        public FileSectionEntry(int sourceId, @NotNull String sourceName, @Nullable String sourcePath) {
            this.sourceId = sourceId;
            this.sourceName = sourceName;
            this.sourcePath = sourcePath;
        }

        @NotNull
        @Contract(mutates="param1", pure=false, value="!null -> param1; null -> fail")
        public StringBuilder pushContents(@NotNull StringBuilder sharedBuilder) {
            if (this.sourcePath == null) {
                sharedBuilder.append(this.sourceId).appendCodePoint(32).append(this.sourceName);
            } else {
                sharedBuilder.append("+ ").append(this.sourceId).appendCodePoint(32).append(this.sourceName).appendCodePoint(13).append(this.sourcePath);
            }
            sharedBuilder.appendCodePoint(13);
            return sharedBuilder;
        }
    }
}

