/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.selfmodification;

import de.geolykt.starloader.launcher.Utils;
import de.geolykt.starloader.util.JavaInterop;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import net.minestom.server.extras.selfmodification.HierarchyClassLoader;
import net.minestom.server.extras.selfmodification.MinestomRootClassLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public class MinestomExtensionClassLoader
extends HierarchyClassLoader {
    private final MinestomRootClassLoader root;
    private static final boolean DEBUG = Boolean.getBoolean("classloader.debug");
    private static final boolean DUMP = DEBUG || Boolean.getBoolean("classloader.dump");

    public MinestomExtensionClassLoader(String name, URL[] urls, MinestomRootClassLoader root) {
        super(name, urls, root);
        this.root = root;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Class<HierarchyClassLoader> clazz = HierarchyClassLoader.class;
        synchronized (HierarchyClassLoader.class) {
            for (HierarchyClassLoader parent : this.parents) {
                parent.removeChildInHierarchy(this);
            }
            this.parents.clear();
            for (MinestomExtensionClassLoader cl : new ArrayList(this.children)) {
                LoggerFactory.getLogger(MinestomExtensionClassLoader.class).info("Closing classloader {} as it is a child of classloader {}, which is getting closed", (Object)cl.getName(), (Object)this.getName());
                cl.close();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            super.close();
            return;
        }
    }

    @Override
    @NotNull
    public Class<?> loadClass(@NotNull String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    @NotNull
    protected Class<?> loadClass(@NotNull String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.loadClassAsChild(name, resolve);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                return this.root.loadClass(name, resolve);
            }
            catch (ClassNotFoundException e) {
                e.addSuppressed(cnfe);
                throw e;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Class<?> loadClassAsChild(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null) {
            return loadedClass;
        }
        if (this.root.isProtected(name)) {
            throw new ClassNotFoundException("The MinestomExtensionClassLoader is not permitted to load this class as it is protected by the root classloader.");
        }
        try {
            String path = name.replace(".", "/") + ".class";
            URL url = this.findResource(path);
            if (url == null) {
                throw new ClassNotFoundException("Could not find class " + name);
            }
            try (InputStream in = url.openStream();){
                String urlPath;
                int seperatorIndex;
                if (in == null) {
                    throw new AssertionError();
                }
                byte[] bytes = JavaInterop.readAllBytes(in);
                bytes = this.root.transformBytes(bytes, name, Utils.toCodeSourceURI(url, name));
                if (DUMP) {
                    Path parent = Paths.get("classes", path).getParent();
                    if (parent != null) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    Files.write(Paths.get("classes", path), bytes, new OpenOption[0]);
                }
                if ((seperatorIndex = (urlPath = url.getPath()).lastIndexOf(33)) != -1) {
                    url = new URL(urlPath.substring(0, seperatorIndex));
                }
                Class<?> clazz = super.defineClass(name, bytes, 0, bytes.length, new CodeSource(url, (CodeSigner[])null));
                if (resolve) {
                    super.resolveClass(clazz);
                }
                Class<?> clazz2 = clazz;
                return clazz2;
            }
            catch (Throwable e) {
                throw new ClassNotFoundException("Could not load class " + name, e);
            }
        }
        catch (ClassNotFoundException e) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                MinestomExtensionClassLoader child = (MinestomExtensionClassLoader)iterator.next();
                try {
                    return child.loadClassAsChild(name, resolve);
                }
                catch (ClassNotFoundException e1) {
                    e.addSuppressed(e1);
                }
            }
            throw e;
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected void finalize() throws Throwable {
        super.finalize();
        System.err.println("Class loader " + this.getName() + " finalized.");
    }

    public String toString() {
        return "Extension classloader '" + this.getName() + "'@" + Integer.toHexString(this.hashCode()).toUpperCase(Locale.ROOT);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

