/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.transformer.impl;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.annotations.CTarget;
import net.lenni0451.classtransform.annotations.injection.CWrapCondition;
import net.lenni0451.classtransform.exceptions.InvalidTargetException;
import net.lenni0451.classtransform.exceptions.TransformerException;
import net.lenni0451.classtransform.targets.IInjectionTarget;
import net.lenni0451.classtransform.transformer.coprocessor.AnnotationCoprocessorList;
import net.lenni0451.classtransform.transformer.impl.wrapcondition.CWrapConditionField;
import net.lenni0451.classtransform.transformer.impl.wrapcondition.CWrapConditionMethod;
import net.lenni0451.classtransform.transformer.types.RemovingTargetAnnotationHandler;
import net.lenni0451.classtransform.utils.Types;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
public class CWrapConditionAnnotationHandler
extends RemovingTargetAnnotationHandler<CWrapCondition> {
    private final CWrapConditionField wrapConditionField = new CWrapConditionField();
    private final CWrapConditionMethod wrapConditionMethod = new CWrapConditionMethod();

    public CWrapConditionAnnotationHandler() {
        super(CWrapCondition.class, CWrapCondition::method);
    }

    @Override
    public void transform(CWrapCondition annotation, TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod, MethodNode target) {
        AnnotationCoprocessorList coprocessors = transformerManager.getCoprocessors();
        transformerMethod = coprocessors.preprocess(transformerManager, transformedClass, target, transformer, transformerMethod);
        if (Modifier.isStatic(target.access) != Modifier.isStatic(transformerMethod.access)) {
            throw TransformerException.wrongStaticAccess(transformerMethod, transformer, Modifier.isStatic(target.access));
        }
        if (!Types.returnType(transformerMethod).equals((Object)Type.BOOLEAN_TYPE)) {
            throw new TransformerException(transformerMethod, transformer, "must return 'boolean'");
        }
        MethodNode copiedTransformerMethod = null;
        Map<String, IInjectionTarget> injectionTargets = transformerManager.getInjectionTargets();
        ArrayList<MethodInsnNode> transformerMethodCalls = new ArrayList<MethodInsnNode>();
        for (CTarget wrapTarget : annotation.target()) {
            IInjectionTarget injectionTarget = injectionTargets.get(wrapTarget.value().toUpperCase(Locale.ROOT));
            if (injectionTarget == null) {
                throw new InvalidTargetException(transformerMethod, transformer, wrapTarget.target(), injectionTargets.keySet());
            }
            List<AbstractInsnNode> targetInstructions = injectionTarget.getTargets(injectionTargets, target, wrapTarget, annotation.slice());
            if (targetInstructions.isEmpty()) {
                throw new TransformerException(transformerMethod, transformer, "No valid method/field target found");
            }
            if (copiedTransformerMethod == null) {
                copiedTransformerMethod = this.renameAndCopy(transformerMethod, target, transformer, transformedClass, "CWrapCondition");
            }
            for (AbstractInsnNode targetInstruction : targetInstructions) {
                if (targetInstruction instanceof FieldInsnNode) {
                    if (targetInstruction.getOpcode() != 179 && targetInstruction.getOpcode() != 181) {
                        throw new TransformerException(transformerMethod, transformer, "target must be a field getter");
                    }
                    transformerMethodCalls.add(this.wrapConditionField.inject(transformedClass, transformer, copiedTransformerMethod, target, (FieldInsnNode)targetInstruction));
                    continue;
                }
                if (targetInstruction instanceof MethodInsnNode) {
                    if (!Types.returnType(((MethodInsnNode)targetInstruction).desc).equals((Object)Type.VOID_TYPE)) {
                        throw new TransformerException(transformerMethod, transformer, "target method must have void as return type");
                    }
                    transformerMethodCalls.add(this.wrapConditionMethod.inject(transformedClass, transformer, copiedTransformerMethod, target, (MethodInsnNode)targetInstruction));
                    continue;
                }
                throw new TransformerException(transformerMethod, transformer, "Target is not a valid method/field invocation");
            }
        }
        if (copiedTransformerMethod == null) {
            throw new TransformerException(transformerMethod, transformer, "No valid target found");
        }
        coprocessors.postprocess(transformerManager, transformedClass, target, transformerMethodCalls, transformer, copiedTransformerMethod);
    }
}

