/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.ras;

import de.geolykt.starloader.ras.AccessUtil;
import de.geolykt.starloader.ras.JavaInterop;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReversibleAccessSetterContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReversibleAccessSetterContext.class);
    @NotNull
    private final ConcurrentMap<String, RASClassContext> classes = new ConcurrentHashMap<String, RASClassContext>();
    private final boolean forcedSilence;
    @NotNull
    private final RASTransformScope scope;

    private static void addTransform(@NotNull @NotNull List<@NotNull RASAccessTransform> transforms, int originAccess, int targetAccess, int targetType, int failType, String sourceNamespace) {
        for (RASAccessTransform transform : transforms) {
            if (transform.originAccess != originAccess || transform.targetAccess != targetAccess || transform.targetType != targetType) continue;
            if (transform.failType < failType) {
                transform.failType = failType;
            }
            transform.sources.add(sourceNamespace);
            return;
        }
        transforms.add(new RASAccessTransform(originAccess, targetAccess, targetType, failType, sourceNamespace));
    }

    public ReversibleAccessSetterContext(@NotNull RASTransformScope activeScope, boolean forcedSilence) {
        if (activeScope == RASTransformScope.ALL) {
            throw new IllegalArgumentException("RASTransformScope may not be 'ALL'.");
        }
        this.scope = activeScope;
        this.forcedSilence = forcedSilence;
    }

    public void accept(@NotNull ClassNode node) throws RASTransformFailure {
        RASClassContext ctx = (RASClassContext)this.classes.get(node.name);
        if (ctx != null) {
            ctx.accept(node);
        }
        for (InnerClassNode icn : node.innerClasses) {
            RASClassContext innerCtx = (RASClassContext)this.classes.get(icn.name);
            if (innerCtx == null) continue;
            for (RASAccessTransform transform : innerCtx.selfTransforms) {
                long result = AccessUtil.applyAccess(icn.access, 0, transform);
                if ((result & 0xFFFFFFFF00000000L) != 0L) continue;
                icn.access = (int)result;
            }
        }
    }

    public boolean isTarget(@NotNull String internalName) {
        return this.classes.containsKey(internalName);
    }

    public void read(@NotNull String namespace, @NotNull BufferedReader reader, boolean reversed) throws IOException {
        String header = reader.readLine();
        int lineNumber = 1;
        while (header != null && (JavaInterop.isBlank(header) || header.codePointAt(0) == 35)) {
            header = reader.readLine();
            ++lineNumber;
        }
        if (header == null) {
            throw new IOException("Input stream exhausted before reaching RAS header for namespace " + namespace + ".");
        }
        if (!header.startsWith("RAS")) {
            throw new IOException("Malformed ReversibleAccessSetter header of namespace " + namespace + ": Syntax error at line " + lineNumber + ": RAS header should begin with \"RAS\"");
        }
        String[] headerSplits = header.split("\\s+");
        if (headerSplits.length != 3) {
            throw new IOException("Malformed ReversibleAccessSetter of namespace " + namespace + ": Syntax error at line " + lineNumber + ": Expected format \"RAS <format-version> <format-dialect>\".");
        }
        String requestedFormatVersion = headerSplits[1];
        String requestedDialect = headerSplits[2];
        if (!(requestedFormatVersion.equals("v1") || requestedFormatVersion.equals("1") || requestedFormatVersion.equals("v1.0") || requestedFormatVersion.equals("1.1"))) {
            throw new IOException("ReversibleAccessSetter of namespace " + namespace + " has format version " + requestedFormatVersion + ", but this RAS implementation only supports one of ['1', 'v1', '1.1', 'v1.1'].");
        }
        if (!requestedDialect.equals("std") && !requestedDialect.equals("starrian")) {
            throw new IOException("ReversibleAccessSetter of namespace " + namespace + " has format dialect " + requestedDialect + ", but this RAS implementation only supports one of ['std', 'starrian'].");
        }
        ++lineNumber;
        String line = reader.readLine();
        while (line != null) {
            if (!JavaInterop.isBlank(line) && line.codePointAt(0) != 35) {
                RASTransformScope rasScope;
                String[] parts;
                if (line.length() < 9) {
                    throw new IOException("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace \"" + namespace + "\": The smallest possible line length is 9 characters, but got " + line.length() + " chars instead.");
                }
                int prefix = line.codePointAt(0);
                int failType = 1;
                if (!Character.isWhitespace(prefix)) {
                    if (prefix == 64) {
                        failType = 0;
                    } else if (prefix == 33) {
                        failType = 2;
                    } else if (Character.isWhitespace(line.codePointAt(1)) && (prefix == 97 || prefix == 98 || prefix == 114) || Character.isWhitespace(line.codePointAt(3)) && line.startsWith("all") || Character.isWhitespace(line.codePointAt(5)) && line.startsWith("build") || Character.isWhitespace(line.codePointAt(7)) && line.startsWith("runtime")) {
                        LOGGER.warn("Malformed ReversibleAccessSetter transform in line {} of namespace \"{}\": Special prefixes are not optional according to the spec. Consider resolving this issue to prevent failures in other RAS implementations.", (Object)lineNumber, (Object)namespace);
                        line = ' ' + line;
                        prefix = 32;
                    } else {
                        throw new IOException("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace \"" + namespace + "\": Invalid prefix " + JavaInterop.codepointToString(prefix) + ".");
                    }
                }
                if (Character.isWhitespace(prefix)) {
                    line = '0' + line.substring(1);
                }
                if ((parts = (line = line.trim()).split("\\s+")).length != 4 && parts.length != 6) {
                    throw new IOException("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": Expected format \"<prefix>scope <original-access> <target-access> <className>\" or \"<prefix>scope <original-access> <target-access> <className> <memberName> <memberDescriptor>\". (Consists of " + parts.length + " parts, but expected 4 or 6 parts)");
                }
                String scope = parts[0].substring(1);
                if (scope.isEmpty()) {
                    throw new IOException("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": Empty scope");
                }
                if (scope.equals("a") || scope.equals("all")) {
                    rasScope = RASTransformScope.ALL;
                } else if (scope.equals("b") || scope.equals("build")) {
                    rasScope = RASTransformScope.BUILDTIME;
                } else if (scope.equals("r") || scope.equals("runtime")) {
                    rasScope = RASTransformScope.RUNTIME;
                } else {
                    throw new IOException("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": Unknown scope \"" + scope + "\". Make sure you use the right dialect!");
                }
                int leftAccess = AccessUtil.parseAccess(parts[1]);
                int rightAccess = AccessUtil.parseAccess(parts[2]);
                int leftAccessType = AccessUtil.getAccessCategory(parts[1]);
                int rightAccessType = AccessUtil.getAccessCategory(parts[2]);
                if (reversed) {
                    int temp = leftAccess;
                    leftAccess = rightAccess;
                    rightAccess = temp;
                    temp = leftAccessType;
                    leftAccessType = rightAccessType;
                    rightAccessType = temp;
                }
                if (leftAccess != 0 && rightAccess != 0) {
                    boolean visibilityUnchanging = (leftAccess & 7) == 0;
                    if (visibilityUnchanging != ((rightAccess & 7) == 0)) {
                        throw new IOException("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": Incompatible accesses.");
                    }
                    if (visibilityUnchanging && leftAccess != rightAccess) {
                        throw new IOException("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": Incompatible accesses.");
                    }
                }
                if (leftAccessType == 3 || rightAccessType == 3) {
                    throw new IOException("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": This access can only be applied on module-info.class entries, which cannot be changed by RAS as of v1.0.");
                }
                if (rasScope == RASTransformScope.ALL || rasScope == this.scope) {
                    RASClassContext var10001;
                    String className;
                    RASClassContext context;
                    if (this.forcedSilence) {
                        failType = 0;
                    }
                    if ((context = (RASClassContext)this.classes.get(className = parts[3])) == null && (var10001 = this.classes.putIfAbsent(className, context = new RASClassContext())) != null) {
                        context = var10001;
                    }
                    if (parts.length == 4) {
                        if (leftAccessType != -1 && leftAccessType != 0 || rightAccessType != -1 && rightAccessType != 0) {
                            throw new IOException("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": This access cannot be applied on classes.");
                        }
                        ReversibleAccessSetterContext.addTransform(context.selfTransforms, leftAccess, rightAccess, AccessUtil.andAccessTypes(leftAccessType, rightAccessType), failType, namespace);
                    } else {
                        String memberName = parts[4];
                        String memberDesc = parts[5];
                        if (memberDesc.codePointAt(0) == 40) {
                            if (leftAccessType != -1 && leftAccessType != 2 || rightAccessType != -1 && rightAccessType != 2) {
                                throw new IOException("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": This access cannot be applied on methods.");
                            }
                        } else if (leftAccessType != -1 && leftAccessType != 1 || rightAccessType != -1 && rightAccessType != 1) {
                            throw new IOException("Malformed ReversibleAccessSetter transform in line " + lineNumber + " of namespace " + namespace + ": This access cannot be applied on fields.");
                        }
                        AbstractMap.SimpleImmutableEntry<String, String> entry = new AbstractMap.SimpleImmutableEntry<String, String>(memberName, memberDesc);
                        List<RASAccessTransform> transforms = (CopyOnWriteArrayList<RASAccessTransform>)context.memberTransforms.get(entry);
                        if (transforms == null) {
                            transforms = new CopyOnWriteArrayList<RASAccessTransform>();
                            List var100012 = context.memberTransforms.putIfAbsent(entry, transforms);
                            if (var100012 != null) {
                                transforms = var100012;
                            }
                        }
                        ReversibleAccessSetterContext.addTransform(transforms, leftAccess, rightAccess, rightAccessType, failType, namespace);
                    }
                }
            }
            line = reader.readLine();
            ++lineNumber;
        }
    }

    static class RASAccessTransform {
        private static final int FAIL_HARD = 2;
        private static final int FAIL_SOFT = 0;
        private static final int FAIL_WARN = 1;
        private int failType;
        public final int originAccess;
        @NotNull
        private final List<String> sources = new CopyOnWriteArrayList<String>();
        public final int targetAccess;
        public final int targetType;

        public RASAccessTransform(int originAccess, int targetAccess, int targetType, int failType, String source) {
            this.originAccess = originAccess;
            this.targetAccess = targetAccess;
            this.targetType = targetType;
            this.failType = failType;
            this.sources.add(source);
        }

        public String toString() {
            return AccessUtil.stringifyAccess(this.originAccess, this.targetType) + " -> " + AccessUtil.stringifyAccess(this.targetAccess, this.targetType);
        }
    }

    public static enum RASTransformScope {
        ALL,
        BUILDTIME,
        RUNTIME;

    }

    private static class RASClassContext {
        @NotNull
        private final @NotNull ConcurrentMap<Map.Entry<String, String>, List<@NotNull RASAccessTransform>> memberTransforms = new ConcurrentHashMap<Map.Entry<String, String>, List<RASAccessTransform>>();
        @NotNull
        private final @NotNull List<@NotNull RASAccessTransform> selfTransforms = new CopyOnWriteArrayList<RASAccessTransform>();

        private RASClassContext() {
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void accept(@NotNull ClassNode node) throws RASTransformFailure {
            long result;
            for (RASAccessTransform transform : this.selfTransforms) {
                long result2 = AccessUtil.applyAccess(node.access, 0, transform);
                if ((result2 & 0xFFFFFFFF00000000L) == 0L) {
                    node.access = (int)result2;
                    continue;
                }
                if (transform.failType == 2) {
                    throw new RASTransformFailure("RAS transform \"" + transform + "\" from namespaces " + transform.sources + " failed for class \"" + node.name + "\": " + AccessUtil.getErrorCode(result2));
                }
                if (transform.failType != 1) continue;
                LOGGER.warn("ReversibleAccessSetter transform \"{}\" from namespaces {} failed to apply for class \"{}\": {}", new Object[]{transform, transform.sources, node.name, AccessUtil.getErrorCode(result2)});
            }
            for (MethodNode method : node.methods) {
                @NotNull List transforms = (List)this.memberTransforms.get(new AbstractMap.SimpleImmutableEntry<String, String>(method.name, method.desc));
                if (transforms == null) continue;
                for (RASAccessTransform transform : transforms) {
                    result = AccessUtil.applyAccess(method.access, 0, transform);
                    if ((result & 0xFFFFFFFF00000000L) == 0L) {
                        method.access = (int)result;
                        continue;
                    }
                    if (transform.failType == 2) {
                        throw new RASTransformFailure("RAS transform \"" + transform + "\" from namespaces " + transform.sources + " failed for method \"" + node.name + "." + method.name + method.desc + "\": " + AccessUtil.getErrorCode(result));
                    }
                    if (transform.failType != 1) continue;
                    LOGGER.warn("ReversibleAccessSetter transform \"{}\" from namespaces {} failed to apply for method \"{}.{}{}\": {}", new Object[]{transform, transform.sources, node.name, method.name, method.desc, AccessUtil.getErrorCode(result)});
                }
            }
            for (FieldNode field : node.fields) {
                @NotNull List transforms = (List)this.memberTransforms.get(new AbstractMap.SimpleImmutableEntry<String, String>(field.name, field.desc));
                if (transforms == null) continue;
                for (RASAccessTransform transform : transforms) {
                    result = AccessUtil.applyAccess(field.access, 0, transform);
                    if ((result & 0xFFFFFFFF00000000L) == 0L) {
                        field.access = (int)result;
                        continue;
                    }
                    if (transform.failType == 2) {
                        throw new RASTransformFailure("RAS transform \"" + transform + "\" from namespaces " + transform.sources + " failed for field \"" + node.name + "." + field.name + ":" + field.desc + "\": " + AccessUtil.getErrorCode(result));
                    }
                    if (transform.failType != 1) continue;
                    LOGGER.warn("ReversibleAccessSetter transform \"{}\" from namespaces {} failed to apply for field \"{}.{}:{}\": {}", new Object[]{transform, transform.sources, node.name, field.name, field.desc, AccessUtil.getErrorCode(result)});
                }
            }
        }
    }

    public static class RASTransformFailure
    extends Exception {
        private static final long serialVersionUID = -2103204040204349662L;

        protected RASTransformFailure(String message) {
            super(message);
        }
    }
}

