/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.util;

import de.geolykt.starloader.util.CollectionNode;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrderedCollection<E extends Comparable<E>>
extends AbstractCollection<E>
implements CollectionNode<E> {
    @Nullable
    private CollectionNode<E> next;
    @Nullable
    private E value;

    @Override
    public Iterator<E> iterator() {
        return new CollectionNode.NodeIterator(this);
    }

    @Override
    public int size() {
        int size = 1;
        for (CollectionNode<E> head = this; head != null; head = head.next()) {
            ++size;
        }
        return size;
    }

    @Override
    @Nullable
    public CollectionNode<E> next() {
        return this.next;
    }

    @Override
    @NotNull
    public E get() {
        @Nullable E value = this.value;
        if (value == null) {
            throw new NoSuchElementException("Collection is empty.");
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    @Override
    public void setNext(@Nullable CollectionNode<E> next) {
        this.next = next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        OrderedCollection orderedCollection = this;
        synchronized (orderedCollection) {
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (!Objects.equals(it.next(), o)) continue;
                it.remove();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        Objects.requireNonNull(e);
        OrderedCollection orderedCollection = this;
        synchronized (orderedCollection) {
            if (this.value == null) {
                this.value = e;
                return true;
            }
            if (e.compareTo((Object)this.get()) < 0) {
                this.next = new Subnode<Object>(this.get());
                this.value = e;
                return true;
            }
            CollectionNode<E> next = this.next;
            CollectionNode<E> node = this;
            while (next != null) {
                int compare = e.compareTo((Comparable)((Comparable)next.get()));
                if (compare < 0) {
                    Subnode<E> inserted = new Subnode<E>(e);
                    inserted.setNext(next);
                    node.setNext(inserted);
                    return true;
                }
                node = next;
                next = node.next();
            }
            node.setNext(new Subnode<E>(e));
            return true;
        }
    }

    private static class Subnode<T>
    implements CollectionNode<T> {
        @Nullable
        private CollectionNode<T> next;
        @NotNull
        private final T value;

        public Subnode(@NotNull T value) {
            this.value = value;
        }

        @Override
        @Nullable
        public CollectionNode<T> next() {
            return this.next;
        }

        @Override
        @NotNull
        public T get() {
            return this.value;
        }

        @Override
        public void setNext(@Nullable CollectionNode<T> next) {
            this.next = next;
        }
    }
}

