/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.transformer.impl;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.annotations.CInline;
import net.lenni0451.classtransform.transformer.AnnotationHandler;
import net.lenni0451.classtransform.utils.MethodInliner;
import net.lenni0451.classtransform.utils.annotations.AnnotationUtils;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
public class CInlineAnnotationHandler
extends AnnotationHandler {
    @Override
    public void transform(TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer) {
        List methodsToInline = transformedClass.methods.stream().filter(methodNode -> AnnotationUtils.hasAnnotation(methodNode, CInline.class)).collect(Collectors.toList());
        for (MethodNode methodNode2 : methodsToInline) {
            MethodInliner.wrappedInline(transformedClass, methodNode2, transformedClass.name);
        }
    }
}

