/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.transformer.coprocessor.impl;

import java.util.ArrayList;
import java.util.List;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.annotations.CShared;
import net.lenni0451.classtransform.transformer.IAnnotationCoprocessor;
import net.lenni0451.classtransform.utils.ASMUtils;
import net.lenni0451.classtransform.utils.CoprocessorUtils;
import net.lenni0451.classtransform.utils.Types;
import net.lenni0451.classtransform.utils.annotations.AnnotationParser;
import net.lenni0451.classtransform.utils.annotations.AnnotationUtils;
import net.lenni0451.classtransform.utils.attributes.SharedVariableAttribute;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CSharedCoprocessor
implements IAnnotationCoprocessor {
    private CoprocessorUtils.AnnotatedParameter[] parameters;

    @Override
    public MethodNode preprocess(TransformerManager transformerManager, ClassNode transformedClass, MethodNode transformedMethod, ClassNode transformer, MethodNode transformerMethod) {
        this.parameters = CoprocessorUtils.getAnnotatedParameters(transformerMethod, CShared.class);
        if (this.parameters == null) {
            return transformerMethod;
        }
        transformedMethod.signature = null;
        CoprocessorUtils.mergeParametersToArray(transformerMethod, this.parameters);
        return transformerMethod;
    }

    @Override
    public MethodNode transform(TransformerManager transformerManager, ClassNode transformedClass, MethodNode transformedMethod, ClassNode transformer, MethodNode transformerMethod) {
        if (this.parameters == null) {
            return transformerMethod;
        }
        ASMUtils.cutParameters(transformerMethod, 1);
        return transformerMethod;
    }

    @Override
    public void postprocess(TransformerManager transformerManager, ClassNode transformedClass, MethodNode transformedMethod, List<MethodInsnNode> transformerMethodCalls, ClassNode transformer, MethodNode transformerMethod) {
        AbstractInsnNode cast;
        ParsedSharedVariable parsedSharedVariable;
        int i;
        if (this.parameters == null) {
            return;
        }
        ASMUtils.addParameters(transformerMethod, Types.type(Object[].class));
        SharedVariableAttribute attribute = this.getAttribute(transformedMethod);
        ParsedSharedVariable[] parsedSharedVariables = this.initializeSharedVariables(transformerManager, transformer, attribute, transformedMethod);
        int targetArrayIndex = ASMUtils.getFreeVarIndex(transformedMethod);
        InsnList before = new InsnList();
        InsnList after = new InsnList();
        before.add(ASMUtils.intPush(parsedSharedVariables.length));
        before.add((AbstractInsnNode)new TypeInsnNode(189, Types.internalName(Object.class)));
        before.add((AbstractInsnNode)new InsnNode(89));
        before.add((AbstractInsnNode)new VarInsnNode(58, targetArrayIndex));
        for (i = 0; i < parsedSharedVariables.length; ++i) {
            parsedSharedVariable = parsedSharedVariables[i];
            before.add((AbstractInsnNode)new InsnNode(89));
            before.add(ASMUtils.intPush(i));
            before.add((AbstractInsnNode)new VarInsnNode(parsedSharedVariable.parameter.getType().getOpcode(21), parsedSharedVariable.sharedVariable.getVariableIndex()));
            cast = ASMUtils.getPrimitiveToObject(parsedSharedVariable.parameter.getType());
            if (cast != null) {
                before.add(cast);
            }
            before.add((AbstractInsnNode)new InsnNode(83));
        }
        for (i = 0; i < parsedSharedVariables.length; ++i) {
            parsedSharedVariable = parsedSharedVariables[i];
            after.add((AbstractInsnNode)new VarInsnNode(25, targetArrayIndex));
            after.add(ASMUtils.intPush(i));
            after.add((AbstractInsnNode)new InsnNode(50));
            cast = ASMUtils.getCast(parsedSharedVariable.sharedVariable.getType());
            after.add((InsnList)cast);
            after.add((AbstractInsnNode)new VarInsnNode(parsedSharedVariable.parameter.getType().getOpcode(54), parsedSharedVariable.sharedVariable.getVariableIndex()));
        }
        for (MethodInsnNode transformerCall : transformerMethodCalls) {
            transformerCall.desc = transformerMethod.desc;
            transformedMethod.instructions.insertBefore((AbstractInsnNode)transformerCall, ASMUtils.cloneInsnList(before));
            transformedMethod.instructions.insert((AbstractInsnNode)transformerCall, ASMUtils.cloneInsnList(after));
        }
    }

    private SharedVariableAttribute getAttribute(MethodNode methodNode) {
        if (methodNode.attrs == null) {
            methodNode.attrs = new ArrayList();
        }
        SharedVariableAttribute attribute = null;
        for (Attribute attr : methodNode.attrs) {
            SharedVariableAttribute newAttr;
            if (attr instanceof SharedVariableAttribute) {
                attribute = (SharedVariableAttribute)attr;
                break;
            }
            if (!attr.type.equals("ClassTransformSharedVariable")) continue;
            try {
                newAttr = new SharedVariableAttribute(attr);
            }
            catch (Throwable t) {
                newAttr = new SharedVariableAttribute();
            }
            methodNode.attrs.remove(attr);
            methodNode.attrs.add(newAttr);
            attribute = newAttr;
            break;
        }
        if (attribute == null) {
            attribute = new SharedVariableAttribute();
            methodNode.attrs.add(attribute);
        }
        return attribute;
    }

    private ParsedSharedVariable[] initializeSharedVariables(TransformerManager transformerManager, ClassNode transformer, SharedVariableAttribute attribute, MethodNode transformedMethod) {
        ArrayList<ParsedSharedVariable> parsedSharedVariables = new ArrayList<ParsedSharedVariable>();
        for (CoprocessorUtils.AnnotatedParameter parameter : this.parameters) {
            if (parameter == null) continue;
            CShared annotation = AnnotationParser.parse(CShared.class, transformerManager, AnnotationUtils.listToMap(parameter.getAnnotation().values));
            SharedVariableAttribute.SharedVariable sharedVariable = attribute.getVariableIndex(transformer.name, annotation.value(), annotation.global());
            if (sharedVariable == null) {
                sharedVariable = attribute.addVariable(transformer.name, annotation.value(), ASMUtils.getFreeVarIndex(transformedMethod), parameter.getType(), annotation.global());
                transformedMethod.instructions.insert(this.getDefaultInstructions(parameter.getType(), sharedVariable.getVariableIndex()));
            } else if (!ASMUtils.compareType(sharedVariable.getType(), parameter.getType())) {
                throw new IllegalArgumentException("Shared variable '" + annotation.value() + "' has the wrong type: " + parameter.getType() + " != " + sharedVariable.getType());
            }
            parsedSharedVariables.add(new ParsedSharedVariable(parameter, sharedVariable));
        }
        return parsedSharedVariables.toArray(new ParsedSharedVariable[0]);
    }

    private InsnList getDefaultInstructions(Type type, int index) {
        InsnList insns = new InsnList();
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                insns.add((AbstractInsnNode)new InsnNode(3));
                break;
            }
            case 7: {
                insns.add((AbstractInsnNode)new InsnNode(9));
                break;
            }
            case 6: {
                insns.add((AbstractInsnNode)new InsnNode(11));
                break;
            }
            case 8: {
                insns.add((AbstractInsnNode)new InsnNode(14));
                break;
            }
            case 9: 
            case 10: {
                insns.add((AbstractInsnNode)new InsnNode(1));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
        }
        insns.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(54), index));
        return insns;
    }

    private static class ParsedSharedVariable {
        private final CoprocessorUtils.AnnotatedParameter parameter;
        private final SharedVariableAttribute.SharedVariable sharedVariable;

        private ParsedSharedVariable(CoprocessorUtils.AnnotatedParameter parameter, SharedVariableAttribute.SharedVariable sharedVariable) {
            this.parameter = parameter;
            this.sharedVariable = sharedVariable;
        }
    }
}

