/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.selectors.inject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import nilloader.api.lib.asm.tree.AbstractInsnNode;
import nilloader.api.lib.asm.tree.MethodNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.micromixin.transform.api.InjectionPointSelector;
import org.stianloader.micromixin.transform.api.InjectionPointSelectorFactory;
import org.stianloader.micromixin.transform.api.InjectionPointTargetConstraint;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.api.SlicedInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.MixinParseException;
import org.stianloader.micromixin.transform.internal.util.ASMUtil;

public class LoadInjectionPointSelector
extends InjectionPointSelector
implements InjectionPointSelectorFactory.InjectionPointSelectorProvider {
    @NotNull
    public static final LoadInjectionPointSelector INSTANCE = new LoadInjectionPointSelector();

    private LoadInjectionPointSelector() {
        super("org.spongepowered.asm.mixin.injection.modify.BeforeLoadLocal", "LOAD");
    }

    @Override
    @Nullable
    public AbstractInsnNode getFirstInsn(@NotNull MethodNode method, @Nullable SlicedInjectionPointSelector from, @Nullable SlicedInjectionPointSelector to, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        AbstractInsnNode insn;
        AbstractInsnNode guard;
        AbstractInsnNode abstractInsnNode = guard = to == null ? method.instructions.getLast() : to.getAfterSelected(method, remapper, sharedBuilder);
        for (insn = from == null ? method.instructions.getFirst() : from.getFirstInsn(method, remapper, sharedBuilder); insn != null && insn != guard; insn = insn.getNext()) {
            if (!ASMUtil.isLoad(insn.getOpcode())) continue;
            return insn;
        }
        if (insn == null) {
            throw new IllegalStateException("Exhausted instruction list before hitting the last instruction in the slice. This likely points to an invalidly programmed selector as well as insufficent slice validation.");
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<? extends AbstractInsnNode> getMatchedInstructions(@NotNull MethodNode method, @Nullable SlicedInjectionPointSelector from, @Nullable SlicedInjectionPointSelector to, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        AbstractInsnNode insn;
        AbstractInsnNode guard;
        ArrayList<AbstractInsnNode> matched = new ArrayList<AbstractInsnNode>();
        AbstractInsnNode abstractInsnNode = guard = to == null ? method.instructions.getLast() : to.getAfterSelected(method, remapper, sharedBuilder);
        for (insn = from == null ? method.instructions.getFirst() : from.getFirstInsn(method, remapper, sharedBuilder); insn != null && insn != guard; insn = insn.getNext()) {
            if (!ASMUtil.isLoad(insn.getOpcode())) continue;
            matched.add(insn);
        }
        if (insn == null) {
            throw new IllegalStateException("Exhausted instruction list before hitting the last instruction in the slice. This likely points to an invalidly programmed selector as well as insufficent slice validation.");
        }
        return Collections.unmodifiableList(matched);
    }

    @Override
    public boolean supportsRedirect() {
        return false;
    }

    @Override
    @NotNull
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @NotNull
    public Set<String> getAllNames() {
        return this.allNames;
    }

    @Override
    @NotNull
    public InjectionPointSelector create(@Nullable List<String> args, @Nullable InjectionPointTargetConstraint constraint) {
        if (constraint != null) {
            throw new MixinParseException("Broken mixin: Superfluous discriminator found in @At(\"" + this.getFullyQualifiedName() + "\"). Usage of the 'target' or 'desc' constraints is not applicable to the " + this.getFullyQualifiedName() + " injection point.");
        }
        if (args != null) {
            throw new MixinParseException("Broken mixin: Superfluous discriminator found in @At(\"" + this.getFullyQualifiedName() + "\"). Usage of the 'args' constraints is not applicable to the " + this.getFullyQualifiedName() + " injection point.");
        }
        return this;
    }
}

