/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.util.commenttable;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.stianloader.micromixin.transform.internal.util.commenttable.CommentTableSection;

public class KeyValueTableSection
implements CommentTableSection {
    private int keyLength;
    private int valueLength;
    private final Map<String, String> pairs = new LinkedHashMap<String, String>();

    @NotNull
    @Contract(mutates="this", pure=false, value="null, _ -> fail; _, null -> fail; !null, !null -> this")
    public KeyValueTableSection add(@NotNull String key, @NotNull String value) {
        this.keyLength = Math.max(this.keyLength, key.length());
        this.valueLength = Math.max(this.valueLength, value.length());
        this.pairs.put(key, value);
        return this;
    }

    @Override
    public int getPreferedWidth() {
        return this.keyLength + this.valueLength + 3;
    }

    @Override
    @NotNull
    public List<String> getLines() {
        StringBuilder builder = new StringBuilder(this.getPreferedWidth());
        ArrayList<String> lines = new ArrayList<String>();
        for (Map.Entry<String, String> pair : this.pairs.entrySet()) {
            builder.setLength(0);
            String key = pair.getKey();
            int count = this.keyLength - key.length();
            while (count-- != 0) {
                builder.append(' ');
            }
            builder.append(key).append(" : ").append(pair.getValue());
            lines.add(builder.toString());
        }
        return lines;
    }
}

