/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.selectors.inject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nilloader.api.lib.asm.tree.AbstractInsnNode;
import nilloader.api.lib.asm.tree.FieldInsnNode;
import nilloader.api.lib.asm.tree.MethodNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.micromixin.transform.api.InjectionPointSelector;
import org.stianloader.micromixin.transform.api.InjectionPointSelectorFactory;
import org.stianloader.micromixin.transform.api.InjectionPointTargetConstraint;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.api.SlicedInjectionPointSelector;
import org.stianloader.micromixin.transform.internal.MixinParseException;

public class FieldInjectionPointSelector
extends InjectionPointSelector {
    @NotNull
    private static final Set<String> ALL_NAMES = new HashSet<String>(Arrays.asList("org.spongepowered.asm.mixin.injection.points.BeforeFieldAccess", "FIELD"));
    @NotNull
    public static final InjectionPointSelectorFactory.InjectionPointSelectorProvider PROVIDER = new InjectionPointSelectorFactory.InjectionPointSelectorProvider(){

        @Override
        @NotNull
        public String getFullyQualifiedName() {
            return "org.spongepowered.asm.mixin.injection.points.BeforeFieldAccess";
        }

        @Override
        @NotNull
        public Set<String> getAllNames() {
            return ALL_NAMES;
        }

        @Override
        @NotNull
        public InjectionPointSelector create(@Nullable List<String> args, @Nullable InjectionPointTargetConstraint constraint) {
            if (constraint == null) {
                throw new MixinParseException("Broken mixin: No descriptor or type discriminator found in @At(\"" + this.getFullyQualifiedName() + "\"). Usage of the 'target' or 'desc' constraints is required in the INVOKE injection point.");
            }
            if (args != null) {
                throw new MixinParseException("Broken mixin: Superfluous discriminator found in @At(\"" + this.getFullyQualifiedName() + "\"). Usage of the 'args' constraints is not applicable to the " + this.getFullyQualifiedName() + " injection point.");
            }
            return new FieldInjectionPointSelector(constraint);
        }
    };
    @NotNull
    private final InjectionPointTargetConstraint constraint;

    private FieldInjectionPointSelector(@NotNull InjectionPointTargetConstraint constraint) {
        super("org.spongepowered.asm.mixin.injection.points.BeforeFieldAccess", "FIELD");
        this.constraint = constraint;
    }

    @Override
    @Nullable
    public AbstractInsnNode getFirstInsn(@NotNull MethodNode method, @Nullable SlicedInjectionPointSelector from, @Nullable SlicedInjectionPointSelector to, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        AbstractInsnNode insn;
        AbstractInsnNode guard;
        AbstractInsnNode abstractInsnNode = guard = to == null ? method.instructions.getLast() : to.getAfterSelected(method, remapper, sharedBuilder);
        for (insn = from == null ? method.instructions.getFirst() : from.getFirstInsn(method, remapper, sharedBuilder); insn != null && insn != guard; insn = insn.getNext()) {
            if (!(insn instanceof FieldInsnNode) || !this.constraint.isValid(insn, remapper, sharedBuilder)) continue;
            return insn;
        }
        if (insn == null) {
            throw new IllegalStateException("Exhausted instruction list before hitting the last instruction in the slice. This likely points to an invalidly programmed selector as well as insufficent slice validation.");
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<? extends AbstractInsnNode> getMatchedInstructions(@NotNull MethodNode method, @Nullable SlicedInjectionPointSelector from, @Nullable SlicedInjectionPointSelector to, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        AbstractInsnNode insn;
        AbstractInsnNode guard;
        ArrayList<AbstractInsnNode> matched = new ArrayList<AbstractInsnNode>();
        AbstractInsnNode abstractInsnNode = guard = to == null ? method.instructions.getLast() : to.getAfterSelected(method, remapper, sharedBuilder);
        for (insn = from == null ? method.instructions.getFirst() : from.getFirstInsn(method, remapper, sharedBuilder); insn != null && insn != guard; insn = insn.getNext()) {
            if (!(insn instanceof FieldInsnNode) || !this.constraint.isValid(insn, remapper, sharedBuilder)) continue;
            matched.add(insn);
        }
        if (insn == null) {
            throw new IllegalStateException("Exhausted instruction list before hitting the last instruction in the slice. This likely points to an invalidly programmed selector as well as insufficent slice validation.");
        }
        return matched;
    }

    @Override
    public boolean supportsRedirect() {
        return true;
    }
}

