/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.selectors.constant;

import nilloader.api.lib.asm.tree.AbstractInsnNode;
import nilloader.api.lib.asm.tree.InsnNode;
import nilloader.api.lib.asm.tree.IntInsnNode;
import nilloader.api.lib.asm.tree.LdcInsnNode;
import org.jetbrains.annotations.NotNull;
import org.stianloader.micromixin.transform.internal.annotation.ConstantSelector;

public class IntConstantSelector
extends ConstantSelector {
    private final int value;

    public IntConstantSelector(int value) {
        this.value = value;
    }

    @Override
    public boolean matchesConstant(@NotNull AbstractInsnNode insn) {
        if (insn instanceof InsnNode) {
            if (this.value < -1 || this.value > 5) {
                return false;
            }
            return insn.getOpcode() == 3 && this.value == 0 || insn.getOpcode() == 4 && this.value == 1 || insn.getOpcode() == 5 && this.value == 2 || insn.getOpcode() == 6 && this.value == 3 || insn.getOpcode() == 7 && this.value == 4 || insn.getOpcode() == 8 && this.value == 5 || insn.getOpcode() == 2 && this.value == -1;
        }
        if (insn instanceof LdcInsnNode) {
            return ((LdcInsnNode)insn).cst instanceof Integer && (Integer)((LdcInsnNode)insn).cst == this.value;
        }
        if (insn instanceof IntInsnNode) {
            return (insn.getOpcode() == 16 || insn.getOpcode() == 17) && ((IntInsnNode)insn).operand == this.value;
        }
        return false;
    }
}

