/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.stianloader.picoresolve.internal.JavaInterop;
import org.stianloader.picoresolve.internal.StronglyMultiCompletableFuture;

public class ConcurrencyUtil {
    @NotNull
    public static <T> CompletableFuture<T> schedule(@NotNull Callable<T> source, @NotNull Executor executor) {
        Objects.requireNonNull(source, "source may not be null");
        CompletableFuture cf = new CompletableFuture();
        executor.execute(() -> {
            if (cf.isDone()) {
                return;
            }
            try {
                cf.complete(source.call());
            }
            catch (Throwable t) {
                cf.completeExceptionally(t);
            }
        });
        return cf;
    }

    private static <T extends Throwable> void sneakyThrow(Throwable t) throws T {
        throw t;
    }

    @NotNull
    public static <T> CompletableFuture<T> configureFallback(CompletableFuture<T> mains, Supplier<CompletableFuture<T>> fallback) {
        return JavaInterop.exceptionallyCompose(mains, t -> ((CompletableFuture)fallback.get()).exceptionally(t2 -> {
            t2.addSuppressed((Throwable)t);
            ConcurrencyUtil.sneakyThrow(t);
            throw new InternalError((Throwable)t);
        }));
    }

    @NotNull
    public static <T> CompletableFuture<T> exceptionally(CompletableFuture<T> main, Function<Throwable, T> fn) {
        return main.exceptionally(t -> {
            Object result = fn.apply((Throwable)t);
            if (result == null) {
                ConcurrencyUtil.sneakyThrow(t);
                throw new InternalError();
            }
            return result;
        });
    }

    @NotNull
    public static <T, C extends Collection<T>> CompletableFuture<C> thenAdd(@NotNull CompletableFuture<C> collectionProvider, @NotNull CompletableFuture<T> valueProvider) {
        StronglyMultiCompletableFuture cf = new StronglyMultiCompletableFuture(new CompletableFuture[]{collectionProvider, valueProvider.thenApply(Collections::singleton)});
        return cf.thenApply(list -> {
            if (list.size() != 2) {
                throw cf.generateException();
            }
            Collection collection = (Collection)list.get(0);
            Object addObject = ((List)list.get(1)).get(0);
            collection.add(addObject);
            return collection;
        });
    }
}

