/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stianloader.picoresolve.internal.ConcurrencyUtil;
import org.stianloader.picoresolve.internal.JavaInterop;
import org.stianloader.picoresolve.repo.MavenRepository;
import org.stianloader.picoresolve.repo.RepositoryAttachedValue;

public class MirroringURIMavenRepository
implements MavenRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(MirroringURIMavenRepository.class);
    @NotNull
    private final URI base;
    @NotNull
    private final String id;
    @Nullable
    private final Path mirrorOut;

    public MirroringURIMavenRepository(@NotNull String id, @NotNull URI base, @Nullable Path mirrorOut) {
        if (base.getPath().isEmpty()) {
            base = base.resolve("/");
        } else if (!base.getPath().endsWith("/")) {
            base = base.resolve(base.getPath() + "/");
        }
        this.base = base;
        this.id = id;
        this.mirrorOut = mirrorOut;
    }

    @NotNull
    @Contract(pure=true)
    public String getPlaintextURL() {
        return this.base.toString();
    }

    @NotNull
    @Contract(pure=true)
    public String getRepositoryId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<RepositoryAttachedValue<byte[]>> getResource(@NotNull String path, @NotNull Executor executor) {
        return ConcurrencyUtil.schedule(() -> {
            byte[] data = this.getResource0(path);
            Path mirrorOut = this.mirrorOut;
            if (mirrorOut != null) {
                String dumpPath = path;
                while (dumpPath.startsWith("/")) {
                    dumpPath = dumpPath.substring(1);
                }
                Path file = mirrorOut.resolve(dumpPath);
                Path dir = file.getParent();
                Files.createDirectories(dir, new FileAttribute[0]);
                Files.write(file, data, new OpenOption[0]);
            }
            return new RepositoryAttachedValue((MavenRepository)this, (Object)data);
        }, (Executor)executor);
    }

    protected byte @NotNull [] getResource0(@NotNull String path) throws Exception {
        HttpURLConnection httpUrlConn;
        URI resolved = this.base.resolve(path);
        URLConnection connection = resolved.toURL().openConnection();
        LOGGER.debug("Downloading {}", (Object)resolved);
        if (connection instanceof HttpURLConnection && (httpUrlConn = (HttpURLConnection)connection).getResponseCode() / 100 != 2) {
            throw new IOException("Query for " + connection.getURL() + " returned with a response code of " + httpUrlConn.getResponseCode() + " (" + httpUrlConn.getResponseMessage() + ")");
        }
        try (InputStream is = connection.getInputStream();){
            byte[] byArray = JavaInterop.readAllBytes((InputStream)is);
            return byArray;
        }
    }

    @Contract(pure=true)
    public long getUpdateIntervall() {
        return 604800000L;
    }
}

