/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.mod;

import de.geolykt.starloader.mod.DiscoveredExtension;
import de.geolykt.starloader.mod.ExtensionManager;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Extension {
    private final ExtensionDescription description;
    @NotNull
    private final Logger logger;

    protected Extension() {
        ExtensionDescription desc = ExtensionManager.CURRENTLY_LOADED_EXTENSION.get();
        if (desc == null) {
            throw new IllegalStateException("Unable to obtain extension description from extension manager");
        }
        this.description = desc;
        ExtensionManager.CURRENTLY_LOADED_EXTENSION.set(null);
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void preInitialize() {
    }

    public void initialize() {
    }

    public void postInitialize() {
    }

    @Deprecated
    public void preTerminate() {
    }

    @Deprecated
    public void terminate() {
    }

    @Deprecated
    public void postTerminate() {
    }

    @Deprecated
    public void unload() {
    }

    @NotNull
    public final ExtensionDescription getDescription() {
        return this.description;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public static class ExtensionDescription {
        @NotNull
        private final String name;
        @NotNull
        private final String version;
        @NotNull
        private final List<String> authors;
        @NotNull
        private final List<String> dependents = new ArrayList<String>();
        @NotNull
        private final DiscoveredExtension origin;

        public ExtensionDescription(@NotNull String name, @NotNull String version, @NotNull List<String> authors, @NotNull DiscoveredExtension origin) {
            this.name = name;
            this.version = version;
            this.authors = authors;
            this.origin = origin;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getVersion() {
            return this.version;
        }

        @NotNull
        public List<String> getAuthors() {
            return this.authors;
        }

        @NotNull
        public List<String> getDependents() {
            return this.dependents;
        }

        @NotNull
        public DiscoveredExtension getOrigin() {
            return this.origin;
        }
    }
}

