/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve.version;

import java.util.HashMap;
import java.util.Map;
import org.stianloader.picoresolve.internal.ConfusedResolverException;
import org.stianloader.picoresolve.internal.JavaInterop;
import org.stianloader.picoresolve.version.MavenVersionPart;
import org.stianloader.picoresolve.version.NumericVersionPart;
import org.stianloader.picoresolve.version.QualifierVersionPart;

final class PrereleaseVersionPart
implements MavenVersionPart {
    private static final Map<String, Integer> QUALIFIER_VALUES = new HashMap<String, Integer>();
    private int prefixCodepoint;
    private String qualifier;

    public PrereleaseVersionPart(int prefixCodepoint, String qualifier) {
        this.prefixCodepoint = prefixCodepoint;
        this.qualifier = qualifier;
    }

    @Override
    public int compareTo(MavenVersionPart o) {
        if (o instanceof NumericVersionPart) {
            return -1;
        }
        if (o instanceof QualifierVersionPart) {
            return -1;
        }
        if (o instanceof PrereleaseVersionPart) {
            PrereleaseVersionPart other = (PrereleaseVersionPart)o;
            if (other.prefixCodepoint != this.prefixCodepoint) {
                if (this.prefixCodepoint == 46 && other.prefixCodepoint == 45) {
                    return -1;
                }
                if (this.prefixCodepoint == 45 && other.prefixCodepoint == 46) {
                    return 1;
                }
                throw new ConfusedResolverException("Prefix codepoint confusion");
            }
            return QUALIFIER_VALUES.get(this.qualifier).compareTo(QUALIFIER_VALUES.get(other.qualifier));
        }
        throw new IllegalArgumentException("Cannot compare a prerelease version part to a " + o.getClass().getTypeName());
    }

    @Override
    public int getPrefixCodepoint() {
        return this.prefixCodepoint;
    }

    @Override
    public String stringifyContent() {
        return this.qualifier;
    }

    public String toString() {
        return JavaInterop.codepointToString(this.getPrefixCodepoint()) + this.stringifyContent();
    }

    static {
        QUALIFIER_VALUES.put("alpha", 0);
        QUALIFIER_VALUES.put("beta", 1);
        QUALIFIER_VALUES.put("milestone", 2);
        QUALIFIER_VALUES.put("rc", 3);
        QUALIFIER_VALUES.put("cr", 3);
        QUALIFIER_VALUES.put("snapshot", 4);
        QUALIFIER_VALUES.put("", 5);
        QUALIFIER_VALUES.put("final", 5);
        QUALIFIER_VALUES.put("ga", 5);
        QUALIFIER_VALUES.put("sp", 6);
    }
}

