/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.sll;

import de.geolykt.starloader.util.JavaInterop;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;

@ApiStatus.AvailableSince(value="4.0.0-a20250922")
public class SLLEnvironment {
    @NotNull
    private static final String MIXIN_COMPILED_ARTIFACT_ID;
    @NotNull
    private static final String MIXIN_COMPILED_GROUP_ID;
    @NotNull
    private static final String MIXIN_COMPILED_VERSION;
    private static final boolean MIXIN_SPONGELIKE;
    @NotNull
    private static final String SLL_ARTIFACT_ID;
    @NotNull
    private static final String SLL_GROUP_ID;
    @NotNull
    private static final String SLL_VERSION;

    @ApiStatus.AvailableSince(value="4.0.0-a20250922")
    @NotNull
    @Contract(pure=true)
    public static String getMixinCompiledArtifactId() {
        return MIXIN_COMPILED_ARTIFACT_ID;
    }

    @ApiStatus.AvailableSince(value="4.0.0-a20250922")
    @NotNull
    @Contract(pure=true)
    public static String getMixinCompiledGroupId() {
        return MIXIN_COMPILED_GROUP_ID;
    }

    @ApiStatus.AvailableSince(value="4.0.0-a20250922")
    @NotNull
    @Contract(pure=true)
    public static String getMixinCompiledVersion() {
        return MIXIN_COMPILED_VERSION;
    }

    @ApiStatus.AvailableSince(value="4.0.0-a20250922")
    @NotNull
    @Contract(pure=true)
    public static String getSLLArtifactId() {
        return SLL_ARTIFACT_ID;
    }

    @ApiStatus.AvailableSince(value="4.0.0-a20250922")
    @NotNull
    @Contract(pure=true)
    public static String getSLLGroupId() {
        return SLL_GROUP_ID;
    }

    @ApiStatus.AvailableSince(value="4.0.0-a20250922")
    @NotNull
    @Contract(pure=true)
    public static String getSLLVersion() {
        return SLL_VERSION;
    }

    @ApiStatus.AvailableSince(value="4.0.0-a20250922")
    @Contract(pure=true)
    public static boolean isMixinSpongelike() {
        return MIXIN_SPONGELIKE;
    }

    static {
        String sllGroup = null;
        String sllArtifact = null;
        String sllVersion = null;
        String mixinGroup = null;
        String mixinArtifact = null;
        String mixinVersion = null;
        String mixinSpongelike = null;
        try (InputStream is = SLLEnvironment.class.getResourceAsStream("/sll-environment-meta.json");){
            if (is == null) {
                throw new IOException("Resource not found.");
            }
            JSONObject jsonObject = new JSONObject(new String(JavaInterop.readAllBytes(is), StandardCharsets.UTF_8));
            sllGroup = jsonObject.optString("sll_groupid", null);
            sllArtifact = jsonObject.optString("sll_artifactid", null);
            mixinGroup = jsonObject.optString("mixin_groupid", null);
            mixinArtifact = jsonObject.optString("mixin_artifact", null);
            mixinVersion = jsonObject.optString("mixin_version", null);
            mixinSpongelike = jsonObject.optString("mixin_spongelike", null);
            try (InputStream is2 = SLLEnvironment.class.getResourceAsStream("/META-INF/maven/" + sllGroup + "/" + sllArtifact + "/pom.properties");){
                if (is2 == null) {
                    sllVersion = jsonObject.optString("sll_version_fallback", "unknown");
                } else {
                    Properties properties = new Properties();
                    properties.load(is);
                    String reportedVersion = properties.getProperty("version");
                    sllVersion = reportedVersion == null ? jsonObject.optString("sll_version_fallback", "unknown") : reportedVersion;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(SLLEnvironment.class).warn("Failed to fetch environment metadata.", (Throwable)e);
        }
        if (mixinSpongelike == null) {
            try {
                Class.forName("org.spongepowered.asm.mixin.Mixins", false, SLLEnvironment.class.getClassLoader());
                mixinSpongelike = "true";
            }
            catch (ClassNotFoundException cnfe) {
                mixinSpongelike = "false";
            }
        }
        MIXIN_COMPILED_ARTIFACT_ID = mixinArtifact == null ? "unknown" : mixinArtifact;
        MIXIN_COMPILED_GROUP_ID = mixinGroup == null ? "unknown" : mixinGroup;
        MIXIN_COMPILED_VERSION = mixinVersion == null ? "unknown" : mixinVersion;
        MIXIN_SPONGELIKE = Boolean.parseBoolean(mixinSpongelike);
        SLL_GROUP_ID = sllGroup == null ? "unknown" : sllGroup;
        SLL_ARTIFACT_ID = sllArtifact == null ? "unknown" : sllArtifact;
        SLL_VERSION = sllVersion == null ? "unknown" : sllVersion;
    }
}

