/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve.internal;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class MultiCompletableFuture<T>
extends CompletableFuture<T> {
    private final CompletableFuture<T>[] sources;
    private final Throwable[] exceptions;
    private int exceptionalCompletions = 0;

    public MultiCompletableFuture(List<CompletableFuture<T>> sources) {
        this(sources.toArray(new CompletableFuture[0]));
        if (sources.isEmpty()) {
            throw new IllegalStateException("the sources list may not be empty (else it would deadlock and we can't complete either as we don't know an appropriate default value to use)");
        }
    }

    public MultiCompletableFuture(CompletableFuture<T>[] sources) {
        this.sources = sources;
        this.exceptions = new Throwable[this.sources.length];
        int i = 0;
        while (i < sources.length) {
            CompletableFuture<T> future = sources[i];
            future.thenAccept(this::sourceCompleted);
            int futureIndex = i++;
            future.exceptionally((T ex) -> {
                this.sourceException(futureIndex, (Throwable)ex);
                return null;
            });
        }
    }

    private void sourceCompleted(T result) {
        if (this.complete(result)) {
            for (CompletableFuture<T> future : this.sources) {
                if (future.isDone()) continue;
                future.cancel(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sourceException(int i, Throwable exception) {
        Objects.requireNonNull(exception);
        Throwable[] throwableArray = this.exceptions;
        synchronized (this.exceptions) {
            if (this.exceptions[i] != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            this.exceptions[i] = exception;
            if (++this.exceptionalCompletions == this.exceptions.length && !this.isDone()) {
                this.completeExceptionally(new MultiCompletionException(this.exceptions).fillInStackTrace());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    static class MultiCompletionException
    extends CompletionException {
        private static final long serialVersionUID = -3361756801104382585L;

        public MultiCompletionException(Throwable[] causers) {
            for (Throwable t : causers) {
                if (t == null) continue;
                this.addSuppressed(t);
            }
        }
    }
}

