/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.stianloader.micromixin.transform.api.MixinLoggingFacade;
import org.stianloader.micromixin.transform.api.MixinTransformer;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.api.SlicedInjectionPointSelector;
import org.stianloader.micromixin.transform.api.supertypes.ClassWrapperPool;
import org.stianloader.micromixin.transform.internal.HandlerContextHelper;
import org.stianloader.micromixin.transform.internal.MixinMethodStub;
import org.stianloader.micromixin.transform.internal.MixinParseException;
import org.stianloader.micromixin.transform.internal.MixinStub;
import org.stianloader.micromixin.transform.internal.annotation.MixinAnnotation;
import org.stianloader.micromixin.transform.internal.annotation.MixinAtAnnotation;
import org.stianloader.micromixin.transform.internal.annotation.MixinDescAnnotation;
import org.stianloader.micromixin.transform.internal.annotation.MixinSliceAnnotation;
import org.stianloader.micromixin.transform.internal.selectors.DescSelector;
import org.stianloader.micromixin.transform.internal.selectors.MixinTargetSelector;
import org.stianloader.micromixin.transform.internal.selectors.StringSelector;
import org.stianloader.micromixin.transform.internal.util.ASMUtil;
import org.stianloader.micromixin.transform.internal.util.CodeCopyUtil;
import org.stianloader.micromixin.transform.internal.util.DescString;
import org.stianloader.micromixin.transform.internal.util.InjectionPointReference;
import org.stianloader.micromixin.transform.internal.util.Objects;
import org.stianloader.micromixin.transform.internal.util.commenttable.CommentTable;
import org.stianloader.micromixin.transform.internal.util.locals.ArgumentCaptureContext;
import org.stianloader.micromixin.transform.internal.util.locals.LocalCaptureResult;
import org.stianloader.micromixin.transform.internal.util.locals.LocalsCapture;

public class MixinModifyVariableAnnotation
extends MixinAnnotation<MixinMethodStub> {
    private final int allow;
    @NotNull
    private final ArgumentCaptureContext capturedArgs;
    private final int expect;
    @NotNull
    private final MethodNode injectSource;
    @NotNull
    private final MixinLoggingFacade logger;
    @Nullable
    private final Set<String> lvtVariableNames;
    private final int require;
    @NotNull
    public final Collection<MixinTargetSelector> selectors;
    @NotNull
    public final Collection<SlicedInjectionPointSelector> slicedAts;
    @NotNull
    private final ClassWrapperPool pool;

    @NotNull
    public static MixinModifyVariableAnnotation parse(@NotNull ClassNode node, @NotNull MethodNode method, @NotNull AnnotationNode annot, @NotNull MixinTransformer<?> transformer, @NotNull StringBuilder sharedBuilder) throws MixinParseException {
        if ((method.access & 8) != 0 && (method.access & 2) == 0) {
            throw new MixinParseException("The variable modifier method " + node.name + "." + method.name + method.desc + " is static, but isn't private. Consider making the method private.");
        }
        ArgumentCaptureContext argCapture = ArgumentCaptureContext.parseModifyHandler(node, method, "ModifyVariable");
        ArrayList<MixinAtAnnotation> at = new ArrayList<MixinAtAnnotation>();
        ArrayList<MixinSliceAnnotation> slice = new ArrayList<MixinSliceAnnotation>();
        Collection<MixinDescAnnotation> target = null;
        Set<String> variableNames = null;
        String[] targetSelectors = null;
        int require = -1;
        int expect = -1;
        int allow = -1;
        for (int i = 0; i < annot.values.size(); i += 2) {
            String[] hack;
            String name = (String)annot.values.get(i);
            Object val = annot.values.get(i + 1);
            if (name.equals("at")) {
                AnnotationNode atValue = (AnnotationNode)val;
                if (atValue == null) {
                    throw new NullPointerException();
                }
                try {
                    at.add(MixinAtAnnotation.parse(node, atValue, transformer.getInjectionPointSelectors()));
                    continue;
                }
                catch (MixinParseException mixinParseException) {
                    throw new MixinParseException("Unable to parse @At annotation defined by " + node.name + "." + method.name + method.desc, mixinParseException);
                }
            }
            if (name.equals("target")) {
                if (target != null) {
                    throw new MixinParseException("Duplicate \"target\" field in @ModifyConstant.");
                }
                target = new ArrayList();
                List atValues = (List)val;
                for (AnnotationNode atValue : atValues) {
                    if (atValue == null) {
                        throw new NullPointerException();
                    }
                    MixinDescAnnotation parsed = MixinDescAnnotation.parse(node, atValue);
                    target.add(parsed);
                }
                target = Collections.unmodifiableCollection(target);
                continue;
            }
            if (name.equals("method")) {
                if (targetSelectors != null) {
                    throw new MixinParseException("Duplicate \"method\" field in @ModifyVariable.");
                }
                targetSelectors = hack = ((List)val).toArray(new String[0]);
                continue;
            }
            if (name.equals("require")) {
                require = (Integer)val;
                continue;
            }
            if (name.equals("expect")) {
                expect = (Integer)val;
                continue;
            }
            if (name.equals("allow")) {
                allow = (Integer)val;
                continue;
            }
            if (name.equals("slice")) {
                AnnotationNode sliceValue = (AnnotationNode)val;
                if (sliceValue == null) {
                    throw new NullPointerException();
                }
                try {
                    slice.add(MixinSliceAnnotation.parse(node, sliceValue, transformer.getInjectionPointSelectors()));
                    continue;
                }
                catch (MixinParseException mixinParseException) {
                    throw new MixinParseException("Unable to parse @Slice annotation defined by " + node.name + "." + method.name + method.desc, mixinParseException);
                }
            }
            if (name.equals("name")) {
                if (variableNames != null) {
                    throw new MixinParseException("Duplicate \"name\" field in @ModifyVariable.");
                }
                hack = ((List)val).toArray(new String[0]);
                if (hack.length == 1) {
                    variableNames = Collections.singleton(hack[0]);
                    continue;
                }
                HashSet<String> hashSet = new HashSet<String>();
                for (String lvtName : hack) {
                    hashSet.add(lvtName);
                }
                variableNames = Collections.unmodifiableSet(hashSet);
                continue;
            }
            throw new MixinParseException("Unimplemented key in @ModifyVariable: " + name);
        }
        ArrayList<MixinTargetSelector> selectors = new ArrayList<MixinTargetSelector>();
        if (target != null) {
            for (MixinDescAnnotation desc : target) {
                selectors.add(new DescSelector(Objects.requireNonNull(desc)));
            }
        }
        if (targetSelectors != null) {
            for (void var18_27 : targetSelectors) {
                selectors.add(new StringSelector((String)Objects.requireNonNull(var18_27)));
            }
        }
        if (selectors.isEmpty()) {
            throw new MixinParseException("No available selectors: Mixin " + node.name + "." + method.name + method.desc + " does not match anything and is not a valid mixin. Did you forget to specify 'method' or 'target'?");
        }
        if (allow < require) {
            allow = -1;
        }
        Collection<SlicedInjectionPointSelector> slicedAts = Collections.unmodifiableCollection(MixinAtAnnotation.bake(at, slice));
        return new MixinModifyVariableAnnotation(slicedAts, Collections.unmodifiableCollection(selectors), method, require, expect, allow, transformer.getLogger(), argCapture, variableNames, transformer.getPool());
    }

    private MixinModifyVariableAnnotation(@NotNull Collection<SlicedInjectionPointSelector> slicedAts, @NotNull Collection<MixinTargetSelector> selectors, @NotNull MethodNode injectSource, int require, int expect, int allow, @NotNull MixinLoggingFacade logger, @NotNull ArgumentCaptureContext capturedArgs, @Nullable Set<String> lvtVariableNames, @NotNull ClassWrapperPool pool) {
        this.slicedAts = slicedAts;
        this.selectors = selectors;
        this.injectSource = injectSource;
        this.require = require;
        this.expect = expect;
        this.allow = allow;
        this.logger = logger;
        this.capturedArgs = capturedArgs;
        this.lvtVariableNames = lvtVariableNames;
        this.pool = pool;
    }

    @Override
    public void apply(@NotNull ClassNode to, @NotNull HandlerContextHelper hctx, @NotNull MixinStub sourceStub, @NotNull MixinMethodStub source, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        MethodNode method;
        MethodNode handlerNode = CodeCopyUtil.copyHandler(this.injectSource, sourceStub, to, remapper, hctx.lineAllocator, this.logger);
        Collection<InjectionPointReference> matched = ASMUtil.enumerateTargets(this.selectors, this.slicedAts, to, sourceStub, this.injectSource, this.require, this.expect, this.allow, remapper, sharedBuilder, this.logger);
        String argumentType = ASMUtil.getReturnType(this.injectSource.desc);
        int computationalArgumentType = argumentType.codePointAt(0);
        HashMap<MethodNode, ArrayList<AbstractInsnNode>> selectedInstructions = new HashMap<MethodNode, ArrayList<AbstractInsnNode>>();
        for (InjectionPointReference injectionPointReference : matched) {
            method = injectionPointReference.targetedMethod;
            ArrayList<AbstractInsnNode> insns = (ArrayList<AbstractInsnNode>)selectedInstructions.get(method);
            if (insns == null) {
                insns = new ArrayList<AbstractInsnNode>();
                selectedInstructions.put(method, insns);
            }
            insns.add(injectionPointReference.shiftedInstruction);
        }
        for (Map.Entry entry : selectedInstructions.entrySet()) {
            method = (MethodNode)entry.getKey();
            List injectLocations = (List)entry.getValue();
            int selectedLocal = -1;
            List<LocalVariableNode> lvt = method.localVariables;
            Set<String> lvtNames = this.lvtVariableNames;
            if (lvt != null && lvtNames != null) {
                block2: for (LocalVariableNode lvn : lvt) {
                    if (!lvtNames.contains(lvn.name) || !argumentType.equals(lvn.desc)) continue;
                    for (AbstractInsnNode injectLoc : injectLocations) {
                        assert (injectLoc != null);
                        if (ASMUtil.isBetween(lvn.start, lvn.end, injectLoc)) continue;
                        continue block2;
                    }
                    selectedLocal = lvn.index;
                    break;
                }
            } else {
                CommentTable table;
                int i;
                assert (injectLocations != null);
                Map<AbstractInsnNode, LocalCaptureResult> locals = LocalsCapture.multiCaptureLocals(to, method, injectLocations, this.pool);
                int maxLocals = Integer.MAX_VALUE;
                for (LocalCaptureResult localCapture : locals.values()) {
                    Frame<BasicValue> frame = localCapture.frame;
                    if (frame == null) {
                        Throwable error = localCapture.error;
                        if (error != null) {
                            throw new IllegalStateException("Cannot capture locals within method " + method.name + method.desc, error);
                        }
                        throw new IllegalStateException("Cannot capture locals within method " + method.name + method.desc + ": No further information.");
                    }
                    maxLocals = Math.min(maxLocals, frame.getLocals());
                }
                HashSet<Integer> candidates = new HashSet<Integer>();
                if (maxLocals == Integer.MAX_VALUE) {
                    throw new IllegalStateException("Cannot correctly determine the size of available locals.");
                }
                int n = i = (method.access & 8) == 0 ? 1 : 0;
                while (i < maxLocals) {
                    candidates.add(i);
                    ++i;
                }
                for (LocalCaptureResult localCapture : locals.values()) {
                    Frame<BasicValue> frame = localCapture.frame;
                    if (frame == null) {
                        throw new AssertionError();
                    }
                    int i2 = (method.access & 8) == 0 ? 1 : 0;
                    DescString dString = new DescString(method.desc);
                    while (dString.hasNext()) {
                        String type = dString.nextType();
                        if (!type.equals(argumentType)) {
                            candidates.remove(i2);
                        }
                        if (ASMUtil.isCategory2(type.codePointAt(0))) {
                            candidates.remove(++i2);
                        }
                        ++i2;
                    }
                    while (i2 < maxLocals) {
                        BasicValue local = frame.getLocal(i2);
                        Type type = local.getType();
                        if (type == null || !type.getDescriptor().equals(argumentType)) {
                            candidates.remove(i2);
                        }
                        if (local.getSize() == 2) {
                            candidates.remove(++i2);
                        }
                        ++i2;
                    }
                }
                if (candidates.isEmpty()) {
                    table = new CommentTable();
                    for (LocalCaptureResult localCapture : locals.values()) {
                        table.addSection(localCapture.asLocalPrintTable(sharedBuilder));
                    }
                    throw new IllegalStateException("Cannot capture locals within method " + method.name + method.desc + "; implicit local variable selection found no candidates. Consider using explicit local variable selection instead. Note: Local capture (including for @ModifyVariable) is inherently brittle; consider using other approaches if they are viable. Local capture information:\n" + table.toString());
                }
                if (candidates.size() != 1) {
                    table = new CommentTable();
                    for (LocalCaptureResult localCapture : locals.values()) {
                        table.addSection(localCapture.asLocalPrintTable(sharedBuilder));
                    }
                    throw new IllegalStateException("Cannot capture locals within method " + method.name + method.desc + "; implicit local variable selection found too many candidates (" + candidates.size() + " candidates found, but implicit local variable selection requires only a single candidate). Consider using explicit local variable selection instead. Note: Local capture (including for @ModifyVariable) is inherently brittle; consider using other approaches if they are viable. Local capture information:\n" + table.toString());
                }
                selectedLocal = (Integer)candidates.iterator().next();
            }
            for (AbstractInsnNode injectLoc : injectLocations) {
                int handlerInvokeOpcode;
                assert (injectLoc != null);
                InsnList inject = new InsnList();
                if ((handlerNode.access & 8) == 0) {
                    handlerInvokeOpcode = 182;
                    inject.add(new VarInsnNode(25, 0));
                } else {
                    handlerInvokeOpcode = 184;
                }
                inject.add(new VarInsnNode(ASMUtil.getLoadOpcode(computationalArgumentType), selectedLocal));
                this.capturedArgs.appendCaptures(to, Objects.requireNonNull(method, "method may not be null"), source, injectLoc, inject);
                inject.add(new MethodInsnNode(handlerInvokeOpcode, to.name, handlerNode.name, handlerNode.desc));
                inject.add(new VarInsnNode(ASMUtil.getStoreOpcode(computationalArgumentType), selectedLocal));
                method.instructions.insertBefore(injectLoc, inject);
            }
        }
    }

    @Override
    public void collectMappings(@NotNull MixinMethodStub source, @NotNull HandlerContextHelper hctx, @NotNull ClassNode target, @NotNull SimpleRemapper remapper, @NotNull StringBuilder sharedBuilder) {
        remapper.remapMethod(source.getOwner().name, source.getDesc(), source.getName(), hctx.generateUniqueLocalPrefix() + source.getName());
    }
}

