/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.micromixin.transform.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.stianloader.micromixin.transform.api.MixinTransformer;
import org.stianloader.micromixin.transform.api.SimpleRemapper;
import org.stianloader.micromixin.transform.internal.HandlerContextHelper;
import org.stianloader.micromixin.transform.internal.MixinFieldStub;
import org.stianloader.micromixin.transform.internal.MixinHeader;
import org.stianloader.micromixin.transform.internal.MixinMethodStub;
import org.stianloader.micromixin.transform.internal.MixinParseException;
import org.stianloader.micromixin.transform.internal.util.Objects;

public class MixinStub
implements Comparable<MixinStub> {
    @Nullable
    @ApiStatus.AvailableSince(value="0.7.0-a20241008")
    public final URI codeSourceURI;
    @Nullable
    private final List<MixinParseException> delayedExceptions;
    @NotNull
    public final Collection<MixinFieldStub> fields;
    @NotNull
    public final MixinHeader header;
    @NotNull
    public final Collection<MixinMethodStub> methods;
    @NotNull
    public final ClassNode sourceNode;

    @NotNull
    public static MixinStub parse(int defaultPriority, @NotNull ClassNode node, @NotNull MixinTransformer<?> transformer, @Nullable URI codeSourceURI, @NotNull StringBuilder sharedBuilder) {
        ArrayList<MixinMethodStub> methods = new ArrayList<MixinMethodStub>();
        ArrayList<MixinFieldStub> fields = new ArrayList<MixinFieldStub>();
        ArrayList<MixinParseException> delayedExceptions = null;
        for (MethodNode method : node.methods) {
            if (method == null) {
                throw new NullPointerException();
            }
            try {
                MixinMethodStub methodStub = MixinMethodStub.parse(node, method, transformer, sharedBuilder);
                methods.add(methodStub);
            }
            catch (MixinParseException e) {
                if (transformer.isDelayingParseExceptions()) {
                    if (delayedExceptions == null) {
                        delayedExceptions = new ArrayList<MixinParseException>();
                    }
                    delayedExceptions.add(e);
                    continue;
                }
                throw e;
            }
        }
        for (FieldNode field : node.fields) {
            if (field == null) {
                throw new NullPointerException();
            }
            try {
                fields.add(MixinFieldStub.parse(node, field, transformer, sharedBuilder));
            }
            catch (MixinParseException e) {
                if (transformer.isDelayingParseExceptions()) {
                    if (delayedExceptions == null) {
                        delayedExceptions = new ArrayList();
                    }
                    delayedExceptions.add(e);
                    continue;
                }
                throw e;
            }
        }
        return new MixinStub(node, MixinHeader.parse(node, defaultPriority), Collections.unmodifiableCollection(methods), Collections.unmodifiableCollection(fields), delayedExceptions, codeSourceURI);
    }

    public MixinStub(@NotNull ClassNode sourceNode, @NotNull MixinHeader header, @NotNull Collection<MixinMethodStub> methods, @NotNull Collection<MixinFieldStub> fields, @Nullable List<MixinParseException> delayedExceptions, @Nullable URI codeSourceURI) {
        this.sourceNode = sourceNode;
        this.header = header;
        this.methods = methods;
        this.fields = fields;
        this.delayedExceptions = delayedExceptions;
        this.codeSourceURI = codeSourceURI;
    }

    public void applyTo(@NotNull ClassNode target, @NotNull HandlerContextHelper hctx, @NotNull StringBuilder sharedBuilder) {
        List<MixinParseException> delayedExceptions = this.delayedExceptions;
        if (delayedExceptions != null && !delayedExceptions.isEmpty()) {
            IllegalStateException t1 = new IllegalStateException("Some exceptions occured during the parsing process, which is why a mixin cannot be applied");
            Throwable rethrown = Objects.addSuppressed(t1, delayedExceptions);
            throw (RuntimeException)rethrown;
        }
        SimpleRemapper remapper = this.getRemapper(target, hctx, sharedBuilder);
        for (MixinFieldStub mixinFieldStub : this.fields) {
            mixinFieldStub.applyTo(target, hctx, this, remapper, sharedBuilder);
        }
        for (MixinMethodStub mixinMethodStub : this.methods) {
            mixinMethodStub.applyTo(target, hctx, this, remapper, sharedBuilder);
        }
        for (String string : this.sourceNode.interfaces) {
            if (target.interfaces.contains(string)) continue;
            target.interfaces.add(string);
        }
    }

    @Override
    public int compareTo(MixinStub o) {
        int priority = this.header.priority - o.header.priority;
        if (priority != 0) {
            return priority;
        }
        return this.sourceNode.name.compareTo(o.sourceNode.name);
    }

    @NotNull
    public SimpleRemapper getRemapper(@NotNull ClassNode targetClass, @NotNull HandlerContextHelper hctx, @NotNull StringBuilder sharedBuilder) {
        SimpleRemapper r = new SimpleRemapper();
        r.remapClassName(this.sourceNode.name, targetClass.name);
        for (MixinFieldStub field : this.fields) {
            field.collectMappings(targetClass, hctx, this, r, sharedBuilder);
        }
        for (MixinMethodStub method : this.methods) {
            method.collectMappings(targetClass, hctx, this, r, sharedBuilder);
        }
        return r;
    }

    public String toString() {
        return "MixinStub '" + this.sourceNode.name + "'";
    }
}

