/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starplane;

import de.geolykt.starloader.deobf.ClassWrapper;
import de.geolykt.starloader.deobf.IntermediaryGenerator;
import de.geolykt.starloader.deobf.MethodReference;
import de.geolykt.starloader.deobf.Oaktree;
import de.geolykt.starloader.ras.ReversibleAccessSetterContext;
import de.geolykt.starplane.Autodeobf;
import de.geolykt.starplane.DebugableMemberLister;
import de.geolykt.starplane.Utils;
import de.geolykt.starplane.remapping.ChainMappingLookup;
import de.geolykt.starplane.remapping.CommentLookup;
import de.geolykt.starplane.remapping.MIOMappingTreeProvider;
import de.geolykt.starplane.remapping.RASRemapper;
import de.geolykt.starplane.remapping.ReadOnlyMIOMappingLookup;
import de.geolykt.starplane.remapping.ReadOnlyMappingLookupSink;
import de.geolykt.starplane.remapping.StarplaneAnnotationRemapper;
import de.geolykt.starplane.remapping.StarplaneMappingLookup;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.fabricmc.mappingio.tree.MappingTreeView;
import net.fabricmc.mappingio.tree.VisitableMappingTree;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stianloader.micromixin.remapper.IllegalMixinException;
import org.stianloader.micromixin.remapper.MemberLister;
import org.stianloader.micromixin.remapper.MicromixinRemapper;
import org.stianloader.micromixin.remapper.MissingFeatureException;
import org.stianloader.remapper.HierarchyAwareMappingDelegator;
import org.stianloader.remapper.MappingLookup;
import org.stianloader.remapper.MappingSink;
import org.stianloader.remapper.Remapper;
import org.stianloader.remapper.SimpleHierarchyAwareMappingLookup;
import org.stianloader.remapper.SimpleTopLevelLookup;
import org.stianloader.softmap.SoftmapApplicationError;
import org.stianloader.softmap.SoftmapContext;
import org.stianloader.softmap.SoftmapParseError;
import org.stianloader.softmap.tokens.Token;

public class ObfuscationHandler {
    @NotNull
    private static final String COMPILED_SOFTMAP_FILE_NAME = "compiled-softmap.tiny";
    @NotNull
    private static final String INTERMEDIARY_FILE_NAME = "slintermediary.tiny";
    private static final byte @NotNull [] IO_BUFFER = new byte[4096];
    private static final Logger LOGGER = LoggerFactory.getLogger(ObfuscationHandler.class);
    @NotNull
    private static final String STARMAP_FILE_NAME = "spstarmap.tiny";
    @NotNull
    private final Path cacheDir;
    public boolean didRefresh = false;
    @NotNull
    private final Path projectDir;
    @Nullable
    private final String rasContent;
    @NotNull
    private final @NotNull @Unmodifiable Collection<@NotNull Path> softmapFiles;
    @NotNull
    private final @NotNull @Unmodifiable List<@NotNull MIOMappingTreeProvider> supplementaryMappings;

    private static String getStarplaneChecksum() throws IOException {
        try (InputStream autodeobfClass = Autodeobf.class.getClassLoader().getResourceAsStream("de/geolykt/starplane/Autodeobf.class");){
            String string;
            try (CheckedInputStream checkedIn = new CheckedInputStream(autodeobfClass, new Adler32());){
                while (checkedIn.read(IO_BUFFER) != -1) {
                }
                string = Long.toUnsignedString(checkedIn.getChecksum().getValue(), 36);
            }
            return string;
        }
    }

    @NotNull
    private static String toHexHash(byte[] hash) {
        StringBuilder hex = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            int x = b & 0xFF;
            if (x < 16) {
                hex.append('0');
            }
            hex.append(Integer.toHexString(x));
        }
        return hex.toString();
    }

    public ObfuscationHandler(@NotNull Path cacheDir, @NotNull Path projectDir, @Nullable String rasContent, @NotNull @NotNull @Unmodifiable Collection<@NotNull Path> softmapFiles, @NotNull @NotNull @Unmodifiable List<@NotNull MIOMappingTreeProvider> supplementaryMappings) {
        this.cacheDir = cacheDir;
        this.projectDir = projectDir;
        this.rasContent = rasContent;
        this.softmapFiles = softmapFiles;
        this.supplementaryMappings = supplementaryMappings;
    }

    private void addSignatures(List<ClassNode> nodes, Map<String, ClassNode> nameToNode, Map<MethodReference, ClassWrapper> signatures) {
        StringBuilder builder = new StringBuilder();
        for (ClassNode node : nodes) {
            for (MethodNode method : node.methods) {
                ClassWrapper newSignature;
                if (method.signature != null || (newSignature = signatures.get(new MethodReference(node.name, method))) == null) continue;
                builder.append(method.desc, 0, method.desc.length() - 1);
                builder.append("<L");
                builder.append(newSignature.getName());
                builder.append(";>;");
                method.signature = builder.toString();
                builder.setLength(0);
            }
        }
    }

    @NotNull
    @Contract(pure=true)
    private @NotNull @Unmodifiable List<@NotNull String> compileSoftmap(@NotNull Path softmapFile, @NotNull @NotNull List<@NotNull ClassNode> obfuscatedNodes) throws IOException {
        SoftmapContext.ApplicationResult result;
        List applyErrors;
        long fileStart = System.currentTimeMillis();
        String softmapContent = new String(Files.readAllBytes(softmapFile), StandardCharsets.UTF_8);
        SoftmapContext softmapContext = SoftmapContext.parse((String)softmapContent, (int)0, (int)softmapContent.length(), (int)1, (int)1);
        List parseErrors = softmapContext.getParseErrors();
        if (!parseErrors.isEmpty()) {
            System.out.println();
            for (SoftmapParseError error : parseErrors) {
                Object contentSplice;
                if (error.endCodepoint - error.startCodepoint < 100) {
                    contentSplice = softmapContent.substring(error.startCodepoint, error.endCodepoint);
                } else {
                    contentSplice = softmapContent.substring(error.startCodepoint, error.startCodepoint + 80);
                    contentSplice = (String)contentSplice + "... (and " + (error.endCodepoint - error.startCodepoint - 80) + " further characters)";
                }
                LOGGER.error("Syntax error in softmap file {} (row {}, column {}): {}", new Object[]{softmapFile, error.row, error.column, error.getDescription()});
                LOGGER.error("Invalid token: {}", contentSplice);
            }
            System.out.println();
        }
        if (!(applyErrors = (result = softmapContext.tryApply(obfuscatedNodes)).getErrors()).isEmpty()) {
            System.out.println();
            for (SoftmapApplicationError error : applyErrors) {
                Object contentSplice;
                Token errorLoc = error.getErrorLocation();
                if (errorLoc.getStart() - errorLoc.getEnd() < 100) {
                    contentSplice = softmapContent.substring(errorLoc.getStart(), errorLoc.getEnd());
                } else {
                    contentSplice = softmapContent.substring(errorLoc.getStart(), errorLoc.getStart() + 80);
                    contentSplice = (String)contentSplice + "... (and " + (errorLoc.getEnd() - errorLoc.getStart() - 80) + " further characters)";
                }
                LOGGER.error("Application error in softmap file {} (row {}, column {}): {}.", new Object[]{softmapFile, errorLoc.getRow(), errorLoc.getColumn(), error.getDescription()});
                LOGGER.error("Invalid token: {}", contentSplice);
            }
            System.out.println();
        }
        LOGGER.info("Softmap file {} compiled in {}ms.", (Object)softmapFile, (Object)(System.currentTimeMillis() - fileStart));
        return result.getGeneratedTinyV1Mappings();
    }

    public void deobfuscateJar(@NotNull Path source, @NotNull Path target) throws IOException {
        HashMap<String, ClassNode> libraryNodes;
        HashMap<String, byte[]> rawFiles;
        HashMap<String, ClassNode> remapNodes;
        ArrayList<Object> lookups;
        block61: {
            block60: {
                Path spstarmap = this.cacheDir.resolve(STARMAP_FILE_NAME);
                Path slintermediary = this.cacheDir.resolve(INTERMEDIARY_FILE_NAME);
                Path compiledSoftmap = this.cacheDir.resolve(COMPILED_SOFTMAP_FILE_NAME);
                lookups = new ArrayList<Object>();
                lookups.add((Object)new StarplaneMappingLookup(slintermediary, false).load());
                lookups.add((Object)new StarplaneMappingLookup(spstarmap, false).load());
                lookups.add((Object)new StarplaneMappingLookup(compiledSoftmap, false, true).load());
                if (!this.supplementaryMappings.isEmpty()) {
                    LOGGER.info("Loading supplementary mappings");
                    for (MIOMappingTreeProvider provider : this.supplementaryMappings) {
                        VisitableMappingTree mappingTree = provider.get();
                        lookups.add(new ReadOnlyMIOMappingLookup((MappingTreeView)mappingTree, mappingTree.getMinNamespaceId(), mappingTree.getMaxNamespaceId() - 1));
                    }
                }
                remapNodes = new HashMap<String, ClassNode>();
                rawFiles = new HashMap<String, byte[]>();
                try (InputStream is = Files.newInputStream(source, new OpenOption[0]);){
                    ZipInputStream zipIn = new ZipInputStream(is, StandardCharsets.UTF_8);
                    block39: while (true) {
                        ZipEntry e;
                        while ((e = zipIn.getNextEntry()) != null) {
                            byte[] allData = zipIn.readAllBytes();
                            if (allData.length < 4 || allData[0] != -54 || allData[1] != -2 || allData[2] != -70 || allData[3] != -66 || !e.getName().endsWith(".class")) {
                                if (rawFiles.put(e.getName(), allData) == null) continue;
                                LOGGER.warn("Overwrote entry for raw file {}. The remapped jar may be malformed", (Object)e.getName());
                                continue;
                            }
                            try {
                                ClassReader classReader = new ClassReader(allData);
                                ClassNode visitedNode = new ClassNode();
                                classReader.accept((ClassVisitor)visitedNode, 0);
                                remapNodes.put(e.getName(), visitedNode);
                                continue block39;
                            }
                            catch (Exception exception) {
                                LOGGER.warn("Unable to read classfile {}; treating it as a regular file instead.", (Object)e.getName(), (Object)exception);
                                if (rawFiles.put(e.getName(), allData) == null) continue;
                                LOGGER.warn("Overwrote entry for raw file {}. The remapped jar may be malformed", (Object)e.getName());
                            }
                        }
                        break block60;
                        {
                            continue block39;
                            break;
                        }
                        break;
                    }
                    finally {
                        zipIn.close();
                    }
                }
                catch (IOException e) {
                    throw new IOException("Unable to read input jar " + String.valueOf(source), e);
                }
            }
            libraryNodes = new HashMap<String, ClassNode>();
            try (InputStream is = Files.newInputStream(this.getOriginalGalimulatorJar(), new OpenOption[0]);){
                ZipInputStream zipIn = new ZipInputStream(is, StandardCharsets.UTF_8);
                block41: while (true) {
                    Object e;
                    while ((e = zipIn.getNextEntry()) != null) {
                        byte[] byArray = zipIn.readAllBytes();
                        if (byArray.length < 4 || byArray[0] != -54 || byArray[1] != -2 || byArray[2] != -70 || byArray[3] != -66 || !((ZipEntry)e).getName().endsWith(".class")) continue;
                        try {
                            ClassReader reader = new ClassReader(byArray);
                            ClassNode visitedNode = new ClassNode();
                            reader.accept((ClassVisitor)visitedNode, 6);
                            if (libraryNodes.put(visitedNode.name, visitedNode) == null) continue block41;
                            LOGGER.warn("Collision for path {}, entry {}. Likely caused due to unexpected multi-release-jar", (Object)visitedNode.name, (Object)((ZipEntry)e).getName());
                            continue block41;
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Unable to read library classfile {}; skipping it instead.", (Object)((ZipEntry)e).getName(), (Object)ex);
                        }
                    }
                    break block61;
                    {
                        continue block41;
                        break;
                    }
                    break;
                }
                finally {
                    zipIn.close();
                }
            }
        }
        HashMap<Integer, Map> mrjClasses = new HashMap<Integer, Map>();
        int maxMrjVersion = 8;
        for (Map.Entry entry : remapNodes.entrySet()) {
            String path = (String)entry.getKey();
            ClassNode node = (ClassNode)entry.getValue();
            String fullpath = path;
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            int mrjVersion = 8;
            if (path.startsWith("META-INF/versions/") && (mrjVersion = Integer.parseInt((path = path.substring(18)).substring(0, path.indexOf(47)))) < 9) {
                LOGGER.warn("Class {} of path {} would fit under the multi-release jar version of {} - which makes little sense as that would be before the introduction of multi-release jars.", new Object[]{node.name, fullpath, mrjVersion});
                mrjVersion = 8;
            }
            if (mrjVersion > maxMrjVersion) {
                maxMrjVersion = mrjVersion;
            }
            mrjClasses.computeIfAbsent(mrjVersion, ignored -> new HashMap()).put(node.name, node);
        }
        try (OutputStream os = Files.newOutputStream(target, new OpenOption[0]);
             ZipOutputStream zipOutputStream = new ZipOutputStream(os, StandardCharsets.UTF_8);){
            ChainMappingLookup externalLookups = new ChainMappingLookup(lookups.toArray(new MappingLookup[0]));
            for (int mrjVersion = maxMrjVersion; mrjVersion >= 8; --mrjVersion) {
                Map versionClasses = (Map)mrjClasses.remove(mrjVersion);
                if (versionClasses == null) continue;
                ArrayList mainClasses = new ArrayList(versionClasses.values());
                mainClasses.sort((n1, n2) -> n1.name.compareTo(n2.name));
                for (int earlierVersion = mrjVersion; earlierVersion >= 8; --earlierVersion) {
                    Map availableEarlier = (Map)mrjClasses.get(earlierVersion);
                    if (availableEarlier == null) continue;
                    for (Map.Entry earlierEntry : availableEarlier.entrySet()) {
                        versionClasses.putIfAbsent((String)earlierEntry.getKey(), (ClassNode)earlierEntry.getValue());
                    }
                }
                ArrayList allClasses = new ArrayList(libraryNodes.values());
                allClasses.addAll(versionClasses.values());
                SimpleTopLevelLookup allTopLevelLookup = new SimpleTopLevelLookup(allClasses);
                DebugableMemberLister libraryMemberLister = new DebugableMemberLister(allTopLevelLookup, libraryNodes);
                SimpleHierarchyAwareMappingLookup mixinLookup = new SimpleHierarchyAwareMappingLookup(Collections.unmodifiableList(allClasses));
                ReadOnlyMappingLookupSink readOnlyExternalLookups = new ReadOnlyMappingLookupSink(externalLookups);
                HierarchyAwareMappingDelegator externalHierarchyLookup = new HierarchyAwareMappingDelegator((MappingLookup)readOnlyExternalLookups, (HierarchyAwareMappingDelegator.TopLevelMemberLookup)allTopLevelLookup);
                ChainMappingLookup allLookup = new ChainMappingLookup(new MappingLookup[]{mixinLookup, externalHierarchyLookup});
                MicromixinRemapper mixinRemapper = new MicromixinRemapper((MappingLookup)allLookup, (MappingSink)mixinLookup, (MemberLister)libraryMemberLister);
                Remapper coreRemaper = new Remapper((MappingLookup)allLookup);
                StringBuilder sharedBuilder = new StringBuilder();
                for (ClassNode classNode : mainClasses) {
                    ClassNode classNode2 = Objects.requireNonNull(classNode);
                    StarplaneAnnotationRemapper.apply(classNode2, coreRemaper, sharedBuilder);
                    try {
                        mixinRemapper.remapClass(classNode2);
                    }
                    catch (IllegalMixinException | MissingFeatureException e) {
                        throw new IOException("Unable to remap due to a problem which occured while remapping mixin " + classNode2.name + " in multi-release-jar sourceset " + mrjVersion, e);
                    }
                    coreRemaper.remapNode(classNode2, sharedBuilder);
                    ClassWriter writer = new ClassWriter(0);
                    classNode2.accept((ClassVisitor)writer);
                    if (mrjVersion != 8) {
                        zipOutputStream.putNextEntry(new ZipEntry("META-INF/versions/" + mrjVersion + "/" + classNode2.name + ".class"));
                    } else {
                        zipOutputStream.putNextEntry(new ZipEntry(classNode2.name + ".class"));
                    }
                    zipOutputStream.write(writer.toByteArray());
                }
                if (mrjVersion != 8) continue;
                for (Map.Entry entry : rawFiles.entrySet()) {
                    zipOutputStream.putNextEntry(new ZipEntry((String)entry.getKey()));
                    byte[] data = (byte[])entry.getValue();
                    if (((String)entry.getKey()).toLowerCase(Locale.ROOT).endsWith(".ras")) {
                        data = new RASRemapper(allLookup, sharedBuilder).transform(data, "jar://?!" + (String)entry.getKey());
                    }
                    zipOutputStream.write(data);
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObfuscationHandler) {
            ObfuscationHandler other = (ObfuscationHandler)obj;
            return Objects.equals(this.rasContent, other.rasContent) && this.cacheDir.equals(other.cacheDir) && this.projectDir.equals(other.projectDir) && this.softmapFiles.equals(other.softmapFiles);
        }
        return false;
    }

    @NotNull
    private String getAdditionalMappingChecksums() throws IOException {
        if (this.softmapFiles.isEmpty() && this.supplementaryMappings.isEmpty()) {
            return "0";
        }
        Adler32 csum = new Adler32();
        for (Path p : this.softmapFiles) {
            try (CheckedInputStream cis = new CheckedInputStream(Files.newInputStream(p, new OpenOption[0]), csum);){
                while (cis.read(IO_BUFFER) != -1) {
                }
            }
        }
        for (MIOMappingTreeProvider e : this.supplementaryMappings) {
            e.checksum(csum, IO_BUFFER);
        }
        return Long.toUnsignedString(csum.getValue(), 36);
    }

    @NotNull
    public Path getOriginalGalimulatorJar() {
        File cleanGalimJar;
        block0: {
            block4: {
                block3: {
                    block2: {
                        block1: {
                            cleanGalimJar = new File(this.projectDir.toFile(), "galimulator-desktop.jar");
                            if (cleanGalimJar.exists()) break block0;
                            LOGGER.debug("Galimulator jar at " + cleanGalimJar.getAbsolutePath() + " not found.");
                            cleanGalimJar = new File(this.cacheDir.toFile(), "galimulator-desktop.jar");
                            if (cleanGalimJar.exists()) break block0;
                            LOGGER.debug("Galimulator jar at " + cleanGalimJar.getAbsolutePath() + " not found.");
                            String propertyPath = System.getProperty("de.geolykt.starplane.galimulator-jar");
                            if (propertyPath == null) break block1;
                            cleanGalimJar = this.projectDir.resolve(propertyPath).toFile();
                            if (cleanGalimJar.exists()) break block0;
                            LOGGER.warn("Galimulator jar at " + cleanGalimJar.getAbsolutePath() + " not found.");
                            break block2;
                        }
                        LOGGER.debug("System property 'de.geolykt.starplane.galimulator-jar' not defined.");
                    }
                    File galimDir = Utils.getGameDir("Galimulator");
                    if (galimDir == null || !galimDir.exists()) break block3;
                    cleanGalimJar = new File(galimDir, "jar/galimulator-desktop.jar");
                    if (cleanGalimJar.exists()) break block0;
                    LOGGER.error("Unable to resolve galimulator jar file (was able to resolve the potential directory though)!");
                    break block4;
                }
                LOGGER.error("Unable to resolve galimulator directory!");
            }
            throw new IllegalStateException("Cannot resolve dependencies");
        }
        return cleanGalimJar.toPath();
    }

    @NotNull
    public CommentLookup getJavadocLookup() throws IOException {
        ArrayList<@NotNull ReadOnlyMIOMappingLookup> lookups = new ArrayList<ReadOnlyMIOMappingLookup>();
        if (!this.supplementaryMappings.isEmpty()) {
            for (MIOMappingTreeProvider provider : this.supplementaryMappings) {
                VisitableMappingTree mappingTree = provider.get();
                lookups.add(0, new ReadOnlyMIOMappingLookup((MappingTreeView)mappingTree, mappingTree.getMaxNamespaceId() - 1, mappingTree.getMinNamespaceId()));
            }
        }
        return new ChainMappingLookup(lookups.toArray(new MappingLookup[0]));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public Path getTransformedGalimulatorJar() {
        ReversibleAccessSetterContext rasInfo;
        if (!Files.isDirectory(this.cacheDir, new LinkOption[0])) {
            try {
                Files.createDirectories(this.cacheDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create cache folder!", e);
            }
        }
        Path awHash = this.cacheDir.resolve("accesswidener-hash.dat");
        boolean recomputeAw = false;
        Object currentHash = null;
        String rasContent = this.rasContent;
        if (rasContent == null) {
            rasInfo = null;
        } else {
            try (DigestInputStream din = new DigestInputStream(new ByteArrayInputStream(rasContent.getBytes(StandardCharsets.UTF_8)), MessageDigest.getInstance("SHA-1"));
                 BufferedReader br = new BufferedReader(new InputStreamReader(din));){
                rasInfo = new ReversibleAccessSetterContext(ReversibleAccessSetterContext.RASTransformScope.BUILDTIME, false);
                rasInfo.read("<mod>", br, false);
                currentHash = ObfuscationHandler.toHexHash(din.getMessageDigest().digest());
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to read reversibleAccessSetter!", e);
            }
        }
        try {
            currentHash = currentHash + "-" + ObfuscationHandler.getStarplaneChecksum() + "-" + this.getAdditionalMappingChecksums();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (Files.exists(awHash, new LinkOption[0])) {
            try (BufferedReader br = Files.newBufferedReader(awHash, StandardCharsets.UTF_8);){
                String readLine = br.readLine();
                if (!readLine.equalsIgnoreCase((String)currentHash)) {
                    recomputeAw = true;
                    LOGGER.warn("AW Hash mismatch. Expected: " + readLine + ", but the current aw hash is " + (String)currentHash + ". Caches are considered invalid.");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                recomputeAw = true;
            }
        } else if (rasInfo != null) {
            recomputeAw = true;
        }
        Path runAccess = this.cacheDir.resolve("galimulator-remapped-rt.jar");
        Path compileAccess = this.cacheDir.resolve("galimulator-remapped.jar");
        if (Files.isRegularFile(runAccess, new LinkOption[0]) && Files.isRegularFile(compileAccess, new LinkOption[0]) && !Boolean.getBoolean("de.geolykt.starplane.nocache") && !recomputeAw) {
            return compileAccess;
        }
        this.didRefresh = true;
        Path cleanGalimJar = this.getOriginalGalimulatorJar();
        LOGGER.info("Using the base galimulator jar found at " + String.valueOf(cleanGalimJar.toAbsolutePath()));
        Path map = this.cacheDir.resolve(INTERMEDIARY_FILE_NAME);
        Oaktree deobfuscator = new Oaktree();
        try {
            long start = System.currentTimeMillis();
            JarFile jar = new JarFile(cleanGalimJar.toFile());
            deobfuscator.index(jar);
            jar.close();
            HashMap<String, ClassNode> nameToNode = new HashMap<String, ClassNode>();
            for (ClassNode node : deobfuscator.getClassNodesDirectly()) {
                nameToNode.put(node.name, node);
            }
            LOGGER.info("Loaded input jar in " + (System.currentTimeMillis() - start) + " ms.");
            long startDeobf = System.currentTimeMillis();
            deobfuscator.fixInnerClasses();
            deobfuscator.fixParameterLVT();
            deobfuscator.guessFieldGenerics();
            this.addSignatures(deobfuscator.getClassNodesDirectly(), nameToNode, deobfuscator.analyseLikelyMethodReturnCollectionGenerics());
            HashMap<MethodReference, ClassWrapper> methods = new HashMap<MethodReference, ClassWrapper>();
            deobfuscator.lambdaStreamGenericSignatureGuessing(null, methods);
            this.addSignatures(deobfuscator.getClassNodesDirectly(), nameToNode, methods);
            deobfuscator.inferMethodGenerics();
            deobfuscator.inferConstructorGenerics();
            deobfuscator.fixForeachOnArray();
            deobfuscator.fixComparators(true);
            deobfuscator.guessAnonymousInnerClasses();
            for (ClassNode node : deobfuscator.getClassNodesDirectly()) {
                for (InnerClassNode icn : node.innerClasses) {
                    icn.access &= 0xFFFFFFDF;
                }
            }
            LOGGER.info("Deobfuscated classes in " + (System.currentTimeMillis() - startDeobf) + " ms.");
            long startIntermediarisation = System.currentTimeMillis();
            IntermediaryGenerator generator = new IntermediaryGenerator(map, null, (Collection)deobfuscator.getClassNodesDirectly());
            generator.useAlternateClassNaming(!Boolean.getBoolean("de.geolykt.starplane.oldnames"));
            generator.remapClassesV2(true);
            deobfuscator.fixSwitchMaps();
            generator.doProposeEnumFieldsV2();
            generator.remapGetters();
            generator.deobfuscate();
            try {
                de.geolykt.starloader.deobf.remapper.Remapper remapper = new de.geolykt.starloader.deobf.remapper.Remapper();
                remapper.addTargets((Collection)deobfuscator.getClassNodesDirectly());
                long startSlStarmap = System.currentTimeMillis();
                Autodeobf deobf = new Autodeobf(deobfuscator.getClassNodesDirectly(), remapper);
                try (BufferedWriter writer = Files.newBufferedWriter(this.cacheDir.resolve(STARMAP_FILE_NAME), StandardOpenOption.CREATE);){
                    writer.write("v1\tintermediary\tnamed\n");
                    deobf.runAll(writer);
                    for (Map.Entry entry : remapper.fixICNNames(new StringBuilder()).entrySet()) {
                        writer.write("CLASS\t");
                        writer.write((String)entry.getKey());
                        ((Writer)writer).write(9);
                        writer.write((String)entry.getValue());
                        ((Writer)writer).write(10);
                    }
                    ((Writer)writer).flush();
                    remapper.process();
                }
                LOGGER.info("Computed spStarmap in " + (System.currentTimeMillis() - startSlStarmap) + " ms.");
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot write Autodeobf.java-generated mappings", e);
            }
            try {
                Path compiledSoftmap = this.cacheDir.resolve(COMPILED_SOFTMAP_FILE_NAME);
                if (this.softmapFiles.isEmpty()) {
                    Files.deleteIfExists(compiledSoftmap);
                } else {
                    de.geolykt.starloader.deobf.remapper.Remapper remapper = new de.geolykt.starloader.deobf.remapper.Remapper();
                    remapper.addTargets((Collection)deobfuscator.getClassNodesDirectly());
                    long startOfSoftmap = System.currentTimeMillis();
                    @NotNull @NotNull List nodes = deobfuscator.getClassNodesDirectly();
                    ArrayList<@NotNull String> allTiny = new ArrayList<String>();
                    allTiny.add("v1\tintermediary\tnamed");
                    allTiny.add("# This file was compiled from softmap files, do not touch unless you know what you are doing");
                    for (Path softmapFile : this.softmapFiles) {
                        List<@NotNull String> generatedTiny = this.compileSoftmap(softmapFile, nodes);
                        allTiny.addAll(generatedTiny);
                        for (String s : generatedTiny) {
                            String[] parts = s.split("\\s+");
                            if (parts[0].equals("METHOD")) {
                                remapper.remapMethod(parts[1], parts[2], parts[3], parts[4]);
                                continue;
                            }
                            if (parts[0].equals("FIELD")) {
                                remapper.remapField(parts[1], parts[2], parts[3], parts[4]);
                                continue;
                            }
                            if (!parts[0].equals("CLASS")) continue;
                            remapper.remapClassName(parts[1], parts[2]);
                        }
                        remapper.process();
                    }
                    Files.write(compiledSoftmap, allTiny, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    LOGGER.info("Compiled all softmap files in " + (System.currentTimeMillis() - startOfSoftmap) + "ms.");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot write softmap-generated mappings", e);
            }
            if (!this.supplementaryMappings.isEmpty()) {
                for (MIOMappingTreeProvider supplementaryMapping : this.supplementaryMappings) {
                    VisitableMappingTree mappingTree = supplementaryMapping.get();
                    SimpleTopLevelLookup definitionLookup = new SimpleTopLevelLookup(deobfuscator.getClassNodesDirectly());
                    ReadOnlyMIOMappingLookup directLookup = new ReadOnlyMIOMappingLookup((MappingTreeView)mappingTree, mappingTree.getMinNamespaceId(), mappingTree.getMaxNamespaceId() - 1);
                    HierarchyAwareMappingDelegator hierarchicalLookup = new HierarchyAwareMappingDelegator((MappingLookup)directLookup, (HierarchyAwareMappingDelegator.TopLevelMemberLookup)definitionLookup);
                    Remapper remapper = new Remapper((MappingLookup)hierarchicalLookup);
                    StringBuilder sharedBuilder = new StringBuilder();
                    for (ClassNode node : deobfuscator.getClassNodesDirectly()) {
                        remapper.remapNode(node, sharedBuilder);
                    }
                }
            }
            deobfuscator.invalidateNameCaches();
            deobfuscator.applyInnerclasses();
            LOGGER.info("Computed intermediaries of classes in " + (System.currentTimeMillis() - startIntermediarisation) + " ms.");
            if (rasInfo == null) {
                try (OutputStream os = Files.newOutputStream(compileAccess, new OpenOption[0]);){
                    deobfuscator.write(os, cleanGalimJar);
                }
                Files.copy(compileAccess, runAccess, StandardCopyOption.REPLACE_EXISTING);
                try {
                    Files.writeString(awHash, (CharSequence)currentHash, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot write aw hash; caching may not work correctly", (Throwable)e);
                }
            } else {
                ArrayList<ClassNode> runNodes = new ArrayList<ClassNode>();
                HashMap<String, ClassNode> compileNodes = new HashMap<String, ClassNode>();
                for (ClassNode node : deobfuscator.getClassNodesDirectly()) {
                    if (node == null) continue;
                    try {
                        rasInfo.accept(node);
                    }
                    catch (ReversibleAccessSetterContext.RASTransformFailure e) {
                        LOGGER.error("Unable to apply RAS on class {}", (Object)node.name, (Object)e);
                    }
                    ClassNode duplicate = new ClassNode();
                    node.accept((ClassVisitor)duplicate);
                    runNodes.add(duplicate);
                    compileNodes.put(node.name, node);
                }
                try {
                    Files.writeString(awHash, (CharSequence)currentHash, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot write aw hash; caching may not work correctly", (Throwable)e);
                }
                try (OutputStream os = Files.newOutputStream(compileAccess, new OpenOption[0]);){
                    deobfuscator.write(os, cleanGalimJar);
                }
                os = new ZipOutputStream(Files.newOutputStream(runAccess, new OpenOption[0]), StandardCharsets.UTF_8);
                try {
                    try (InputStream rawIn = Files.newInputStream(cleanGalimJar, new OpenOption[0]);
                         ZipInputStream zipIn = new ZipInputStream(rawIn);){
                        ZipEntry entry = zipIn.getNextEntry();
                        while (entry != null) {
                            if (!entry.getName().endsWith(".class")) {
                                int read;
                                ((ZipOutputStream)os).putNextEntry(entry);
                                byte[] byArray = new byte[4096];
                                while ((read = zipIn.read(byArray)) != -1) {
                                    ((ZipOutputStream)os).write(byArray, 0, read);
                                }
                            }
                            entry = zipIn.getNextEntry();
                        }
                    }
                    TreeSet<ClassNode> sortedNodes = new TreeSet<ClassNode>((node1, node2) -> node1.name.compareTo(node2.name));
                    sortedNodes.addAll(runNodes);
                    for (ClassNode node : sortedNodes) {
                        ClassWriter classWriter = new ClassWriter(0);
                        node.accept((ClassVisitor)classWriter);
                        ((ZipOutputStream)os).putNextEntry(new ZipEntry(node.name + ".class"));
                        ((FilterOutputStream)os).write(classWriter.toByteArray());
                    }
                }
                finally {
                    ((ZipOutputStream)os).close();
                }
            }
            LOGGER.info("Finished transforming classes in " + (System.currentTimeMillis() - start) + " ms.");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return compileAccess;
    }

    public int hashCode() {
        return Objects.hash(this.rasContent, this.cacheDir, this.projectDir, this.softmapFiles);
    }

    public void reobfuscateJar(@NotNull Path jarPath, @NotNull @NotNull Collection<@NotNull Path> alsoInclude) throws IOException {
        HashMap<String, ClassNode> libraryNodes;
        HashMap<String, byte[]> rawFiles;
        HashMap<String, ClassNode> remapNodes;
        ArrayList<Object> lookups;
        block60: {
            Path spstarmap = this.cacheDir.resolve(STARMAP_FILE_NAME);
            Path slintermediary = this.cacheDir.resolve(INTERMEDIARY_FILE_NAME);
            Path compiledSoftmap = this.cacheDir.resolve(COMPILED_SOFTMAP_FILE_NAME);
            lookups = new ArrayList<Object>();
            lookups.add((Object)new StarplaneMappingLookup(compiledSoftmap, true, true).load());
            lookups.add((Object)new StarplaneMappingLookup(spstarmap, true).load());
            lookups.add((Object)new StarplaneMappingLookup(slintermediary, true).load());
            if (!this.supplementaryMappings.isEmpty()) {
                LOGGER.info("Loading supplementary mappings");
                for (MIOMappingTreeProvider provider : this.supplementaryMappings) {
                    VisitableMappingTree mappingTree = provider.get();
                    lookups.add(0, new ReadOnlyMIOMappingLookup((MappingTreeView)mappingTree, mappingTree.getMaxNamespaceId() - 1, mappingTree.getMinNamespaceId()));
                }
            }
            remapNodes = new HashMap<String, ClassNode>();
            rawFiles = new HashMap<String, byte[]>();
            HashSet<@NotNull Path> allInputs = new HashSet<Path>(alsoInclude);
            allInputs.add(jarPath);
            block39: for (Path p : allInputs) {
                try {
                    InputStream is = Files.newInputStream(p, new OpenOption[0]);
                    try {
                        ZipInputStream zipIn = new ZipInputStream(is, StandardCharsets.UTF_8);
                        block40: while (true) {
                            ZipEntry zipEntry;
                            while ((zipEntry = zipIn.getNextEntry()) != null) {
                                byte[] allData = zipIn.readAllBytes();
                                if (allData.length < 4 || allData[0] != -54 || allData[1] != -2 || allData[2] != -70 || allData[3] != -66 || !zipEntry.getName().endsWith(".class")) {
                                    if (rawFiles.put(zipEntry.getName(), allData) == null) continue;
                                    LOGGER.warn("Overwrote entry for raw file {}. The remapped jar may be malformed", (Object)zipEntry.getName());
                                    continue;
                                }
                                try {
                                    ClassReader reader = new ClassReader(allData);
                                    ClassNode visitedNode = new ClassNode();
                                    reader.accept((ClassVisitor)visitedNode, 0);
                                    remapNodes.put(zipEntry.getName(), visitedNode);
                                    continue block40;
                                }
                                catch (Exception ex) {
                                    LOGGER.warn("Unable to read classfile {}; treating it as a regular file instead.", (Object)zipEntry.getName(), (Object)ex);
                                    if (rawFiles.put(zipEntry.getName(), allData) == null) continue;
                                    LOGGER.warn("Overwrote entry for raw file {}. The remapped jar may be malformed", (Object)zipEntry.getName());
                                }
                            }
                            continue block39;
                            {
                                continue block40;
                                break;
                            }
                            break;
                        }
                        finally {
                            zipIn.close();
                        }
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new IOException("Unable to read input jar " + String.valueOf(jarPath), e);
                }
            }
            libraryNodes = new HashMap<String, ClassNode>();
            try (InputStream is = Files.newInputStream(this.getTransformedGalimulatorJar(), new OpenOption[0]);){
                ZipInputStream zipIn = new ZipInputStream(is, StandardCharsets.UTF_8);
                block42: while (true) {
                    Object e;
                    while ((e = zipIn.getNextEntry()) != null) {
                        byte[] byArray = zipIn.readAllBytes();
                        if (byArray.length < 4 || byArray[0] != -54 || byArray[1] != -2 || byArray[2] != -70 || byArray[3] != -66 || !((ZipEntry)e).getName().endsWith(".class")) continue;
                        try {
                            ClassReader reader = new ClassReader(byArray);
                            ClassNode visitedNode = new ClassNode();
                            reader.accept((ClassVisitor)visitedNode, 6);
                            if (libraryNodes.put(visitedNode.name, visitedNode) == null) continue block42;
                            LOGGER.warn("Collision for path {}, entry {}. Likely caused due to unexpected multi-release-jar", (Object)visitedNode.name, (Object)((ZipEntry)e).getName());
                            continue block42;
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Unable to read library classfile {}; skipping it instead.", (Object)((ZipEntry)e).getName(), (Object)ex);
                        }
                    }
                    break block60;
                    {
                        continue block42;
                        break;
                    }
                    break;
                }
                finally {
                    zipIn.close();
                }
            }
        }
        HashMap<Integer, Map> mrjClasses = new HashMap<Integer, Map>();
        int maxMrjVersion = 8;
        for (Map.Entry entry : remapNodes.entrySet()) {
            String path = (String)entry.getKey();
            ClassNode node = (ClassNode)entry.getValue();
            String fullpath = path;
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            int mrjVersion = 8;
            if (path.startsWith("META-INF/versions/") && (mrjVersion = Integer.parseInt((path = path.substring(18)).substring(0, path.indexOf(47)))) < 9) {
                LOGGER.warn("Class {} of path {} would fit under the multi-release jar version of {} - which makes little sense as that would be before the introduction of multi-release jars.", new Object[]{node.name, fullpath, mrjVersion});
                mrjVersion = 8;
            }
            if (mrjVersion > maxMrjVersion) {
                maxMrjVersion = mrjVersion;
            }
            mrjClasses.computeIfAbsent(mrjVersion, ignored -> new HashMap()).put(node.name, node);
        }
        try (OutputStream os = Files.newOutputStream(jarPath, new OpenOption[0]);
             ZipOutputStream zipOutputStream = new ZipOutputStream(os, StandardCharsets.UTF_8);){
            ChainMappingLookup externalLookups = new ChainMappingLookup(lookups.toArray(new MappingLookup[0]));
            for (int mrjVersion = maxMrjVersion; mrjVersion >= 8; --mrjVersion) {
                Map versionClasses = (Map)mrjClasses.remove(mrjVersion);
                if (versionClasses == null) continue;
                ArrayList mainClasses = new ArrayList(versionClasses.values());
                mainClasses.sort((n1, n2) -> n1.name.compareTo(n2.name));
                for (int earlierVersion = mrjVersion; earlierVersion >= 8; --earlierVersion) {
                    Map availableEarlier = (Map)mrjClasses.get(earlierVersion);
                    if (availableEarlier == null) continue;
                    for (Map.Entry earlierEntry : availableEarlier.entrySet()) {
                        versionClasses.putIfAbsent((String)earlierEntry.getKey(), (ClassNode)earlierEntry.getValue());
                    }
                }
                ArrayList allClasses = new ArrayList(libraryNodes.values());
                allClasses.addAll(mainClasses);
                SimpleTopLevelLookup allTopLevelLookup = new SimpleTopLevelLookup(allClasses);
                DebugableMemberLister libraryMemberLister = new DebugableMemberLister(allTopLevelLookup, libraryNodes);
                SimpleHierarchyAwareMappingLookup mixinLookup = new SimpleHierarchyAwareMappingLookup(new ArrayList(versionClasses.values()));
                ReadOnlyMappingLookupSink readOnlyExternalLookups = new ReadOnlyMappingLookupSink(externalLookups);
                HierarchyAwareMappingDelegator externalHierarchyLookup = new HierarchyAwareMappingDelegator((MappingLookup)readOnlyExternalLookups, (HierarchyAwareMappingDelegator.TopLevelMemberLookup)allTopLevelLookup);
                ChainMappingLookup allLookup = new ChainMappingLookup(new MappingLookup[]{mixinLookup, externalHierarchyLookup});
                MicromixinRemapper mixinRemapper = new MicromixinRemapper((MappingLookup)allLookup, (MappingSink)mixinLookup, (MemberLister)libraryMemberLister);
                Remapper coreRemaper = new Remapper((MappingLookup)allLookup);
                StringBuilder sharedBuilder = new StringBuilder();
                for (ClassNode classNode : mainClasses) {
                    ClassNode classNode2 = Objects.requireNonNull(classNode);
                    StarplaneAnnotationRemapper.apply(classNode2, coreRemaper, sharedBuilder);
                    try {
                        mixinRemapper.remapClass(classNode2);
                    }
                    catch (IllegalMixinException | MissingFeatureException e) {
                        throw new IOException("Unable to remap due to a problem which occured while remapping mixin " + classNode2.name + " in multi-release-jar sourceset " + mrjVersion, e);
                    }
                    coreRemaper.remapNode(classNode2, sharedBuilder);
                    ClassWriter writer = new ClassWriter(0);
                    classNode2.accept((ClassVisitor)writer);
                    if (mrjVersion != 8) {
                        zipOutputStream.putNextEntry(new ZipEntry("META-INF/versions/" + mrjVersion + "/" + classNode2.name + ".class"));
                    } else {
                        zipOutputStream.putNextEntry(new ZipEntry(classNode2.name + ".class"));
                    }
                    zipOutputStream.write(writer.toByteArray());
                }
                if (mrjVersion != 8) continue;
                for (Map.Entry entry : rawFiles.entrySet()) {
                    zipOutputStream.putNextEntry(new ZipEntry((String)entry.getKey()));
                    byte[] data = (byte[])entry.getValue();
                    if (((String)entry.getKey()).toLowerCase(Locale.ROOT).endsWith(".ras")) {
                        data = new RASRemapper(allLookup, sharedBuilder).transform(data, "jar://?!" + (String)entry.getKey());
                    }
                    zipOutputStream.write(data);
                }
            }
        }
        LOGGER.info("Reobfuscating done");
    }
}

