/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.gslstarplane;

import de.geolykt.starloader.gslstarplane.GslStarplanePlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

@DisableCachingByDefault(because="No outputs")
public abstract class GslVerifyRemapperJarTask
extends ConventionTask {
    private static void pushJarContents(@NotNull Path p, Map<String, MethodNamespace> out) throws IOException {
        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);
             ZipInputStream zipIn = new ZipInputStream(is, StandardCharsets.UTF_8);){
            ZipEntry zipE = zipIn.getNextEntry();
            while (zipE != null) {
                if (zipE.getName().endsWith(".class") && !zipE.getName().contains("META-INF/versions/")) {
                    ClassReader reader = new ClassReader((InputStream)zipIn);
                    ClassNode node = new ClassNode();
                    reader.accept((ClassVisitor)node, 3);
                    HashMap<MethodId, InheritanceVariant> methods = new HashMap<MethodId, InheritanceVariant>();
                    for (MethodNode method : node.methods) {
                        methods.put(new MethodId(method.name, method.desc), (method.access & 0x400) == 0 ? InheritanceVariant.PROVIDED : InheritanceVariant.REQUIRE);
                    }
                    out.put(node.name, new MethodNamespace(node.name, node.superName, node.interfaces, methods, (node.access & 0x400) != 0));
                }
                zipE = zipIn.getNextEntry();
            }
        }
    }

    protected void collectMethods(@Nullable MethodNamespace clazz, Map<String, MethodNamespace> classpath, InheritanceVariant criterion, Set<MethodId> out) {
        if (clazz == null) {
            return;
        }
        for (Map.Entry<MethodId, InheritanceVariant> entry : clazz.methods.entrySet()) {
            if (entry.getValue() != criterion) continue;
            out.add(entry.getKey());
        }
        this.collectMethods(classpath.get(clazz.namespaceSuper), classpath, criterion, out);
        for (String itf : clazz.namespaceInterfaces) {
            this.collectMethods(classpath.get(itf), classpath, criterion, out);
        }
    }

    @InputFiles
    @Optional
    public abstract Property<Object> getClasspath();

    public String getGroup() {
        return "GslStarplane";
    }

    @Input
    @Optional
    public abstract Property<Boolean> getIncludingGalimulatorJar();

    @InputFile
    public abstract Property<Object> getValidationJar();

    protected void verifyClass(MethodNamespace clazz, Map<String, MethodNamespace> classpath) {
        if (clazz.isAbstract) {
            return;
        }
        HashSet<MethodId> providedMethods = new HashSet<MethodId>();
        HashSet<MethodId> requiredMethods = new HashSet<MethodId>();
        this.collectMethods(clazz, classpath, InheritanceVariant.PROVIDED, providedMethods);
        this.collectMethods(clazz, classpath, InheritanceVariant.REQUIRE, requiredMethods);
        if (!providedMethods.containsAll(requiredMethods)) {
            requiredMethods.removeAll(providedMethods);
            this.getLogger().error("Class {} may contain mapping tears. Following methods are not properly implemented: {}", (Object)clazz.namespaceName, requiredMethods);
        }
    }

    @TaskAction
    public void verifyJar() throws IOException {
        Path p = this.getProject().file(this.getValidationJar().get()).toPath();
        Object cp = null;
        Object cpObject = this.getClasspath().getOrNull();
        if (cpObject != null) {
            cp = this.getProject().files(new Object[]{cpObject});
        }
        if (((Boolean)this.getIncludingGalimulatorJar().getOrElse((Object)Boolean.TRUE)).booleanValue()) {
            ConfigurableFileCollection galim = this.getProject().files(new Object[]{GslStarplanePlugin.OBF_HANDLERS.get(this.getProject()).getOriginalGalimulatorJar()});
            cp = cp != null ? cp.plus((FileCollection)galim) : galim;
        }
        if (cp == null) {
            this.getLogger().warn("Verification classpath is empty");
            cp = this.getProject().files(new Object[0]);
        }
        if (Files.notExists(p, new LinkOption[0])) {
            this.getLogger().warn("Task '" + this.getPath() + ":" + this.getName() + "' did no work as the input jar does not exist.");
            return;
        }
        HashMap<String, MethodNamespace> verifyClasses = new HashMap<String, MethodNamespace>();
        GslVerifyRemapperJarTask.pushJarContents(p, verifyClasses);
        HashMap<String, MethodNamespace> cpClasses = new HashMap<String, MethodNamespace>();
        for (File f : cp) {
            Path extraPath = f.toPath();
            if (Files.notExists(extraPath, new LinkOption[0]) || Files.isDirectory(extraPath, new LinkOption[0])) {
                this.getLogger().info("Skipping file {} as it either does not exist or is a directory.", (Object)extraPath);
                continue;
            }
            if (extraPath.getFileName().toString().endsWith(".class")) {
                InputStream is = Files.newInputStream(extraPath, new OpenOption[0]);
                try {
                    ClassReader reader = new ClassReader(is);
                    ClassNode node = new ClassNode();
                    reader.accept((ClassVisitor)node, 3);
                    HashMap<MethodId, InheritanceVariant> methods = new HashMap<MethodId, InheritanceVariant>();
                    for (MethodNode method : node.methods) {
                        methods.put(new MethodId(method.name, method.desc), (method.access & 0x400) == 0 ? InheritanceVariant.PROVIDED : InheritanceVariant.REQUIRE);
                    }
                    verifyClasses.put(node.name, new MethodNamespace(node.name, node.superName, node.interfaces, methods, (node.access & 0x400) != 0));
                    continue;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    continue;
                }
            }
            GslVerifyRemapperJarTask.pushJarContents(extraPath, cpClasses);
        }
        cpClasses.putAll(verifyClasses);
        this.getLogger().debug("Verifying classes");
        long timestamp = System.currentTimeMillis();
        verifyClasses.values().forEach(ns -> this.verifyClass((MethodNamespace)ns, (Map<String, MethodNamespace>)cpClasses));
        this.getLogger().debug("Classes verified ({} ms)", (Object)(System.currentTimeMillis() - timestamp));
    }

    private static class MethodId {
        private final String descriptor;
        private final String name;

        public MethodId(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodId) {
                return ((MethodId)obj).name.equals(this.name) && ((MethodId)obj).descriptor.equals(this.descriptor);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.descriptor);
        }

        public String toString() {
            return "'" + this.name + this.descriptor + "'";
        }
    }

    private static enum InheritanceVariant {
        PROVIDED,
        REQUIRE;

    }

    private static class MethodNamespace {
        private final boolean isAbstract;
        private final Map<MethodId, InheritanceVariant> methods;
        private final List<String> namespaceInterfaces;
        private final String namespaceName;
        private final String namespaceSuper;

        public MethodNamespace(String name, String superName, List<String> itf, Map<MethodId, InheritanceVariant> methods, boolean isAbstract) {
            this.namespaceName = name;
            this.namespaceSuper = superName;
            this.namespaceInterfaces = itf;
            this.methods = methods;
            this.isAbstract = isAbstract;
        }
    }
}

