/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.gslstarplane;

import de.geolykt.starloader.gslstarplane.GslStarplanePlugin;
import de.geolykt.starplane.Utils;
import de.geolykt.starplane.XmlWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

@CacheableTask
public class GslGenEclipseRunsTask
extends DefaultTask {
    private final Map<String, List<Object>> additionalRuntimeDependencies;
    @Nullable
    public Object propertyExpansionSource = null;
    private final File runModLaunchFile;

    private static void writeLine(@NotNull BufferedWriter writer, @NotNull String string) throws IOException {
        writer.write(string);
        writer.newLine();
    }

    public GslGenEclipseRunsTask() {
        super.dependsOn(new Object[]{"deployMods"});
        this.runModLaunchFile = super.getProject().file((Object)"runMods.launch");
        this.additionalRuntimeDependencies = new HashMap<String, List<Object>>();
    }

    public void addAdditionalRuntimeDependency(String sourceSet, Object dep) {
        List<Object> dependencyPaths = this.additionalRuntimeDependencies.get(dep);
        if (dependencyPaths == null) {
            dependencyPaths = new ArrayList<Object>();
            this.additionalRuntimeDependencies.put(sourceSet, dependencyPaths);
        }
        if (dep instanceof Task) {
            this.dependsOn(new Object[]{dep});
        }
        dependencyPaths.add(dep);
    }

    public void additionalRuntimeDependency(String sourceSet, Object dep) {
        this.addAdditionalRuntimeDependency(sourceSet, dep);
    }

    public void clearAdditionalRuntimeDependencies() {
        this.additionalRuntimeDependencies.clear();
    }

    public void clearAdditionalRuntimeDependencies(String sourceSet) {
        this.additionalRuntimeDependencies.remove(sourceSet);
    }

    @TaskAction
    public void genRuns() {
        try (XmlWriter writer = new XmlWriter(new FileWriter(this.runModLaunchFile, StandardCharsets.UTF_8));){
            GslGenEclipseRunsTask.writeLine(writer, "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            GslGenEclipseRunsTask.writeLine(writer, "<launchConfiguration type=\"org.eclipse.jdt.launching.localJavaApplication\">");
            writer.indent();
            Object jvmVersion = "17";
            Path workingDir = this.getProject().getProjectDir().toPath();
            ArrayList<Object> jvmArgs = new ArrayList<Object>();
            JavaExec jExecTask = (JavaExec)this.getProject().getTasks().findByName("runMods");
            if (jExecTask != null) {
                jvmVersion = jExecTask.getJavaVersion().isJava9Compatible() ? jExecTask.getJavaVersion().getMajorVersion() : "1." + jExecTask.getJavaVersion().getMajorVersion();
                workingDir = jExecTask.getWorkingDir().toPath();
                jvmArgs.addAll(jExecTask.getAllJvmArgs());
                jvmArgs.add(GslStarplanePlugin.getBootPath(super.getProject()));
            }
            jvmArgs.add("-Dde.geolykt.starloader.launcher.IDELauncher.modURLs=" + this.getModURLs().toString());
            Object propertyExpansionSource = this.propertyExpansionSource;
            if (propertyExpansionSource != null) {
                jvmArgs.add("-Dorg.stianloader.sll.IDELauncher.propertyExpansionSource=" + super.getProject().file(propertyExpansionSource).getAbsolutePath());
            }
            Path dataFolder = workingDir.resolve("data");
            ArrayList<String> classpathElements = new ArrayList<String>();
            if (Files.notExists(dataFolder, new LinkOption[0])) {
                Path galimDataFolder;
                File gameFolder = Utils.getGameDir("Galimulator");
                if (gameFolder == null || Files.notExists(galimDataFolder = gameFolder.toPath().resolve("data"), new LinkOption[0])) {
                    this.getLogger().error("Couldn't locate data folder. You might need to copy the data folder manually in order to be able to run this task");
                } else {
                    try {
                        Files.createSymbolicLink(dataFolder, galimDataFolder, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        this.getLogger().error("Cannot link data folder. You might need to copy the data folder manually in order to be able to run this task", (Throwable)e);
                    }
                }
            }
            classpathElements.add("&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot;?&gt;&#10;&lt;runtimeClasspathEntry path=&quot;5&quot; projectName=&quot;" + this.getProject().getName() + "&quot; type=&quot;1&quot;/&gt;&#10;");
            classpathElements.add("&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot;?&gt;&#10;&lt;runtimeClasspathEntry containerPath=&quot;org.eclipse.buildship.core.gradleclasspathcontainer&quot; javaProject=&quot;" + this.getProject().getName() + "&quot; path=&quot;5&quot; type=&quot;4&quot;/&gt;&#10;");
            classpathElements.add("&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot;?&gt;&#10;&lt;runtimeClasspathEntry containerPath=&quot;org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-" + (String)jvmVersion + "/&quot; path=&quot;5&quot; type=&quot;4&quot;/&gt;&#10;");
            writer.writeListAttr("org.eclipse.jdt.launching.CLASSPATH", classpathElements);
            writer.writeStringAttr("org.eclipse.jdt.launching.MAIN_TYPE", "de.geolykt.starloader.launcher.IDELauncher");
            writer.writeListAttr("org.eclipse.jdt.launching.MODULEPATH", Collections.emptyList());
            writer.writeStringAttr("org.eclipse.jdt.launching.MODULE_NAME", this.getProject().getName());
            writer.writeStringAttr("org.eclipse.jdt.launching.PROJECT_ATTR", this.getProject().getName());
            writer.writeStringAttr("org.eclipse.jdt.launching.WORKING_DIRECTORY", workingDir.toAbsolutePath().toString());
            writer.writeStringAttr("org.eclipse.jdt.launching.VM_ARGUMENTS", String.join((CharSequence)" ", jvmArgs));
            writer.unindent();
            writer.write("</launchConfiguration>");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private JSONArray getModURLs() {
        JSONArray urls = new JSONArray();
        SourceSetContainer sourceSets = (SourceSetContainer)Objects.requireNonNull(super.getProject().getProperties().get("sourceSets"));
        for (SourceSet sourceSet : sourceSets) {
            if (sourceSet.getName().equals("test")) continue;
            try {
                urls.put((Object)this.getProject().file((Object)("bin/" + sourceSet.getName())).toURI().toURL().toExternalForm());
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
            List<Object> additionalDeps = this.additionalRuntimeDependencies.get(sourceSet.getName());
            if (additionalDeps == null) continue;
            for (Object path : additionalDeps) {
                if (path instanceof Configuration) {
                    for (File resolved : ((Configuration)path).getFiles()) {
                        try {
                            urls.put((Object)resolved.toURI().toURL().toExternalForm());
                        }
                        catch (MalformedURLException e) {
                            throw new UncheckedIOException("Invalid URL for file " + resolved + " from path dependency " + path, e);
                        }
                    }
                    continue;
                }
                if (path instanceof File) {
                    path = ((File)path).toURI();
                }
                if (path instanceof URI) {
                    try {
                        path = ((URI)path).toURL();
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else if (path instanceof CharSequence) {
                    try {
                        path = new URL(path.toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (path instanceof URL) {
                    urls.put((Object)((URL)path).toExternalForm());
                    continue;
                }
                try {
                    urls.put((Object)this.getProject().file(path).toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException e) {
                    throw new UncheckedIOException("Invalid URL from path dependency " + path, e);
                }
            }
        }
        return new JSONArray().put((Object)urls);
    }

    @OutputFile
    public File getRunModLaunchFile() {
        return this.runModLaunchFile;
    }

    public void propertyExpansionSource(@Nullable Object o) {
        this.propertyExpansionSource = o;
    }
}

