/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.gslstarplane;

import de.geolykt.starloader.gslstarplane.GradleInteropUtil;
import de.geolykt.starloader.gslstarplane.GslExtension;
import de.geolykt.starloader.gslstarplane.GslStarplanePlugin;
import de.geolykt.starplane.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@DisableCachingByDefault(because="Not worth it")
public abstract class GslDeployModsTask
extends ConventionTask {
    @NotNull
    private final List<Object> modJars = new ArrayList<Object>();

    public static Optional<String> getExtensionName(@NotNull Path in) throws IOException {
        try (InputStream rawIn = Files.newInputStream(in, new OpenOption[0]);
             ZipInputStream zipIn = new ZipInputStream(rawIn);){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                if (entry.getName().equals("extension.json")) {
                    JSONObject extension = new JSONObject(new String(Utils.readAllBytes(zipIn), StandardCharsets.UTF_8));
                    Optional<String> optional = Optional.ofNullable(extension.getString("name"));
                    return optional;
                }
                entry = zipIn.getNextEntry();
            }
        }
        return Optional.empty();
    }

    public GslDeployModsTask() {
        this.getRemapMods().convention((Object)false);
    }

    @TaskAction
    void deployMods() {
        File[] children;
        HashSet<String> extensionNames = new HashSet<String>();
        ArrayList<Path> mods = new ArrayList<Path>();
        for (Path modPath : this.getModPaths()) {
            if (Files.notExists(modPath, new LinkOption[0])) continue;
            try {
                Optional<String> name = GslDeployModsTask.getExtensionName(modPath);
                if (!name.isPresent()) continue;
                mods.add(modPath);
                extensionNames.add(name.get());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Path modDirectory = ((GslExtension)super.getProject().getExtensions().getByType(GslExtension.class)).modDirectory;
        if (modDirectory == null) {
            JavaExec exec = GslStarplanePlugin.RUN_TASKS.get(super.getProject());
            if (exec == null) {
                throw new IllegalStateException("Unable to resolve the extension directory.");
            }
            modDirectory = exec.getWorkingDir().toPath().resolve("mods");
        }
        if (Files.notExists(modDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(modDirectory, new FileAttribute[0]);
            }
            catch (IOException exec) {
                // empty catch block
            }
        }
        if ((children = modDirectory.toFile().listFiles()) == null) {
            children = new File[]{};
        }
        for (File f : children) {
            if (f.isDirectory() || !f.getName().endsWith(".jar")) continue;
            try {
                Optional<String> name = GslDeployModsTask.getExtensionName(f.toPath());
                if (!name.isPresent() || !extensionNames.contains(name.get())) continue;
                f.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Path mod : mods) {
            try {
                Path target = mod.getFileName();
                target = target == null ? modDirectory.resolve("extension-" + GslDeployModsTask.getExtensionName(mod).orElseGet(() -> Long.toString(ThreadLocalRandom.current().nextLong(0L, Long.MAX_VALUE), 36)) + "-.jar") : modDirectory.resolve(target);
                Files.deleteIfExists(target);
                this.transform(mod, target);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void from(Object notation) {
        if (notation instanceof Task) {
            super.dependsOn(new Object[]{notation});
        }
        this.modJars.add(notation);
    }

    public void from(Object ... notation) {
        for (Object o : notation) {
            this.from(o);
        }
    }

    @Internal
    @NotNull
    public @NotNull List<@NotNull Path> getModPaths() {
        LinkedHashSet<@NotNull Path> out = new LinkedHashSet<Path>();
        for (Object modJar : this.modJars) {
            if (modJar instanceof SoftwareComponent) {
                for (UsageContext usageCtx : GradleInteropUtil.getUsageContexts((SoftwareComponent)modJar)) {
                    if (usageCtx == null) continue;
                    for (PublishArtifact artifact : usageCtx.getArtifacts()) {
                        if (artifact == null) continue;
                        out.add(artifact.getFile().toPath());
                    }
                }
                continue;
            }
            if (modJar instanceof PublishArtifact) {
                out.add(((PublishArtifact)modJar).getFile().toPath());
                continue;
            }
            if (modJar instanceof AbstractArchiveTask) {
                out.add(((RegularFile)((AbstractArchiveTask)modJar).getArchiveFile().get()).getAsFile().toPath());
                continue;
            }
            if (modJar instanceof Configuration) {
                for (File resolvedEntry : ((Configuration)modJar).resolve()) {
                    out.add(resolvedEntry.toPath());
                }
                continue;
            }
            out.add(super.getProject().file(modJar).toPath());
        }
        return new ArrayList<Path>(out);
    }

    @Internal
    public abstract Property<Boolean> getRemapMods();

    private void transform(@NotNull Path source, @NotNull Path target) {
        try {
            if (((Boolean)this.getRemapMods().get()).booleanValue()) {
                GslStarplanePlugin.OBF_HANDLERS.get(this.getProject()).deobfuscateJar(source, target);
            } else {
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to copy target " + target + " from " + source, (Throwable)e);
        }
    }
}

