/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.gslstarplane;

import de.geolykt.starloader.gslstarplane.GslDeployModsTask;
import de.geolykt.starloader.gslstarplane.GslExtension;
import de.geolykt.starloader.gslstarplane.GslGenEclipseRunsTask;
import de.geolykt.starloader.gslstarplane.GslRemapJarTask;
import de.geolykt.starloader.gslstarplane.GslRunModsTask;
import de.geolykt.starplane.Autodeobf;
import de.geolykt.starplane.JarStripper;
import de.geolykt.starplane.ObfuscationHandler;
import de.geolykt.starplane.sourcegen.EnhancedJarSaver;
import de.geolykt.starplane.sourcegen.FernflowerLoggerAdapter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.fabricmc.mappingio.format.MappingFormat;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.Container;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.json.JSONArray;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.slf4j.LoggerFactory;

public class GslStarplanePlugin
implements Plugin<Project> {
    public static final String TASK_GROUP = "GslStarplane";
    public static final String GALIM_DEPS_CONFIGURATION_NAME = "galimulatorDependencies";
    public static final String DEV_RUNTIME_CONFIGURATION_NAME = "devRuntime";
    static final WeakHashMap<Project, ObfuscationHandler> OBF_HANDLERS = new WeakHashMap();
    static final WeakHashMap<Project, JavaExec> RUN_TASKS = new WeakHashMap();

    public void apply(Project project) {
        project.getExtensions().create(GslExtension.class, "starplane", GslExtension.class, new Object[0]);
        project.afterEvaluate(GslStarplanePlugin::runDeobf);
        project.afterEvaluate(GslStarplanePlugin::setupEEA);
        project.getTasks().create("remapJar", GslRemapJarTask.class, task -> {
            task.setDescription("Remap deobfuscated jars to use obfuscated mappings.");
            task.setGroup(TASK_GROUP);
        });
        project.getConfigurations().register(DEV_RUNTIME_CONFIGURATION_NAME).configure(configuration -> {
            configuration.setVisible(false);
            configuration.setCanBeResolved(true);
            configuration.setDescription("Dependencies included in the development runtime.");
            SourceSetContainer sourceSets = (SourceSetContainer)Objects.requireNonNull(project.getProperties().get("sourceSets"));
            configuration.extendsFrom(new Configuration[]{project.getConfigurations().getByName(((SourceSet)sourceSets.getByName("main")).getRuntimeClasspathConfigurationName())});
        });
        project.getTasks().create("deployMods", GslDeployModsTask.class, task -> {
            task.setDescription("Deploy mods to the extension directory of the development environment.");
            task.setGroup(TASK_GROUP);
        });
        RUN_TASKS.put(project, (JavaExec)project.getTasks().create("runMods", GslRunModsTask.class));
        project.getTasks().create("genEclipseRuns", GslGenEclipseRunsTask.class, task -> {
            task.setDescription("Generate eclipse *.launch files");
            task.setGroup(TASK_GROUP);
        });
    }

    private static void setupEEA(Project project) {
        GslExtension extension = (GslExtension)project.getExtensions().getByType(GslExtension.class);
        if (extension.eclipseEEA == null) {
            return;
        }
        File eeaPath = project.file(extension.eclipseEEA);
        EclipseModel eclipseModel = (EclipseModel)project.getProperties().get("eclipse");
        if (eclipseModel == null) {
            LoggerFactory.getLogger(GslStarplanePlugin.class).error("Cannot setup EEA as the eclipse plugin is missing!");
            return;
        }
        eclipseModel.getClasspath().containers(new String[]{"org.eclipse.buildship.core.gradleclasspathcontainer"});
        eclipseModel.getClasspath().file(merger -> merger.whenMerged(object -> {
            Classpath classpath = (Classpath)object;
            for (ClasspathEntry entry : classpath.getEntries()) {
                Container container;
                if (!(entry instanceof Container) || !(container = (Container)entry).getPath().equals("org.eclipse.buildship.core.gradleclasspathcontainer")) continue;
                container.getEntryAttributes().putIfAbsent("annotationpath", eeaPath.getAbsolutePath().toString());
            }
        }));
    }

    private static void runDeobf(Project project) {
        if (OBF_HANDLERS.containsKey(project)) {
            return;
        }
        Path altCache = ((File)project.getLayout().getBuildDirectory().getAsFile().get()).toPath().resolve("gsl-starplane");
        GslExtension extension = (GslExtension)project.getExtensions().getByType(GslExtension.class);
        Set<Path> softmapFiles = new HashSet<Path>();
        for (Object object : extension.softmapMappings) {
            if (object instanceof Configuration) {
                for (File f : ((Configuration)object).resolve()) {
                    softmapFiles.add(f.toPath());
                }
                continue;
            }
            if (object instanceof Path) {
                softmapFiles.add((Path)object);
                continue;
            }
            softmapFiles.add(project.file(object).toPath());
        }
        ArrayList<Map.Entry<@NotNull MappingFormat, @NotNull Path>> supplementaryMappings = new ArrayList();
        for (Map.Entry<MappingFormat, Object> e : extension.mappings) {
            Object notation = e.getValue();
            if (notation instanceof Configuration) {
                for (File f : ((Configuration)notation).resolve()) {
                    supplementaryMappings.add(new AbstractMap.SimpleImmutableEntry<MappingFormat, Path>(e.getKey(), f.toPath()));
                }
                continue;
            }
            if (notation instanceof Path) {
                supplementaryMappings.add(new AbstractMap.SimpleImmutableEntry<MappingFormat, Path>(e.getKey(), (Path)notation));
                continue;
            }
            supplementaryMappings.add(new AbstractMap.SimpleImmutableEntry<MappingFormat, Path>(e.getKey(), project.file(notation).toPath()));
        }
        softmapFiles = Collections.unmodifiableSet(softmapFiles);
        supplementaryMappings = Collections.unmodifiableList(supplementaryMappings);
        ObfuscationHandler obfuscationHandler = new ObfuscationHandler(altCache, project.getProjectDir().toPath(), extension.getRASContents(project), softmapFiles, supplementaryMappings);
        OBF_HANDLERS.put(project, obfuscationHandler);
        GslStarplanePlugin.resolve(project, obfuscationHandler);
        JavaExec runTask = RUN_TASKS.get(project);
        if (runTask != null) {
            runTask.systemProperty("de.geolykt.starloader.launcher.CLILauncher.mainClass", (Object)"com.example.Main");
            Path modsDir = extension.modDirectory;
            if (modsDir == null) {
                modsDir = runTask.getWorkingDir().toPath().resolve("mods");
            }
            runTask.systemProperty("de.geolykt.starloader.launcher.IDELauncher.modDirectory", (Object)modsDir.toAbsolutePath().toString());
        }
    }

    static String getBootPath(Project p) {
        JSONArray bootPath = new JSONArray();
        try {
            bootPath.put((Object)OBF_HANDLERS.get(p).getTransformedGalimulatorJar().toAbsolutePath().resolveSibling("galimulator-remapped-rt.jar").toUri().toURL().toExternalForm());
            for (File f : p.getConfigurations().getByName(GALIM_DEPS_CONFIGURATION_NAME).resolve()) {
                bootPath.put((Object)f.toURI().toURL().toExternalForm());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return "-Dde.geolykt.starloader.launcher.IDELauncher.bootURLs=" + bootPath.toString();
    }

    public static void resolve(Project project, ObfuscationHandler obfHandler) {
        Set<JarStripper.MavenId> deps;
        Path compileLarge = obfHandler.getTransformedGalimulatorJar();
        Path compileStripped = compileLarge.resolveSibling("galimulator-remapped-stripped-" + Autodeobf.getVersion() + ".jar");
        Path compileStrippedSource = compileLarge.resolveSibling("galimulator-remapped-stripped-" + Autodeobf.getVersion() + "-sources.jar");
        Path runtimeLarge = compileLarge.resolveSibling("galimulator-remapped-rt.jar");
        JarStripper stripper = new JarStripper();
        NamedDomainObjectProvider galimDepsConfig = null;
        try {
            galimDepsConfig = project.getConfigurations().named(GALIM_DEPS_CONFIGURATION_NAME);
        }
        catch (UnknownDomainObjectException e) {
            galimDepsConfig = project.getConfigurations().register(GALIM_DEPS_CONFIGURATION_NAME);
        }
        try (InputStream is = Files.newInputStream(compileLarge, new OpenOption[0]);){
            deps = stripper.getShadedDependencies(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (JarStripper.MavenId dep : deps) {
            project.getDependencies().add(GALIM_DEPS_CONFIGURATION_NAME, (Object)dep.toGAVNotation());
        }
        Set transitiveDeps = ((Configuration)galimDepsConfig.get()).resolve();
        if (obfHandler.didRefresh || Files.notExists(compileStripped, new LinkOption[0])) {
            try {
                HashSet<String> removePaths = new HashSet<String>();
                removePaths.remove("META-INF/MANIFEST.MF");
                for (File transitiveDep : transitiveDeps) {
                    try (ZipInputStream zipIn = new ZipInputStream(Files.newInputStream(transitiveDep.toPath(), new OpenOption[0]));){
                        ZipEntry entry = zipIn.getNextEntry();
                        while (entry != null) {
                            String name = entry.getName();
                            if (name.codePointAt(0) == 47) {
                                name = name.substring(0);
                            }
                            removePaths.add(name);
                            entry = zipIn.getNextEntry();
                        }
                    }
                }
                stripper.createStrippedJar(compileLarge, compileStripped, removePaths);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (obfHandler.didRefresh || Files.notExists(compileStrippedSource, new LinkOption[0]) && !Boolean.getBoolean("org.stianloader.starplane.skipDecompile")) {
            try {
                GslStarplanePlugin.decompile(project, runtimeLarge, compileStripped, compileStrippedSource, transitiveDeps);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        project.getRepositories().flatDir(repo -> {
            repo.dir((Object)compileLarge.getParent());
            repo.setName("generated-galimulator-remapped");
        });
        project.getDependencies().add("compileOnly", (Object)(":galimulator-remapped-stripped:" + Autodeobf.getVersion()));
        obfHandler.didRefresh = false;
    }

    private static void decompile(Project project, @NotNull Path runtimeLarge, @NotNull Path compileStripped, @NotNull Path compileStrippedSource, Set<File> transitiveDeps) throws IOException {
        project.getLogger().info("Decompiling galimulator");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("indent-string", "    ");
        args.put("decompile-generics", "1");
        args.put("include-classpath", "1");
        args.put("log-level", "WARN");
        args.put("verify-anonymous-classes", "1");
        args.put("bytecode-source-mapping", "1");
        args.put("dump-code-lines", "1");
        args.put("__dump_original_lines__", "1");
        args.put("remove-synthetic", "0");
        HashMap<String, int[]> lineMappings = new HashMap<String, int[]>();
        try (EnhancedJarSaver jarSaver = new EnhancedJarSaver(compileStrippedSource.toFile(), lineMappings);){
            Fernflower qf = new Fernflower((IResultSaver)jarSaver, args, (IFernflowerLogger)new FernflowerLoggerAdapter(IFernflowerLogger.Severity.WARN));
            qf.addSource(compileStripped.toFile());
            for (File transitiveDep : transitiveDeps) {
                qf.addLibrary(transitiveDep);
            }
            qf.decompileContext();
        }
        project.getLogger().info("Galimulator decompiled");
        project.getLogger().info("Replacing line mappings");
        GslStarplanePlugin.replaceLineNumbers(compileStripped, lineMappings);
        GslStarplanePlugin.replaceLineNumbers(runtimeLarge, lineMappings);
        project.getLogger().info("Line mappings replaced");
    }

    private static void replaceLineNumbers(@NotNull Path lineReplaceTarget, Map<String, int[]> lineMappings) throws IOException {
        LinkedHashMap<String, ClassNode> nameToNode = new LinkedHashMap<String, ClassNode>();
        try (ZipInputStream zipIn = new ZipInputStream(Files.newInputStream(lineReplaceTarget, new OpenOption[0]), StandardCharsets.UTF_8);){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                if (entry.getName().endsWith(".class")) {
                    ClassNode node = new ClassNode();
                    ClassReader reader = new ClassReader((InputStream)zipIn);
                    reader.accept((ClassVisitor)node, 5);
                    nameToNode.put(node.name, node);
                }
                entry = zipIn.getNextEntry();
            }
        }
        Path intermediary = Files.createTempFile("gcmcstarplane-linereplane-" + ThreadLocalRandom.current().nextInt(), ".jar", new FileAttribute[0]);
        try (ZipInputStream zipIn = new ZipInputStream(Files.newInputStream(lineReplaceTarget, new OpenOption[0]), StandardCharsets.UTF_8);
             ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(intermediary, new OpenOption[0]), StandardCharsets.UTF_8);){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                zipOutputStream.putNextEntry(new ZipEntry(entry.getName()));
                if (!entry.getName().endsWith(".class")) {
                    byte[] buffer = new byte[4096];
                    int read = zipIn.read(buffer);
                    while (read != -1) {
                        zipOutputStream.write(buffer, 0, read);
                        read = zipIn.read(buffer);
                    }
                } else {
                    HashMap<Integer, Integer> lineNumberConversion;
                    int[] mapping;
                    ClassNode node;
                    ClassReader reader = new ClassReader((InputStream)zipIn);
                    ClassNode outermostClassnode = node = (ClassNode)nameToNode.get(reader.getClassName());
                    block18: while (true) {
                        if (outermostClassnode.outerClass != null) {
                            outermostClassnode = (ClassNode)nameToNode.get(outermostClassnode.outerClass);
                            continue;
                        }
                        for (InnerClassNode icn : outermostClassnode.innerClasses) {
                            if (!icn.name.equals(outermostClassnode.name) || icn.outerName == null) continue;
                            outermostClassnode = (ClassNode)nameToNode.get(icn.outerName);
                            continue block18;
                        }
                        break;
                    }
                    if (node.sourceFile == null || node.sourceFile.equals("SourceFile")) {
                        int startName = outermostClassnode.name.lastIndexOf(47) + 1;
                        int innerSeperator = outermostClassnode.name.indexOf(36);
                        String baseName = innerSeperator == -1 ? outermostClassnode.name.substring(startName) : outermostClassnode.name.substring(startName, innerSeperator);
                        node.sourceFile = baseName + ".java";
                    }
                    if ((mapping = lineMappings.get(outermostClassnode.name)) == null) {
                        lineNumberConversion = null;
                    } else {
                        lineNumberConversion = new HashMap<Integer, Integer>();
                        int i = 0;
                        while (i < mapping.length) {
                            lineNumberConversion.put(mapping[i++], mapping[i++]);
                        }
                    }
                    ClassWriter writer = new ClassWriter(reader, 0);
                    reader.accept(new ClassVisitor(589824, (ClassVisitor)writer){

                        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                            return new MethodVisitor(this.api, super.visitMethod(access, name, descriptor, signature, exceptions)){

                                public void visitLineNumber(int line, Label start) {
                                    if (lineNumberConversion == null) {
                                        super.visitLineNumber(line, start);
                                    } else {
                                        Integer newLineNumber = (Integer)lineNumberConversion.get(line);
                                        if (newLineNumber == null) {
                                            super.visitLineNumber(line, start);
                                        } else {
                                            super.visitLineNumber(newLineNumber.intValue(), start);
                                        }
                                    }
                                }
                            };
                        }

                        public void visitSource(String source, String debug) {
                            super.visitSource(node.sourceFile, debug);
                        }
                    }, 0);
                    zipOutputStream.write(writer.toByteArray());
                }
                entry = zipIn.getNextEntry();
            }
        }
        Files.move(intermediary, lineReplaceTarget, StandardCopyOption.REPLACE_EXISTING);
        nameToNode.clear();
    }
}

