/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starplane.remapping;

import de.geolykt.starplane.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import net.fabricmc.tinyremapper.IMappingProvider;
import org.jetbrains.annotations.NotNull;

public class StarplaneMappingsProvider
implements IMappingProvider {
    @NotNull
    private final Path map;
    private final boolean reverse;
    private final boolean ignoreNonExistentFiles;

    public StarplaneMappingsProvider(@NotNull Path map, boolean reversed) {
        this(map, reversed, false);
    }

    public StarplaneMappingsProvider(@NotNull Path map, boolean reversed, boolean ignoreNonExistentFiles) {
        this.map = map;
        this.reverse = reversed;
        this.ignoreNonExistentFiles = ignoreNonExistentFiles;
    }

    public void load(IMappingProvider.MappingAcceptor out) {
        if (this.ignoreNonExistentFiles && Files.notExists(this.map, new LinkOption[0])) {
            return;
        }
        int lineNr = 0;
        try (BufferedReader br = Files.newBufferedReader(this.map, StandardCharsets.UTF_8);){
            String header = br.readLine();
            ++lineNr;
            if (header == null || Utils.isBlank(header)) {
                br.close();
                throw new IOException("No tiny header present (empty file?).");
            }
            String[] headerTokens = header.split("\\s+");
            if (headerTokens.length != 3) {
                br.close();
                throw new IOException("The tiny header had " + headerTokens.length + " tokens, however it is expected to be exactly 3.");
            }
            if (!headerTokens[0].equals("v1")) {
                br.close();
                throw new IOException("This method can only read tiny v1 maps.");
            }
            String line = br.readLine();
            while (line != null) {
                ++lineNr;
                if (line.charAt(0) != '#' && (line = line.split("#", 2)[0]) != null && !Utils.isBlank(line)) {
                    String[] colums = line.split("\\s+");
                    String type = colums[0].toUpperCase(Locale.ROOT);
                    if (type.equals("CLASS")) {
                        if (colums.length != 3) {
                            throw new IOException("Line " + lineNr + " is of type CLASS, but only " + colums.length + " colums are present, even though it expects 3.");
                        }
                        if (this.reverse) {
                            out.acceptClass(colums[2], colums[1]);
                        } else {
                            out.acceptClass(colums[1], colums[2]);
                        }
                    } else if (type.equals("METHOD")) {
                        if (colums.length != 5) {
                            throw new IOException("Line " + lineNr + " is of type CLASS, but only " + colums.length + " colums are present, even though it expects 5.");
                        }
                        if (this.reverse) {
                            out.acceptMethod(new IMappingProvider.Member(colums[1], colums[4], colums[2]), colums[3]);
                        } else {
                            out.acceptMethod(new IMappingProvider.Member(colums[1], colums[3], colums[2]), colums[4]);
                        }
                    } else if (type.equals("FIELD")) {
                        if (colums.length != 5) {
                            throw new IOException("Line " + lineNr + " is of type CLASS, but only " + colums.length + " colums are present, even though it expects 5.");
                        }
                        if (this.reverse) {
                            out.acceptField(new IMappingProvider.Member(colums[1], colums[4], colums[2]), colums[3]);
                        } else {
                            out.acceptField(new IMappingProvider.Member(colums[1], colums[3], colums[2]), colums[4]);
                        }
                    }
                }
                line = br.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read mappings!", e);
        }
    }
}

