/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starplane.remapping;

import de.geolykt.starloader.deobf.remapper.Remapper;
import de.geolykt.starplane.remapping.HashableMember;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.tinyremapper.IMappingProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultiMappingContainer
implements IMappingProvider.MappingAcceptor,
IMappingProvider {
    final Map<String, String> classes = new HashMap<String, String>();
    final Map<HashableMember, String> fields = new HashMap<HashableMember, String>();
    final Map<HashableMember, String> methods = new HashMap<HashableMember, String>();
    private final Map<String, String> unappliedClasses = new HashMap<String, String>();
    private final Map<HashableMember, String> unappliedFields = new HashMap<HashableMember, String>();
    private final Map<HashableMember, String> unappliedMethods = new HashMap<HashableMember, String>();

    MultiMappingContainer() {
    }

    public void acceptClass(String srcName, String dstName) {
        this.unappliedClasses.put(srcName, dstName);
    }

    public void acceptField(IMappingProvider.Member field, String dstName) {
        this.unappliedFields.put(new HashableMember(field), dstName);
    }

    public void acceptMethod(IMappingProvider.Member method, String dstName) {
        this.unappliedMethods.put(new HashableMember(method), dstName);
    }

    public void acceptMethodArg(IMappingProvider.Member method, int lvIndex, String dstName) {
    }

    public void acceptMethodVar(IMappingProvider.Member method, int lvIndex, int startOpIdx, int asmIndex, String dstName) {
    }

    public void apply() {
        if (this.classes.isEmpty() && this.methods.isEmpty() && this.fields.isEmpty()) {
            this.classes.putAll(this.unappliedClasses);
            this.methods.putAll(this.unappliedMethods);
            this.fields.putAll(this.unappliedFields);
            this.unappliedClasses.clear();
            this.unappliedMethods.clear();
            this.unappliedFields.clear();
            return;
        }
        Remapper remapper = new Remapper();
        remapper.remapClassNames(this.classes);
        this.unappliedClasses.forEach((src, dst) -> {
            String old = this.classes.remove(dst);
            if (old != null) {
                this.classes.put((String)src, old);
            } else {
                this.classes.put((String)src, (String)dst);
            }
        });
        StringBuilder sharedBuilder = new StringBuilder();
        this.unappliedFields.forEach((field, name) -> {
            String originalOwner = remapper.getRemappedClassName(field.member.owner);
            String originalDesc = remapper.getRemappedFieldDescriptor(field.member.desc, sharedBuilder);
            String old = this.fields.remove(new HashableMember(new IMappingProvider.Member(originalOwner, field.member.name, originalDesc)));
            HashableMember hashableMember = new HashableMember(new IMappingProvider.Member(originalOwner, field.member.name, originalDesc));
            if (old == null) {
                this.fields.put(hashableMember, (String)name);
            } else {
                this.fields.put(hashableMember, old);
            }
        });
        this.unappliedMethods.forEach((method, name) -> {
            String originalOwner = remapper.getRemappedClassName(method.member.owner);
            String originalDesc = remapper.getRemappedMethodDescriptor(method.member.desc, sharedBuilder);
            String old = this.methods.remove(new HashableMember(new IMappingProvider.Member(originalOwner, name, originalDesc)));
            HashableMember hashableMember = new HashableMember(new IMappingProvider.Member(originalOwner, method.member.name, originalDesc));
            if (old == null) {
                this.methods.put(hashableMember, (String)name);
            } else {
                this.methods.put(hashableMember, old);
            }
        });
        this.unappliedClasses.clear();
        this.unappliedMethods.clear();
        this.unappliedFields.clear();
    }

    public void load(IMappingProvider.MappingAcceptor out) {
        if (!this.unappliedClasses.isEmpty()) {
            throw new IllegalStateException("Called #load while there are still unapplied changes! Consider calling #apply beforehand");
        }
        Remapper reverser = new Remapper();
        this.classes.forEach((src, dest) -> {
            reverser.remapClassName(dest, src);
            out.acceptClass(src, dest);
        });
        StringBuilder sharedBuilder = new StringBuilder();
        this.fields.forEach((field, name) -> {
            String deobfDesc = reverser.getRemappedFieldDescriptor(field.member.desc, sharedBuilder);
            String deobfOwner = reverser.getRemappedClassName(field.member.owner);
            IMappingProvider.Member deobfMember = new IMappingProvider.Member(deobfOwner, field.member.name, deobfDesc);
            out.acceptField(deobfMember, name);
        });
        this.methods.forEach((method, name) -> {
            String deobfDesc = reverser.getRemappedMethodDescriptor(method.member.desc, sharedBuilder);
            String deobfOwner = reverser.getRemappedClassName(method.member.owner);
            IMappingProvider.Member deobfMember = new IMappingProvider.Member(deobfOwner, method.member.name, deobfDesc);
            out.acceptMethod(deobfMember, name);
        });
    }

    @NotNull
    String stringifyMember(@Nullable IMappingProvider.Member member) {
        if (member == null) {
            return "null";
        }
        return member.owner + "." + member.name + " " + member.desc;
    }
}

