/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starloader.gslstarplane;

import de.geolykt.starloader.gslstarplane.GslStarplanePlugin;
import de.geolykt.starplane.ObfuscationHandler;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisableCachingByDefault(because="Not worth caching")
public class GslRemapJarTask
extends Jar {
    private static final Logger LOGGER = LoggerFactory.getLogger(GslRemapJarTask.class);
    private final Set<Object> fromJars = new HashSet<Object>();

    public void fromJar(Object ... notations) {
        for (Object notation : notations) {
            if (notation instanceof Task) {
                super.dependsOn(new Object[]{notation});
            }
            this.fromJars.add(notation);
        }
    }

    protected CopyAction createCopyAction() {
        return caps -> {
            WorkResult result = super.createCopyAction().execute(caps);
            if (!result.getDidWork()) {
                return result;
            }
            ObfuscationHandler oHandler = GslStarplanePlugin.OBF_HANDLERS.get(super.getProject());
            if (oHandler == null) {
                LOGGER.error("Obfuscation handler not set for this project: " + super.getProject().getName());
                return WorkResults.didWork((boolean)false);
            }
            HashSet<@NotNull Path> includes = new HashSet<Path>();
            for (Object fromJar : this.fromJars) {
                if (fromJar instanceof Task) {
                    FileCollection taskOutputs = ((Task)fromJar).getOutputs().getFiles();
                    taskOutputs.forEach(f -> includes.add(f.toPath()));
                    continue;
                }
                includes.add(super.getProject().file(fromJar).toPath());
            }
            try {
                LOGGER.info("Remapping");
                oHandler.reobfuscateJar(((RegularFile)super.getArchiveFile().get()).getAsFile().toPath(), oHandler.getTransformedGalimulatorJar(), includes);
                LOGGER.info("Remap complete");
            }
            catch (IOException e) {
                LOGGER.error("Unable to remap", (Throwable)e);
                return WorkResults.didWork((boolean)false);
            }
            return WorkResults.didWork((boolean)true);
        };
    }
}

