/*
 * Decompiled with CFR 0.152.
 */
package de.geolykt.starplane.remapping;

import de.geolykt.starloader.deobf.DescString;
import de.geolykt.starplane.remapping.CommentLookup;
import net.fabricmc.mappingio.tree.MappingTreeView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stianloader.remapper.MappingLookup;
import org.stianloader.remapper.MappingSink;
import org.stianloader.remapper.MemberRef;

public class ReadOnlyMIOMappingLookup
implements MappingLookup,
MappingSink,
CommentLookup {
    private final int dstNamespace;
    @NotNull
    private final MappingTreeView mappingIOTree;
    private final int srcNamespace;

    public ReadOnlyMIOMappingLookup(@NotNull MappingTreeView mappingIOTree, int srcNamespace, int dstNamespace) {
        this.mappingIOTree = mappingIOTree;
        this.srcNamespace = srcNamespace;
        this.dstNamespace = dstNamespace;
        if (this.srcNamespace == this.dstNamespace) {
            throw new IllegalArgumentException("srcNamespace == dstNamespace: " + srcNamespace + ", " + dstNamespace);
        }
    }

    @Override
    @Nullable
    public String getClassComment(@NotNull String className) {
        MappingTreeView.ClassMappingView cmv = this.mappingIOTree.getClass(className, this.srcNamespace);
        return cmv == null ? null : cmv.getComment();
    }

    @Override
    @Nullable
    public String getFieldComment(@NotNull String srcOwner, @NotNull String srcName, @NotNull String srcDesc) {
        MappingTreeView.FieldMappingView fmv = this.mappingIOTree.getField(srcOwner, srcName, srcDesc, this.srcNamespace);
        return fmv == null ? null : fmv.getComment();
    }

    @Override
    @Nullable
    public String getMethodComment(@NotNull String srcOwner, @NotNull String srcName, @NotNull String srcDesc) {
        MappingTreeView.MethodMappingView mmv = this.mappingIOTree.getMethod(srcOwner, srcName, srcDesc, this.srcNamespace);
        return mmv == null ? null : mmv.getComment();
    }

    @NotNull
    public String getRemappedClassName(@NotNull String srcName) {
        String dst = this.getRemappedClassNameFast(srcName);
        return dst == null ? srcName : dst;
    }

    @Nullable
    public String getRemappedClassNameFast(@NotNull String srcName) {
        MappingTreeView.ClassMappingView cmv = this.mappingIOTree.getClass(srcName, this.srcNamespace);
        if (cmv != null) {
            return cmv.getName(this.dstNamespace);
        }
        return null;
    }

    @NotNull
    public String getRemappedFieldName(@NotNull String srcOwner, @NotNull String srcName, @NotNull String srcDesc) {
        MappingTreeView.FieldMappingView fmv = this.mappingIOTree.getField(srcOwner, srcName, srcDesc, this.srcNamespace);
        if (fmv == null) {
            return srcName;
        }
        String dst = fmv.getName(this.dstNamespace);
        return dst == null ? srcName : dst;
    }

    @NotNull
    public String getRemappedMethodName(@NotNull String srcOwner, @NotNull String srcName, @NotNull String srcDesc) {
        MappingTreeView.MethodMappingView mmv = this.mappingIOTree.getMethod(srcOwner, srcName, srcDesc, this.srcNamespace);
        if (mmv == null) {
            return srcName;
        }
        String dst = mmv.getName(this.dstNamespace);
        return dst == null ? srcName : dst;
    }

    @Nullable
    public String getRemappedParameterName(@NotNull String srcOwner, @NotNull String srcName, @NotNull String srcDesc, int paramIndex, boolean isStatic) {
        MappingTreeView.MethodMappingView mmv = this.mappingIOTree.getMethod(srcOwner, srcName, srcDesc, this.srcNamespace);
        if (mmv == null) {
            return null;
        }
        int lvIndex = -1;
        for (MappingTreeView.MethodArgMappingView arg : mmv.getArgs()) {
            assert (arg != null);
            int argPos = arg.getArgPosition();
            if (argPos < 0) {
                if (lvIndex < 0) {
                    lvIndex = isStatic ? 0 : 1;
                    int i = paramIndex;
                    DescString dString = new DescString(srcDesc);
                    while (i-- != 0 && dString.hasNext()) {
                        String type = dString.nextType();
                        if (type.equals("J") || type.equals("D")) {
                            lvIndex += 2;
                            continue;
                        }
                        ++lvIndex;
                    }
                }
                if (lvIndex != arg.getLvIndex()) continue;
                return arg.getName(this.dstNamespace);
            }
            if (argPos != paramIndex) continue;
            return arg.getName(this.dstNamespace);
        }
        return null;
    }

    @NotNull
    public ReadOnlyMIOMappingLookup remapClass(@NotNull String srcName, @NotNull String dstName) {
        throw new UnsupportedOperationException("Due to the complexities involved in the mapping process, this instance is read-only and only implements MappingSink for technical reasons");
    }

    @NotNull
    public ReadOnlyMIOMappingLookup remapMember(@NotNull MemberRef srcRef, @NotNull String dstName) {
        throw new UnsupportedOperationException("Due to the complexities involved in the mapping process, this instance is read-only and only implements MappingSink for technical reasons");
    }

    @NotNull
    public MappingSink remapParameter(@NotNull String srcOwner, @NotNull String srcMethodName, @NotNull String srcDesc, int paramIndex, @NotNull String destParamName) {
        throw new UnsupportedOperationException("Due to the complexities involved in the mapping process, this instance is read-only and only implements MappingSink for technical reasons");
    }
}

