/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.sml6.starplane.remapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeAnnotationNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stianloader.remapper.MappingLookup;
import org.stianloader.remapper.MemberRef;
import org.stianloader.remapper.Remapper;

public class StarplaneAnnotationRemapper {
    @NotNull
    private static final String INLINED_REFERENCE_SOURCE_MARKER_ANNOTATION = "Lorg/stianloader/starplane/annotations/InlinedReferenceSourceMarker;";
    private static final Logger LOGGER = LoggerFactory.getLogger(StarplaneAnnotationRemapper.class);

    /*
     * Unable to fully structure code
     */
    public static void apply(@NotNull ClassNode node, @NotNull Remapper remapper, @NotNull StringBuilder sharedBuilder) {
        clinitMethod = null;
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<clinit>")) continue;
            clinitMethod = method;
            break;
        }
        memberMapRequests = new HashMap<MemberRef, MemberRef>();
        memberMapFormat = new HashMap<MemberRef, String>();
        classMapRequests = new HashMap<MemberRef, String>();
        block1: for (FieldNode field : node.fields) {
            annotations = field.invisibleAnnotations;
            if (annotations == null) continue;
            for (Object annotation : annotations) {
                if (annotation.desc.equals("Lde/geolykt/starloader/starplane/annotations/StarplaneReobfuscateReference;")) {
                    if (clinitMethod == null) {
                        throw new IllegalStateException("Illegal bytecode: " + node.name + "." + field.name + " " + field.desc + ": No clinit found");
                    }
                    for (AbstractInsnNode insn : clinitMethod.instructions) {
                        if (insn.getOpcode() != 179) continue;
                        fieldInsn = (FieldInsnNode)insn;
                        if (!fieldInsn.desc.equals("Ljava/lang/String;") || !field.name.equals(fieldInsn.name)) continue;
                        ldc = (LdcInsnNode)fieldInsn.getPrevious();
                        oldValue = ldc.cst.toString();
                        if (oldValue == null) {
                            throw new InternalError();
                        }
                        ldc.cst = StarplaneAnnotationRemapper.remapReference(remapper, oldValue, sharedBuilder);
                    }
                    continue block1;
                }
                if (annotation.desc.equals("Lde/geolykt/starloader/starplane/annotations/RemapClassReference;")) {
                    if (annotation.values == null || annotation.values.size() == 0) {
                        StarplaneAnnotationRemapper.LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapClassReference, but neither the 'name' nor the 'type' value of the annotation is set.", new Object[]{node.name, field.name, field.desc});
                        continue block1;
                    }
                    if (annotation.values.size() == 4) {
                        StarplaneAnnotationRemapper.LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapClassReference, but both the 'name' and the 'type' value of the annotation is set. Consider only setting one of these values.", new Object[]{node.name, field.name, field.desc});
                        continue block1;
                    }
                    if (annotation.values.get(0).equals("name")) {
                        typeName = ((String)annotation.values.get(1)).replace('.', '/');
                        annotation.values.set(1, Remapper.remapInternalName((MappingLookup)remapper.getLookup(), (String)typeName, (StringBuilder)sharedBuilder));
                    } else if (annotation.values.get(0).equals("type")) {
                        typeName = ((Type)annotation.values.get(1)).getInternalName();
                    } else {
                        StarplaneAnnotationRemapper.LOGGER.error("Erroneous annotation key: " + String.valueOf(annotation.values.get(0)) + " for RemapClassReference. Are you depending on the wrong starplane-annotations version?");
                        continue block1;
                    }
                    classMapRequests.put(new MemberRef(node.name, field.name, field.desc), typeName);
                    continue;
                }
                if (!annotation.desc.equals("Lde/geolykt/starloader/starplane/annotations/RemapMemberReference;")) continue;
                if (annotation.values == null) {
                    StarplaneAnnotationRemapper.LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapMemberReference, but does not define any of the required values.", new Object[]{node.name, field.name, field.desc});
                    continue block1;
                }
                if (annotation.values.size() >= 10) {
                    StarplaneAnnotationRemapper.LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapMemberReference, but more than the required values of the annotation is set. Consider removing duplicates.", new Object[]{node.name, field.name, field.desc});
                    continue block1;
                }
                typeName = null;
                memberName = null;
                memberDesc = null;
                format = null;
                ordinalTypeName = 0;
                ordinalMemberName = 0;
                ordinalMemberDesc = 0;
                for (i = 0; i < annotation.values.size(); i += 2) {
                    valueName = (String)annotation.values.get(i);
                    if (valueName.equals("ownerType")) {
                        typeName = ((Type)annotation.values.get(i + 1)).getInternalName();
                        continue;
                    }
                    if (valueName.equals("owner")) {
                        typeName = ((String)annotation.values.get(i + 1)).replace('.', '/');
                        ordinalTypeName = i + 1;
                        continue;
                    }
                    if (valueName.equals("name")) {
                        memberName = (String)annotation.values.get(i + 1);
                        ordinalMemberName = i + 1;
                        continue;
                    }
                    if (valueName.equals("desc")) {
                        if (memberDesc != null) {
                            StarplaneAnnotationRemapper.LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapMemberReference, but multiple values contain descriptor-giving values. Consider removing duplicated.", new Object[]{node.name, field.name, field.desc});
                            break;
                        }
                        memberDesc = (String)annotation.values.get(i + 1);
                        ordinalMemberDesc = i + 1;
                        continue;
                    }
                    if (valueName.equals("descType")) {
                        if (memberDesc != null) {
                            StarplaneAnnotationRemapper.LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapMemberReference, but multiple values contain descriptor-giving values. Consider removing duplicated.", new Object[]{node.name, field.name, field.desc});
                            break;
                        }
                        memberDesc = ((Type)annotation.values.get(i + 1)).getDescriptor();
                        continue;
                    }
                    if (valueName.equals("methodDesc")) {
                        methodDesc = (AnnotationNode)annotation.values.get(i + 1);
                        if (methodDesc.values.get(0).equals("args")) {
                            args = 1;
                            ret = 3;
                        } else {
                            ret = 1;
                            args = 3;
                        }
                        argDesc = "";
                        arglist = (List)methodDesc.values.get(args);
                        for (j = 0; j < arglist.size(); ++j) {
                            arg = (Type)arglist.get(j);
                            if (arg == null) {
                                throw new AssertionError();
                            }
                            argDesc = (String)argDesc + arg.getDescriptor();
                        }
                        if (memberDesc != null) {
                            StarplaneAnnotationRemapper.LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapMemberReference, but multiple values contain descriptor-giving values. Consider removing duplicated.", new Object[]{node.name, field.name, field.desc});
                            break;
                        }
                        memberDesc = "(" + (String)argDesc + ")" + ((Type)methodDesc.values.get(ret)).getDescriptor();
                        continue;
                    }
                    if (valueName.equals("format")) {
                        format = ((String[])annotation.values.get(i + 1))[1];
                        continue;
                    }
                    StarplaneAnnotationRemapper.LOGGER.error("Erroneous annotation value: {} for RemapMemberReference. Are you depending on the wrong starplane-annotations version?", (Object)valueName);
                    break;
                }
                if (typeName == null) {
                    StarplaneAnnotationRemapper.LOGGER.error("Field {}.{}:{} is annotated with de/geolykt/starloader/starplane/annotations/RemapMemberReference, but neither the 'owner' nor the 'ownerType' value of the annotation is set. Consider setting one of these values.", new Object[]{node.name, field.name, field.desc});
                    continue block1;
                }
                targetTriple = new MemberRef(typeName, (String)Objects.requireNonNull(memberName, "memberName == null"), (String)Objects.requireNonNull(memberDesc, "memberDesc == null"));
                fieldTriple = new MemberRef(node.name, field.name, field.desc);
                memberMapFormat.put(fieldTriple, format);
                memberMapRequests.put(fieldTriple, targetTriple);
                if (ordinalTypeName != 0) {
                    annotation.values.set(ordinalTypeName, remapper.getLookup().getRemappedClassName(typeName));
                }
                if (ordinalMemberName != 0) {
                    if (memberDesc.codePointAt(0) == 40) {
                        annotation.values.set(ordinalMemberName, remapper.getLookup().getRemappedMethodName(typeName, memberName, (String)memberDesc));
                    } else {
                        annotation.values.set(ordinalMemberName, remapper.getLookup().getRemappedFieldName(typeName, memberName, (String)memberDesc));
                    }
                }
                if (ordinalMemberDesc == 0) continue;
                if (memberDesc.codePointAt(0) == 40) {
                    annotation.values.set(ordinalMemberDesc, Remapper.getRemappedMethodDescriptor((MappingLookup)remapper.getLookup(), (String)memberDesc, (StringBuilder)sharedBuilder));
                    continue;
                }
                annotation.values.set(ordinalMemberDesc, Remapper.getRemappedFieldDescriptor((MappingLookup)remapper.getLookup(), (String)memberDesc, (StringBuilder)sharedBuilder));
            }
        }
        block6: for (MethodNode method : node.methods) {
            block7: for (insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                block57: {
                    if (insn.getOpcode() != 184) break block57;
                    minsn = (MethodInsnNode)insn;
                    if (!(minsn.owner.equals("de/geolykt/starloader/starplane/annotations/ReferenceSource") && minsn.name.equals("getStringValue") && minsn.desc.equals("()Ljava/lang/String;"))) {
                        continue;
                    }
                    ** GOTO lbl152
                }
                if (insn.getOpcode() != 18 || (insnAnnots = insn.invisibleTypeAnnotations) == null || insnAnnots.isEmpty()) continue;
                for (TypeAnnotationNode insnAnnot : insnAnnots) {
                    if (!insnAnnot.desc.equals("Lorg/stianloader/starplane/annotations/InlinedReferenceSourceMarker;")) continue;
lbl152:
                    // 3 sources

                    for (nextInsn = insn.getNext(); nextInsn != null && (nextInsn.getOpcode() == -1 || nextInsn.getOpcode() == 25); nextInsn = nextInsn.getNext()) {
                    }
                    if (nextInsn == null) {
                        StarplaneAnnotationRemapper.LOGGER.error("Method {}.{} {} contains a rouge ReferenceSource.getStringValue() call.", new Object[]{node.name, method.name, method.desc});
                        continue block6;
                    }
                    if (nextInsn.getOpcode() != 179 && nextInsn.getOpcode() != 181) {
                        StarplaneAnnotationRemapper.LOGGER.error("Method {}.{} {} contains a call to ReferenceSource.getStringValue() that is not immediately assigned to a field.", new Object[]{node.name, method.name, method.desc});
                        continue block7;
                    }
                    assignmentTriple = new MemberRef(((FieldInsnNode)nextInsn).owner, ((FieldInsnNode)nextInsn).name, ((FieldInsnNode)nextInsn).desc);
                    cl = (String)classMapRequests.get(assignmentTriple);
                    if (cl != null) {
                        replacementLdc = Remapper.remapInternalName((MappingLookup)remapper.getLookup(), (String)cl, (StringBuilder)sharedBuilder);
                    } else {
                        member = (MemberRef)memberMapRequests.get(assignmentTriple);
                        format = (String)memberMapFormat.get(assignmentTriple);
                        if (member == null || format == null) {
                            StarplaneAnnotationRemapper.LOGGER.error("Method {}.{} {} contains a call to ReferenceSource.getStringValue() that is assigned to {}.{} {} which is not annotated with a starplane remapping annotation. (Note: this feature does not work across classes!)", new Object[]{node.name, method.name, method.desc, assignmentTriple.getOwner(), assignmentTriple.getName(), assignmentTriple.getDesc()});
                            continue block7;
                        }
                        remappedOwner = Remapper.remapInternalName((MappingLookup)remapper.getLookup(), (String)member.getOwner(), (StringBuilder)sharedBuilder);
                        if (member.getDesc().codePointAt(0) == 40) {
                            remappedName = remapper.getLookup().getRemappedMethodName(member.getOwner(), member.getName(), member.getDesc());
                            remappedDesc = Remapper.getRemappedMethodDescriptor((MappingLookup)remapper.getLookup(), (String)member.getDesc(), (StringBuilder)sharedBuilder);
                            isMethod = true;
                        } else {
                            remappedName = remapper.getLookup().getRemappedFieldName(member.getOwner(), member.getName(), member.getDesc());
                            remappedDesc = Remapper.getRemappedFieldDescriptor((MappingLookup)remapper.getLookup(), (String)member.getDesc(), (StringBuilder)sharedBuilder);
                            isMethod = false;
                        }
                        if (format.equals("OWNER")) {
                            replacementLdc = remappedOwner;
                        } else if (format.equals("NAME")) {
                            replacementLdc = remappedName;
                        } else if (format.equals("DESCRIPTOR")) {
                            replacementLdc = remappedDesc;
                        } else if (format.equals("COMBINED_LEGACY")) {
                            replacementLdc = isMethod ? remappedOwner + "." + remappedName + remappedDesc : remappedOwner + "." + remappedName + " " + remappedDesc;
                        } else {
                            StarplaneAnnotationRemapper.LOGGER.error("Method {}.{} {} contains a call to ReferenceSource.getStringValue() that is assigned to {}.{} {} which uses an unsupported format. (Are you using the right version of starplane-annotations?)", new Object[]{node.name, method.name, method.desc, assignmentTriple.getOwner(), assignmentTriple.getName(), assignmentTriple.getDesc()});
                            continue block7;
                        }
                    }
                    newInsn = new LdcInsnNode(replacementLdc);
                    newInsn.invisibleTypeAnnotations = new ArrayList<E>();
                    newInsn.invisibleTypeAnnotations.add(new TypeAnnotationNode(0x47000000, null, "Lorg/stianloader/starplane/annotations/InlinedReferenceSourceMarker;"));
                    method.instructions.set(insn, (AbstractInsnNode)newInsn);
                    insn = nextInsn;
                    continue block7;
                }
            }
        }
    }

    @NotNull
    private static String remapReference(@NotNull Remapper remapper, @NotNull String string, @NotNull StringBuilder sharedBuilder) {
        int indexofDot = string.indexOf(46);
        if (indexofDot == -1) {
            return Remapper.remapInternalName((MappingLookup)remapper.getLookup(), (String)string, (StringBuilder)sharedBuilder);
        }
        StringBuilder builder = new StringBuilder();
        String methodOrField = string.substring(indexofDot + 1);
        String ownerName = string.substring(0, indexofDot);
        builder.append(Remapper.remapInternalName((MappingLookup)remapper.getLookup(), (String)ownerName, (StringBuilder)sharedBuilder));
        builder.append('.');
        int indexofSpace = methodOrField.indexOf(32);
        if (indexofSpace == -1) {
            int indexofBracket = methodOrField.indexOf(40);
            String methodName = methodOrField.substring(0, indexofBracket);
            String methodDesc = methodOrField.substring(indexofBracket);
            methodName = remapper.getLookup().getRemappedMethodName(ownerName, methodName, methodDesc);
            methodDesc = Remapper.getRemappedMethodDescriptor((MappingLookup)remapper.getLookup(), (String)methodDesc, (StringBuilder)sharedBuilder);
            builder.append(methodName);
            builder.append(methodDesc);
        } else {
            String fieldName = methodOrField.substring(0, indexofSpace);
            String fieldDesc = methodOrField.substring(++indexofSpace);
            fieldName = remapper.getLookup().getRemappedFieldName(ownerName, fieldName, fieldDesc);
            fieldDesc = Remapper.getRemappedFieldDescriptor((MappingLookup)remapper.getLookup(), (String)fieldDesc, (StringBuilder)sharedBuilder);
            builder.append(fieldName);
            builder.append(' ');
            builder.append(fieldDesc);
        }
        return builder.toString();
    }
}

