/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.sml6.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.stianloader.sml6.tasks.AbstractArtifactTask;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;

@CacheableTask
public abstract class XZCompressTask
extends AbstractArtifactTask {
    public XZCompressTask() {
        this.getArchiveExtension().convention((Object)"xz");
        this.getCompressionLevel().convention((Object)6);
    }

    @TaskAction
    public void compress() throws IOException {
        try (InputStream in = Files.newInputStream(((RegularFile)this.getInput().get()).getAsFile().toPath(), new OpenOption[0]);
             OutputStream out = Files.newOutputStream(((RegularFile)this.getArchiveFile().get()).getAsFile().toPath(), new OpenOption[0]);
             XZOutputStream compressedOut = new XZOutputStream(out, (FilterOptions)new LZMA2Options(((Integer)this.getCompressionLevel().get()).intValue()));){
            in.transferTo((OutputStream)compressedOut);
        }
    }

    public void from(Object notation) {
        this.getInput().fileProvider(this.getProject().getProviders().provider(() -> this.getProject().file(notation)));
        this.getInput().disallowChanges();
    }

    @Input
    @Optional
    public abstract Property<Integer> getCompressionLevel();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getInput();
}

