/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.sml6.tasks;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.MappingWriter;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.mappingio.tree.VisitOrder;
import net.fabricmc.mappingio.tree.VisitableMappingTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.jetbrains.annotations.NotNull;
import org.stianloader.sml6.GradleUtilities;

@CacheableTask
public abstract class AggregateMappingsTask
extends AbstractArchiveTask {
    public AggregateMappingsTask() {
        this.getArchiveBaseName().convention(GradleUtilities.getBaseArchiveName(this.getProject()));
        this.getDestinationDirectory().convention(GradleUtilities.getDistsDirectory(this.getProject()));
    }

    protected CopyAction createCopyAction() {
        return new AggregateMappingsCopyAction((MappingFormat)this.getInputFormat().get(), ((RegularFile)this.getArchiveFile().get()).getAsFile().toPath(), (MappingFormat)this.getOutputFormat().get());
    }

    @Input
    public abstract Property<@NotNull MappingFormat> getInputFormat();

    @Input
    public abstract Property<@NotNull MappingFormat> getOutputFormat();

    public void inputFormat(@NotNull String format) {
        this.getInputFormat().set((Object)this.toMappingFormat(format, false));
    }

    public void outputFormat(@NotNull String format) {
        this.getOutputFormat().set((Object)this.toMappingFormat(format, false));
    }

    @NotNull
    private MappingFormat toMappingFormat(@NotNull String format, boolean asDirectory) {
        MappingFormat mFormat;
        block7: {
            mFormat = null;
            String cleanFormat = format.toUpperCase(Locale.ROOT).replace('-', '_').replace(' ', '_');
            try {
                mFormat = MappingFormat.valueOf((String)cleanFormat);
            }
            catch (IllegalArgumentException e) {
                for (MappingFormat mf : MappingFormat.values()) {
                    if (mf.name == null || !mf.name.equalsIgnoreCase(format)) continue;
                    mFormat = mf;
                    break;
                }
                if (cleanFormat.equalsIgnoreCase("tiny2") || cleanFormat.equalsIgnoreCase("tinyv2") || cleanFormat.equalsIgnoreCase("tiny_v2")) {
                    mFormat = MappingFormat.TINY_2_FILE;
                }
                if (format.equalsIgnoreCase("enigma")) {
                    mFormat = asDirectory ? MappingFormat.ENIGMA_DIR : MappingFormat.ENIGMA_FILE;
                }
                if (mFormat != null) break block7;
                for (MappingFormat mf : MappingFormat.values()) {
                    if (mf.fileExt == null || !mf.fileExt.equalsIgnoreCase(format)) continue;
                    mFormat = mf;
                    break;
                }
            }
        }
        if (mFormat == null) {
            throw new IllegalArgumentException("No mappings format known under the following name: '" + format + "'");
        }
        return mFormat;
    }

    private static class AggregateMappingsCopyAction
    implements CopyAction {
        @NotNull
        private final MappingFormat inputFormat;
        @NotNull
        private final Path outputFile;
        @NotNull
        private final MappingFormat outputFormat;

        public AggregateMappingsCopyAction(@NotNull MappingFormat inputFormat, @NotNull Path outputFile, @NotNull MappingFormat outputFormat) {
            this.inputFormat = Objects.requireNonNull(inputFormat, "inputFormat may not be null!");
            this.outputFile = Objects.requireNonNull(outputFile, "outputFile may not be null!");
            this.outputFormat = Objects.requireNonNull(outputFormat, "outputFormat may not be null!");
        }

        public WorkResult execute(CopyActionProcessingStream stream) {
            MemoryMappingTree mappings = new MemoryMappingTree();
            stream.process(arg_0 -> this.lambda$execute$0((VisitableMappingTree)mappings, arg_0));
            try {
                MappingWriter writer = MappingWriter.create((Path)this.outputFile, (MappingFormat)this.outputFormat);
                if (writer == null) {
                    throw new IOException("Cannot create a MappingWriter instance for output path '" + String.valueOf(this.outputFile) + "' with format '" + String.valueOf(this.outputFormat) + "'");
                }
                mappings.accept((MappingVisitor)writer, VisitOrder.createByName());
                writer.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return WorkResults.didWork((boolean)true);
        }

        private /* synthetic */ void lambda$execute$0(VisitableMappingTree mappings, FileCopyDetailsInternal details) {
            if (details.isDirectory()) {
                return;
            }
            try {
                MappingReader.read((Path)details.getFile().toPath(), (MappingFormat)this.inputFormat, (MappingVisitor)mappings);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read mappings file '" + String.valueOf(details.getFile().toPath()) + "' with input format '" + String.valueOf(this.inputFormat) + "'", e);
            }
        }
    }
}

