/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.sml6.tasks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import javax.inject.Inject;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault(because="Already caches internally")
public abstract class FetchGameTask
extends ConventionTask {
    private static final String OPERATING_SYSTEM = System.getProperty("os.name");
    private static final String STEAM_WINDOWS_REGISTRY_INSTALL_DIR_KEY = "InstallPath";
    private static final String STEAM_WINDOWS_REGISTRY_KEY = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Valve\\Steam";

    @Nullable
    private static final File getOneOfExistingFiles(String ... paths) {
        for (String path : paths) {
            File file = new File(path);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private static final String readWindowsRegistry(String location, String key) {
        try {
            Process process = Runtime.getRuntime().exec("reg query \"" + location + "\" /v " + key);
            process.waitFor();
            InputStream is = process.getInputStream();
            String output = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            is.close();
            if (!output.contains(location) || !output.contains(key)) {
                return null;
            }
            String[] parsed = output.split("\\s+");
            return parsed[parsed.length - 1];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public FetchGameTask() {
        this.setGroup("SML6");
        this.getSteamApplicationName().convention((Object)"Galimulator");
        this.getSteamApplicationId().convention((Object)808100);
        this.getSteamJarPath().convention((Object)"jar/galimulator-desktop.jar");
        this.getAggressiveCaching().convention((Object)true);
        DirectoryProperty buildDir = this.getLayout().getBuildDirectory();
        Provider taskNameProvider = this.getProviders().provider(() -> ((FetchGameTask)this).getName());
        Provider cacheDir = buildDir.dir(taskNameProvider.map(s -> "sml6-" + s));
        this.getOutputJar().convention(cacheDir.map(d -> d.file("galimulator-clean.jar")));
    }

    @TaskAction
    public void fetchJar() throws IOException {
        boolean cachedGameJar;
        File cleanGameJar;
        block7: {
            block11: {
                File gameDir;
                block10: {
                    block9: {
                        block8: {
                            cleanGameJar = null;
                            cachedGameJar = false;
                            if (((Boolean)this.getAggressiveCaching().get()).booleanValue()) {
                                cleanGameJar = (File)this.getOutputJar().getAsFile().getOrNull();
                                if (cleanGameJar != null && cleanGameJar.exists()) {
                                    this.getLogger().info("Reusing cached game jar for task {}.", (Object)this.getPath());
                                    cachedGameJar = true;
                                } else {
                                    cleanGameJar = null;
                                }
                            }
                            if (cleanGameJar == null && this.getPrimaryGameJar().isPresent() && !(cleanGameJar = (File)this.getPrimaryGameJar().getAsFile().get()).exists()) {
                                this.getLogger().warn("Primary game jar for task {} was not found at {}", (Object)this.getPath(), (Object)cleanGameJar.getAbsolutePath());
                                cleanGameJar = null;
                            }
                            if (cleanGameJar != null) break block7;
                            String propertyPath = System.getProperty("org.stianloader.sml6.gameJar");
                            if (propertyPath == null) break block8;
                            cleanGameJar = this.getLayout().getProjectDirectory().getAsFile().toPath().resolve(propertyPath).toFile();
                            if (cleanGameJar.exists()) break block7;
                            this.getLogger().warn("Game jar at '{}' not found for task {}.", (Object)cleanGameJar.getAbsolutePath(), (Object)this.getPath());
                            cleanGameJar = null;
                            break block9;
                        }
                        this.getLogger().debug("System property 'org.stianloader.sml6.gameJar' not defined.");
                    }
                    String applicationName = (String)this.getSteamApplicationName().get();
                    if (applicationName == null) {
                        throw new AssertionError((Object)("steamApplicationName is null for task " + this.getPath()));
                    }
                    gameDir = this.getGameDir(applicationName);
                    if (gameDir == null || !gameDir.exists()) break block10;
                    String steamJarPath = (String)this.getSteamJarPath().get();
                    if (steamJarPath == null) {
                        throw new AssertionError((Object)("steamJarPath is null for task " + this.getPath()));
                    }
                    cleanGameJar = new File(gameDir, steamJarPath);
                    if (cleanGameJar.exists()) break block7;
                    this.getLogger().error("Unable to resolve game jar file (was able to resolve the potential directory though)! Candidate path: '{}' for task '{}'", (Object)cleanGameJar, (Object)this.getPath());
                    cleanGameJar = null;
                    break block11;
                }
                this.getLogger().error("Unable to resolve game directory! Expected at '{}' for task '{}'", (Object)gameDir, (Object)this.getPath());
            }
            throw new IllegalStateException("Cannot resolve dependencies");
        }
        if (!cachedGameJar) {
            Files.copy(cleanGameJar.toPath(), ((RegularFile)this.getOutputJar().get()).getAsFile().toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Input
    @Optional
    public abstract Property<Boolean> getAggressiveCaching();

    @Nullable
    protected File getGameDir(@NotNull String game) {
        File steamExec = this.getSteamExecutableDir();
        if (steamExec == null || !steamExec.exists()) {
            if (OPERATING_SYSTEM.toLowerCase(Locale.ROOT).startsWith("win")) {
                steamExec = FetchGameTask.getOneOfExistingFiles("C:\\Steam\\", "C:\\Program Files (x86)\\Steam\\", "C:\\Program Files\\Steam\\", "D:\\Steam\\", "C:\\Programmes\\Steam\\", "D:\\Programmes\\Steam\\", "D:\\SteamLibrary\\", "E:\\SteamLibrary\\", "F:\\SteamLibrary\\", "C:\\SteamLibrary\\");
            }
            if (steamExec == null) {
                return null;
            }
        }
        if (!steamExec.isDirectory()) {
            throw new IllegalStateException("Steam executable directory not a directory.");
        }
        File appdata = new File(steamExec, "steamapps");
        File common = new File(appdata, "common");
        return new File(common, game);
    }

    @Inject
    protected abstract ProjectLayout getLayout();

    @OutputFile
    public abstract RegularFileProperty getOutputJar();

    @InputFile
    @Optional
    public abstract RegularFileProperty getPrimaryGameJar();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Input
    @Optional
    @Deprecated
    public abstract Property<Integer> getSteamApplicationId();

    @Input
    @Optional
    public abstract Property<String> getSteamApplicationName();

    @Internal
    @Nullable
    protected File getSteamExecutableDir() {
        if (OPERATING_SYSTEM.toLowerCase(Locale.ROOT).startsWith("win")) {
            String val = FetchGameTask.readWindowsRegistry(STEAM_WINDOWS_REGISTRY_KEY, STEAM_WINDOWS_REGISTRY_INSTALL_DIR_KEY);
            if (val == null) {
                return null;
            }
            return new File(val);
        }
        String homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            return null;
        }
        File usrHome = new File(homeDir);
        File steamHome = new File(usrHome, ".steam");
        if (steamHome.exists()) {
            File debianInstall = new File(steamHome, "debian-installation");
            if (debianInstall.exists()) {
                return debianInstall;
            }
            return new File(steamHome, "steam");
        }
        File local = new File(usrHome, ".local");
        if (!local.exists()) {
            return null;
        }
        File share = new File(local, "share");
        if (!share.exists()) {
            return null;
        }
        return new File(share, "Steam");
    }

    @Input
    @Optional
    public abstract Property<String> getSteamJarPath();
}

