/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.sml6.tasks;

import de.geolykt.starloader.deobf.ClassWrapper;
import de.geolykt.starloader.deobf.IntermediaryGenerator;
import de.geolykt.starloader.deobf.MethodReference;
import de.geolykt.starloader.deobf.Oaktree;
import de.geolykt.starloader.deobf.remapper.Remapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarFile;
import javax.inject.Inject;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.stianloader.sml6.starplane.autodeobf.Autodeobf502;

@CacheableTask
public abstract class DeobfuscateGameTask
extends ConventionTask {
    public DeobfuscateGameTask() {
        this.setGroup("SML6");
        this.getAutodeobfVersion().convention((Object)"5.0.2");
        this.getWithAutodeobf().convention((Object)true);
        this.getWithSLDeobf().convention((Object)true);
        this.getWithSLDeobfRemapping().convention(this.getWithSLDeobf());
        DirectoryProperty buildDir = this.getLayout().getBuildDirectory();
        Provider taskNameProvider = this.getProviders().provider(() -> ((DeobfuscateGameTask)this).getName());
        this.getOutputDirectory().convention(buildDir.dir(taskNameProvider.map(s -> "sml6-" + s)));
        this.getSlIntermediaryMappings().convention(this.getOutputDirectory().file("slintermediary.tiny"));
        this.getSpStarmapMappings().convention(this.getOutputDirectory().file("spstarmap.tiny"));
        this.getOutputJar().convention(this.getOutputDirectory().file("game-transformed.jar"));
    }

    private void addSignatures(List<ClassNode> nodes, Map<String, ClassNode> nameToNode, Map<MethodReference, ClassWrapper> signatures) {
        StringBuilder builder = new StringBuilder();
        for (ClassNode node : nodes) {
            for (MethodNode method : node.methods) {
                ClassWrapper newSignature;
                if (method.signature != null || (newSignature = signatures.get(new MethodReference(node.name, method))) == null) continue;
                builder.append(method.desc, 0, method.desc.length() - 1);
                builder.append("<L");
                builder.append(newSignature.getName());
                builder.append(";>;");
                method.signature = builder.toString();
                builder.setLength(0);
            }
        }
    }

    @TaskAction
    public void deobfuscate() {
        Path cleanGalimJar = ((RegularFile)this.getInputJar().get()).getAsFile().toPath();
        if (Files.notExists(cleanGalimJar, new LinkOption[0])) {
            throw new IllegalStateException("Input file does not exist: " + String.valueOf(cleanGalimJar.toAbsolutePath()));
        }
        this.getLogger().debug("Task '{}' is using the game jar found at '{}'." + this.getPath(), (Object)cleanGalimJar);
        Path intermediaryMappingsFile = ((File)this.getSlIntermediaryMappings().getAsFile().get()).toPath();
        Oaktree deobfuscator = new Oaktree();
        try {
            if (!((Boolean)this.getWithSLDeobf().get()).booleanValue() && !((Boolean)this.getWithAutodeobf().get()).booleanValue()) {
                if (((Boolean)this.getWithSLDeobfRemapping().get()).booleanValue()) {
                    this.getLogger().warn("Task '{}' has 'withSLDeobf' set to false, while 'withSLDeobfRemapping' is true. The latter will be skipped.");
                }
            } else {
                long indexing = System.nanoTime();
                JarFile jar = new JarFile(cleanGalimJar.toFile());
                deobfuscator.index(jar);
                jar.close();
                HashMap<String, ClassNode> nameToNode = new HashMap<String, ClassNode>();
                for (ClassNode node : deobfuscator.getClassNodesDirectly()) {
                    nameToNode.put(node.name, node);
                }
                long startDeobf = System.nanoTime();
                this.getLogger().debug("Loaded input jar in " + (startDeobf - indexing) / 1000000L + " ms.");
                if (!((Boolean)this.getWithSLDeobf().get()).booleanValue()) {
                    if (((Boolean)this.getWithSLDeobfRemapping().get()).booleanValue()) {
                        this.getLogger().warn("Task '{}' has 'withSLDeobf' set to false, while 'withSLDeobfRemapping' is true. The latter will be skipped.");
                    }
                } else {
                    deobfuscator.fixInnerClasses();
                    deobfuscator.fixParameterLVT();
                    deobfuscator.guessFieldGenerics();
                    this.addSignatures(deobfuscator.getClassNodesDirectly(), nameToNode, deobfuscator.analyseLikelyMethodReturnCollectionGenerics());
                    HashMap<MethodReference, ClassWrapper> methods = new HashMap<MethodReference, ClassWrapper>();
                    deobfuscator.lambdaStreamGenericSignatureGuessing(null, methods);
                    this.addSignatures(deobfuscator.getClassNodesDirectly(), nameToNode, methods);
                    deobfuscator.inferMethodGenerics();
                    deobfuscator.inferConstructorGenerics();
                    deobfuscator.fixForeachOnArray();
                    deobfuscator.fixComparators(false);
                    deobfuscator.guessAnonymousInnerClasses();
                    for (ClassNode node : deobfuscator.getClassNodesDirectly()) {
                        for (InnerClassNode icn : node.innerClasses) {
                            icn.access &= 0xFFFFFFDF;
                        }
                    }
                    long startIntermediarisation = System.nanoTime();
                    this.getLogger().debug("Deobfuscated classes in " + (startIntermediarisation - startDeobf) / 1000000L + " ms.");
                    if (((Boolean)this.getWithSLDeobfRemapping().get()).booleanValue()) {
                        IntermediaryGenerator generator = new IntermediaryGenerator(intermediaryMappingsFile, null, (Collection)deobfuscator.getClassNodesDirectly());
                        generator.useAlternateClassNaming(!Boolean.getBoolean("de.geolykt.starplane.oldnames"));
                        generator.remapClassesV2(true);
                        deobfuscator.fixSwitchMaps();
                        generator.doProposeEnumFieldsV2();
                        generator.remapGetters();
                        generator.deobfuscate();
                        this.getLogger().info("Task '{}' computed sldeobf intermediaries in {} ms.", (Object)this.getPath(), (Object)((System.nanoTime() - startIntermediarisation) / 1000000L));
                    }
                    if (!((Boolean)this.getWithAutodeobf().get()).booleanValue()) {
                        deobfuscator.invalidateNameCaches();
                        deobfuscator.applyInnerclasses();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to run sldeobf", e);
        }
        if (((Boolean)this.getWithAutodeobf().get()).booleanValue()) {
            try {
                Remapper remapper = new Remapper();
                remapper.addTargets((Collection)deobfuscator.getClassNodesDirectly());
                long startSlStarmap = System.nanoTime();
                String autodeobfVersion = (String)this.getAutodeobfVersion().get();
                if (!autodeobfVersion.equals("5.0.2")) {
                    throw new IllegalStateException("No Autodeobf implementation for version " + autodeobfVersion);
                }
                Autodeobf502 deobf = new Autodeobf502(deobfuscator.getClassNodesDirectly(), remapper);
                this.getLogger().info("Task '{}' uses autodeobf version {}", (Object)this.getPath(), (Object)deobf.getVersion());
                try (BufferedWriter writer = Files.newBufferedWriter(((RegularFile)this.getSpStarmapMappings().get()).getAsFile().toPath(), StandardOpenOption.CREATE);){
                    writer.write("v1\tintermediary\tnamed\n");
                    deobf.runAll(writer);
                    for (Map.Entry e : remapper.fixICNNames(new StringBuilder()).entrySet()) {
                        writer.write("CLASS\t");
                        writer.write(Objects.requireNonNull((String)e.getKey()));
                        ((Writer)writer).write(9);
                        writer.write(Objects.requireNonNull((String)e.getValue()));
                        ((Writer)writer).write(10);
                    }
                    ((Writer)writer).flush();
                    remapper.process();
                }
                if (((Boolean)this.getWithSLDeobf().get()).booleanValue()) {
                    deobfuscator.invalidateNameCaches();
                    deobfuscator.applyInnerclasses();
                }
                this.getLogger().info("Computed spStarmap in " + (System.nanoTime() - startSlStarmap) / 1000000L + " ms.");
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot write Autodeobf-generated mappings", e);
            }
        }
        try (OutputStream os = Files.newOutputStream(((RegularFile)this.getOutputJar().get()).getAsFile().toPath(), new OpenOption[0]);){
            deobfuscator.write(os, cleanGalimJar);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed writing output jar", e);
        }
    }

    @Input
    @Optional
    public abstract Property<String> getAutodeobfVersion();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getInputJar();

    @Inject
    protected abstract ProjectLayout getLayout();

    @Internal(value="Transitively affects other output locations. Not used directly.")
    public abstract DirectoryProperty getOutputDirectory();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getOutputJar();

    @Inject
    protected abstract ProviderFactory getProviders();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getSlIntermediaryMappings();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getSpStarmapMappings();

    @Input
    @Optional
    public abstract Property<Boolean> getWithAutodeobf();

    @Input
    @Optional
    public abstract Property<Boolean> getWithSLDeobf();

    @Input
    @Optional
    public abstract Property<Boolean> getWithSLDeobfRemapping();
}

