/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.sml6.starplane.remapping;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.stianloader.remapper.MappingLookup;
import org.stianloader.remapper.MemberRef;
import org.stianloader.remapper.Remapper;
import org.stianloader.remapper.SimpleMappingLookup;

public class StarplaneMappingLookup
extends SimpleMappingLookup {
    @NotNull
    private final Path map;
    private final boolean reverse;
    private final boolean ignoreNonExistentFiles;

    public StarplaneMappingLookup(@NotNull Path map, boolean reversed) {
        this(map, reversed, false);
    }

    public StarplaneMappingLookup(@NotNull Path map, boolean reversed, boolean ignoreNonExistentFiles) {
        this.map = map;
        this.reverse = reversed;
        this.ignoreNonExistentFiles = ignoreNonExistentFiles;
    }

    @NotNull
    @Contract(mutates="this", pure=false, value="-> this")
    public StarplaneMappingLookup load() throws IOException {
        if (this.ignoreNonExistentFiles && Files.notExists(this.map, new LinkOption[0])) {
            return this;
        }
        SimpleMappingLookup classLookup = new SimpleMappingLookup();
        ArrayList<@NotNull String[]> delayedMemberMappings = new ArrayList<String[]>();
        int lineNr = 0;
        try (BufferedReader br = Files.newBufferedReader(this.map, StandardCharsets.UTF_8);){
            String header = br.readLine();
            ++lineNr;
            if (header == null || header.isBlank()) {
                br.close();
                throw new IOException("No tiny header present (empty file?).");
            }
            String[] headerTokens = header.split("\\s+");
            if (headerTokens.length != 3) {
                br.close();
                throw new IOException("The tiny header had " + headerTokens.length + " tokens, however it is expected to be exactly 3.");
            }
            if (!headerTokens[0].equals("v1")) {
                br.close();
                throw new IOException("This method can only read tiny v1 maps.");
            }
            String line = br.readLine();
            while (line != null) {
                ++lineNr;
                if (line.charAt(0) != '#' && (line = line.split("#", 2)[0]) != null && !line.isBlank()) {
                    @NotNull String[] colums = line.split("\\s+");
                    String type = colums[0].toUpperCase(Locale.ROOT);
                    if (type.equals("CLASS")) {
                        if (colums.length != 3) {
                            throw new IOException("Line " + lineNr + " is of type CLASS, but only " + colums.length + " colums are present, even though it expects 3.");
                        }
                        if (this.reverse) {
                            super.remapClass(colums[2], colums[1]);
                            classLookup.remapClass(colums[1], colums[2]);
                        } else {
                            super.remapClass(colums[1], colums[2]);
                        }
                    } else if (type.equals("METHOD")) {
                        if (colums.length != 5) {
                            throw new IOException("Line " + lineNr + " is of type CLASS, but only " + colums.length + " colums are present, even though it expects 5.");
                        }
                        delayedMemberMappings.add(colums);
                    } else if (type.equals("FIELD")) {
                        if (colums.length != 5) {
                            throw new IOException("Line " + lineNr + " is of type CLASS, but only " + colums.length + " colums are present, even though it expects 5.");
                        }
                        delayedMemberMappings.add(colums);
                    }
                }
                line = br.readLine();
            }
        }
        StringBuilder descBuilder = new StringBuilder();
        for (String[] columns : delayedMemberMappings) {
            String srcOwner = columns[1];
            String srcDesc = columns[2];
            String srcName = columns[3];
            String dstName = columns[4];
            if (this.reverse) {
                boolean field = srcDesc.codePointAt(0) != 40;
                srcOwner = classLookup.getRemappedClassName(srcOwner);
                srcDesc = field ? Remapper.getRemappedFieldDescriptor((MappingLookup)classLookup, (String)srcDesc, (StringBuilder)descBuilder) : Remapper.getRemappedMethodDescriptor((MappingLookup)classLookup, (String)srcDesc, (StringBuilder)descBuilder);
                String swapStore = srcName;
                srcName = dstName;
                dstName = swapStore;
            }
            super.remapMember(new MemberRef(srcOwner, srcName, srcDesc), dstName);
        }
        return this;
    }

    public String toString() {
        return "SP Mapping Lookup [map=" + String.valueOf(this.map.getFileName()) + ",reversed=" + this.reverse + "]";
    }
}

