/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.jlsl;

import java.io.PrintWriter;
import java.util.ArrayList;
import org.jglrxavpok.jlsl.CodeDecoder;
import org.jglrxavpok.jlsl.CodeEncoder;
import org.jglrxavpok.jlsl.CodeFilter;
import org.jglrxavpok.jlsl.fragments.CodeFragment;

public class JLSLContext {
    public static JLSLContext currentInstance;
    private CodeDecoder decoder;
    private CodeEncoder encoder;
    private ArrayList<CodeFilter> filters;
    private Object object;

    public JLSLContext(CodeDecoder decoder, CodeEncoder encoder) {
        currentInstance = this;
        this.filters = new ArrayList();
        this.decoder = decoder;
        this.decoder.context = this;
        this.encoder = encoder;
        this.encoder.context = this;
    }

    public void addFilters(CodeFilter ... filters) {
        for (CodeFilter filter : filters) {
            this.filters.add(filter);
        }
    }

    public void requestAnalysisForEncoder(Object data) {
        this.object = data;
        ArrayList<CodeFragment> fragments = new ArrayList<CodeFragment>();
        this.decoder.handleClass(data, fragments);
        ArrayList<CodeFragment> finalFragments = new ArrayList<CodeFragment>();
        for (CodeFragment frag : fragments) {
            if (frag == null) continue;
            finalFragments.add(this.filter(frag));
        }
        this.encoder.onRequestResult(finalFragments);
    }

    private CodeFragment filter(CodeFragment fragment) {
        for (CodeFilter filter : this.filters) {
            fragment = filter.filter(fragment);
        }
        return fragment;
    }

    public void execute(Object data, PrintWriter out) {
        this.object = data;
        ArrayList<CodeFragment> fragments = new ArrayList<CodeFragment>();
        this.decoder.handleClass(data, fragments);
        ArrayList<CodeFragment> finalFragments = new ArrayList<CodeFragment>();
        for (CodeFragment frag : fragments) {
            if (frag == null) continue;
            finalFragments.add(this.filter(frag));
        }
        this.encoder.createSourceCode(finalFragments, out);
    }

    public Object getCurrentObject() {
        return this.object;
    }
}

