/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.jlsl.conversion;

import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.jlsl.glsl.GLSL;

class JavaUtils {
    JavaUtils() {
    }

    static MethodSignature toSignature(String description) {
        char returnType = description.charAt(description.indexOf(41) + 1);
        String returnTypeStr = JavaUtils.getTypeString(returnType);
        if (returnTypeStr == null) {
            throw new IllegalArgumentException("Invalid return type: " + returnType);
        }
        if (returnTypeStr.equals("object")) {
            int endArgs = description.indexOf(")");
            String contents = description.substring(endArgs + 1);
            String className = contents.substring(1, contents.length() - 1);
            returnTypeStr = className.replace("/", ".");
            description = description.substring(0, endArgs + 1);
        } else {
            description = description.substring(0, description.length() - 1);
        }
        description = description.substring(1, description.length() - 1);
        ArrayDeque<String> types = new ArrayDeque<String>();
        while (description.length() > 0) {
            String typeStr = JavaUtils.getTypeString(description.charAt(0));
            if (typeStr == null) {
                throw new IllegalArgumentException("Invalid type: " + description.charAt(0));
            }
            String type = switch (typeStr) {
                case "object" -> {
                    int end = description.indexOf(59);
                    if (end == -1) {
                        throw new IllegalArgumentException("Invalid type: " + description);
                    }
                    String objectType = description.substring(1, end);
                    description = description.substring(end + 1);
                    yield objectType = objectType.replace("/", ".");
                }
                default -> {
                    description = description.substring(1);
                    yield typeStr;
                }
            };
            types.add(type);
        }
        return new MethodSignature(returnTypeStr, List.copyOf(types));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    static String getTypeFromDescription(String desc) {
        char firstChar = desc.charAt(0);
        switch (firstChar) {
            case 'I': {
                String string;
                String string2 = string = "int";
                return string2;
            }
            case 'F': {
                String string;
                String string2 = string = "float";
                return string2;
            }
            case 'L': {
                String string;
                String string2;
                desc = desc.substring(1, desc.length() - 1);
                desc = desc.replace('/', '.');
                try {
                    Class<?> clazz = Class.forName(desc);
                    for (Annotation annotation : clazz.getAnnotations()) {
                        String string3;
                        if (!(annotation instanceof GLSL.NativeClass)) continue;
                        GLSL.NativeClass nativeClass = (GLSL.NativeClass)annotation;
                        string2 = string3 = nativeClass.name();
                        return string2;
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                string2 = string = desc.substring(desc.lastIndexOf(46) + 1);
                return string2;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + desc);
    }

    private static String getTypeString(char type) {
        return switch (type) {
            case 'I' -> "int";
            case 'J' -> "long";
            case 'F' -> "float";
            case 'D' -> "double";
            case 'B' -> "byte";
            case 'C' -> "char";
            case 'S' -> "short";
            case 'Z' -> "boolean";
            case 'V' -> "void";
            case 'L' -> "object";
            default -> null;
        };
    }

    public record MethodSignature(String returnType, List<String> argTypes) {
    }
}

