/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.jlsl.glsl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.jlsl.CodeEncoder;
import org.jglrxavpok.jlsl.JLSLException;
import org.jglrxavpok.jlsl.fragments.AddFragment;
import org.jglrxavpok.jlsl.fragments.AndFragment;
import org.jglrxavpok.jlsl.fragments.AnnotationFragment;
import org.jglrxavpok.jlsl.fragments.ArrayOfArrayLoadFragment;
import org.jglrxavpok.jlsl.fragments.ArrayStoreFragment;
import org.jglrxavpok.jlsl.fragments.CastFragment;
import org.jglrxavpok.jlsl.fragments.CodeFragment;
import org.jglrxavpok.jlsl.fragments.CompareFragment;
import org.jglrxavpok.jlsl.fragments.DivFragment;
import org.jglrxavpok.jlsl.fragments.DuplicateFragment;
import org.jglrxavpok.jlsl.fragments.ElseStatementFragment;
import org.jglrxavpok.jlsl.fragments.EndOfBlockFragment;
import org.jglrxavpok.jlsl.fragments.EndOfMethodFragment;
import org.jglrxavpok.jlsl.fragments.EqualCheckFragment;
import org.jglrxavpok.jlsl.fragments.FieldFragment;
import org.jglrxavpok.jlsl.fragments.GetFieldFragment;
import org.jglrxavpok.jlsl.fragments.IfNotStatementFragment;
import org.jglrxavpok.jlsl.fragments.IfStatementFragment;
import org.jglrxavpok.jlsl.fragments.IntPushFragment;
import org.jglrxavpok.jlsl.fragments.LdcFragment;
import org.jglrxavpok.jlsl.fragments.LeftShiftFragment;
import org.jglrxavpok.jlsl.fragments.LineNumberFragment;
import org.jglrxavpok.jlsl.fragments.LoadConstantFragment;
import org.jglrxavpok.jlsl.fragments.LoadVariableFragment;
import org.jglrxavpok.jlsl.fragments.MethodCallFragment;
import org.jglrxavpok.jlsl.fragments.ModFragment;
import org.jglrxavpok.jlsl.fragments.MulFragment;
import org.jglrxavpok.jlsl.fragments.NewArrayFragment;
import org.jglrxavpok.jlsl.fragments.NewClassFragment;
import org.jglrxavpok.jlsl.fragments.NewInstanceFragment;
import org.jglrxavpok.jlsl.fragments.NewMultiArrayFragment;
import org.jglrxavpok.jlsl.fragments.NewPrimitiveArrayFragment;
import org.jglrxavpok.jlsl.fragments.NotEqualCheckFragment;
import org.jglrxavpok.jlsl.fragments.OrFragment;
import org.jglrxavpok.jlsl.fragments.PopFragment;
import org.jglrxavpok.jlsl.fragments.PutFieldFragment;
import org.jglrxavpok.jlsl.fragments.ReturnFragment;
import org.jglrxavpok.jlsl.fragments.ReturnValueFragment;
import org.jglrxavpok.jlsl.fragments.RightShiftFragment;
import org.jglrxavpok.jlsl.fragments.StartOfMethodFragment;
import org.jglrxavpok.jlsl.fragments.StoreVariableFragment;
import org.jglrxavpok.jlsl.fragments.SubFragment;
import org.jglrxavpok.jlsl.fragments.XorFragment;
import org.jglrxavpok.jlsl.glsl.FragmentShader;
import org.jglrxavpok.jlsl.glsl.GLSL;
import org.jglrxavpok.jlsl.glsl.GLSLMath;
import org.jglrxavpok.jlsl.glsl.Mat2;
import org.jglrxavpok.jlsl.glsl.Mat3;
import org.jglrxavpok.jlsl.glsl.Mat4;
import org.jglrxavpok.jlsl.glsl.Sampler2D;
import org.jglrxavpok.jlsl.glsl.Vec2;
import org.jglrxavpok.jlsl.glsl.Vec3;
import org.jglrxavpok.jlsl.glsl.Vec4;
import org.jglrxavpok.jlsl.glsl.fragments.StructFragment;

public class GLSLEncoder
extends CodeEncoder {
    public static boolean DEBUG = true;
    private static final int STRUCT = 1;
    private int indentation;
    private int glslversion;
    private NewClassFragment currentClass;
    private ArrayList<String> extensions = new ArrayList();
    private String space = " ";
    private String tab = "    ";
    private int currentLine;
    private Stack<String> stack;
    private Stack<String> typesStack;
    private HashMap<String, String> name2type;
    private HashMap<Object, String> constants;
    private HashMap<String, String> methodReplacements;
    private ArrayList<String> initialized;
    private StartOfMethodFragment currentMethod;
    private boolean convertNumbersToChars = true;
    private ArrayList<String> loadedStructs = new ArrayList();
    private int currentRequestType;
    private Object requestData;
    private boolean allowedToPrint;
    private PrintWriter output;
    private Stack<CodeFragment> waiting;
    private Stack<String> newInstances;
    private String structOwnerMethodSeparator;
    private HashMap<String, String> translations = new HashMap();
    private HashMap<String, String> conversionsToStructs = new HashMap();

    private static void enforceCompatibleAnnotations(@Nullable String oldAnnotation, @NotNull String newAnnotation) {
        if (oldAnnotation != null) {
            throw new IllegalStateException("Mutually exclusive annotations provided: '" + oldAnnotation + "' and '" + newAnnotation + "'");
        }
    }

    public GLSLEncoder(int glslversion) {
        this.glslversion = glslversion;
        this.stack = new Stack();
        this.typesStack = new Stack();
        this.initialized = new ArrayList();
        this.name2type = new HashMap();
        this.constants = new HashMap();
        this.methodReplacements = new HashMap();
        this.waiting = new Stack();
        this.newInstances = new Stack();
        this.structOwnerMethodSeparator = "__";
        this.init();
    }

    public void init() {
        this.setGLSLTranslation("boolean", "bool");
        this.setGLSLTranslation("double", "float");
        this.setGLSLTranslation(Vec2.class.getCanonicalName(), "vec2");
        this.setGLSLTranslation(Vec3.class.getCanonicalName(), "vec3");
        this.setGLSLTranslation(Vec4.class.getCanonicalName(), "vec4");
        this.setGLSLTranslation(Mat2.class.getCanonicalName(), "mat2");
        this.setGLSLTranslation(Mat3.class.getCanonicalName(), "mat3");
        this.setGLSLTranslation(Mat4.class.getCanonicalName(), "mat4");
        this.setGLSLTranslation(Integer.class.getCanonicalName(), "int");
        this.setGLSLTranslation(Math.class.getCanonicalName(), "");
        this.setGLSLTranslation(GLSLMath.class.getCanonicalName(), "");
        this.setGLSLTranslation(Sampler2D.class.getCanonicalName(), "sampler2D");
    }

    public void addToStructConversion(String javaType, String structName) {
        this.conversionsToStructs.put(javaType, structName);
    }

    public boolean hasStructAttached(String javaType) {
        return this.conversionsToStructs.containsKey(javaType);
    }

    public void setGLSLTranslation(String javaType, String glslType) {
        this.translations.put(javaType, glslType);
    }

    public void removeGLSLTranslation(String javaType) {
        this.translations.remove(javaType);
    }

    private String toGLSL(String type) {
        if (type == null) {
            return "";
        }
        String copy = type;
        String end = "";
        while (copy.contains("[]")) {
            copy = copy.replaceFirst("\\[\\]", "");
            end = end + "[]";
        }
        type = copy;
        if (this.conversionsToStructs.containsKey(type)) {
            return this.conversionsToStructs.get(type) + end;
        }
        if (this.translations.containsKey(type)) {
            return this.translations.get(type) + end;
        }
        return type + end;
    }

    private String getEndOfLine(int currentLine) {
        String s = "";
        s = " //Line #" + currentLine;
        return s;
    }

    public void convertNumbersToChar(boolean convert) {
        this.convertNumbersToChars = convert;
    }

    @Override
    public void onRequestResult(ArrayList<CodeFragment> fragments) {
        if (this.currentRequestType == 1) {
            StructFragment currentStruct = (StructFragment)this.requestData;
            HashMap<String, String> fields = currentStruct.fields;
            for (int i = 0; i < fragments.size(); ++i) {
                CodeFragment fragment = fragments.get(i);
                if (fragment.getClass() == FieldFragment.class) {
                    FieldFragment fieldFrag = (FieldFragment)fragment;
                    fields.put(fieldFrag.name, fieldFrag.type);
                    fragment.forbiddenToPrint = true;
                }
                currentStruct.addChild(fragment);
            }
        }
    }

    @Override
    public void createSourceCode(List<CodeFragment> in, PrintWriter out) {
        this.interpret(in);
        this.output = out;
        this.allowedToPrint = true;
        this.println("#version " + this.glslversion);
        int len = in.size();
        for (int index = 0; index < len; ++index) {
            CodeFragment fragment = in.get(index);
            this.output = out;
            boolean bl = this.allowedToPrint = !fragment.forbiddenToPrint;
            while (!this.waiting.isEmpty()) {
                this.handleCodeFragment(this.waiting.pop(), index, in, out);
            }
            this.handleCodeFragment(fragment, index, in, out);
        }
        out.flush();
    }

    private void handleCodeFragment(CodeFragment fragment, int index, List<CodeFragment> in, PrintWriter out) {
        if (fragment.getClass() == NewClassFragment.class) {
            this.handleClassFragment((NewClassFragment)fragment, in, index, out);
            this.currentClass = (NewClassFragment)fragment;
        } else if (fragment.getClass() == FieldFragment.class) {
            this.handleFieldFragment((FieldFragment)fragment, in, index, out);
        } else if (fragment.getClass() == StartOfMethodFragment.class) {
            this.handleStartOfMethodFragment((StartOfMethodFragment)fragment, in, index, out);
            this.currentMethod = (StartOfMethodFragment)fragment;
        } else if (fragment.getClass() == EndOfMethodFragment.class) {
            this.handleEndOfMethodFragment((EndOfMethodFragment)fragment, in, index, out);
        } else if (fragment.getClass() == LineNumberFragment.class) {
            this.currentLine = ((LineNumberFragment)fragment).line;
        } else if (fragment.getClass() == NewArrayFragment.class) {
            this.handleNewArrayFragment((NewArrayFragment)fragment, in, index, out);
        } else if (fragment.getClass() == NewMultiArrayFragment.class) {
            this.handleNewMultiArrayFragment((NewMultiArrayFragment)fragment, in, index, out);
        } else if (fragment.getClass() == PutFieldFragment.class) {
            this.handlePutFieldFragment((PutFieldFragment)fragment, in, index, out);
        } else if (fragment.getClass() == GetFieldFragment.class) {
            this.handleGetFieldFragment((GetFieldFragment)fragment, in, index, out);
        } else if (fragment.getClass() == IntPushFragment.class) {
            this.handleBiPushFragment((IntPushFragment)fragment, in, index, out);
        } else if (fragment.getClass() == NewPrimitiveArrayFragment.class) {
            this.handleNewPrimitiveArrayFragment((NewPrimitiveArrayFragment)fragment, in, index, out);
        } else if (fragment.getClass() == LoadVariableFragment.class) {
            this.handleLoadVariableFragment((LoadVariableFragment)fragment, in, index, out);
        } else if (fragment.getClass() == StoreVariableFragment.class) {
            this.handleStoreVariableFragment((StoreVariableFragment)fragment, in, index, out);
        } else if (fragment.getClass() == LdcFragment.class) {
            this.handleLdcFragment((LdcFragment)fragment, in, index, out);
        } else if (fragment.getClass() == LoadConstantFragment.class) {
            this.handleLoadConstantFragment((LoadConstantFragment)fragment, in, index, out);
        } else if (fragment.getClass() == ReturnValueFragment.class) {
            this.handleReturnValueFragment((ReturnValueFragment)fragment, in, index, out);
        } else if (fragment.getClass() == AddFragment.class) {
            this.handleAddFragment((AddFragment)fragment, in, index, out);
        } else if (fragment.getClass() == SubFragment.class) {
            this.handleSubFragment((SubFragment)fragment, in, index, out);
        } else if (fragment.getClass() == MulFragment.class) {
            this.handleMulFragment((MulFragment)fragment, in, index, out);
        } else if (fragment.getClass() == DivFragment.class) {
            this.handleDivFragment((DivFragment)fragment, in, index, out);
        } else if (fragment.getClass() == ArrayOfArrayLoadFragment.class) {
            this.handleArrayOfArrayLoadFragment((ArrayOfArrayLoadFragment)fragment, in, index, out);
        } else if (fragment.getClass() == ArrayStoreFragment.class) {
            this.handleArrayStoreFragment((ArrayStoreFragment)fragment, in, index, out);
        } else if (fragment.getClass() == IfStatementFragment.class) {
            this.handleIfStatementFragment((IfStatementFragment)fragment, in, index, out);
        } else if (fragment.getClass() == EndOfBlockFragment.class) {
            this.handleEndOfBlockFragment((EndOfBlockFragment)fragment, in, index, out);
        } else if (fragment.getClass() == ElseStatementFragment.class) {
            this.handleElseStatementFragment((ElseStatementFragment)fragment, in, index, out);
        } else if (fragment.getClass() == MethodCallFragment.class) {
            this.handleMethodCallFragment((MethodCallFragment)fragment, in, index, out);
        } else if (fragment.getClass() == ModFragment.class) {
            this.handleModFragment((ModFragment)fragment, in, index, out);
        } else if (fragment.getClass() == CastFragment.class) {
            this.handleCastFragment((CastFragment)fragment, in, index, out);
        } else if (fragment.getClass() == LeftShiftFragment.class) {
            this.handleLeftShiftFragment((LeftShiftFragment)fragment, in, index, out);
        } else if (fragment.getClass() == RightShiftFragment.class) {
            this.handleRightShiftFragment((RightShiftFragment)fragment, in, index, out);
        } else if (fragment.getClass() == AndFragment.class) {
            this.handleAndFragment((AndFragment)fragment, in, index, out);
        } else if (fragment.getClass() == OrFragment.class) {
            this.handleOrFragment((OrFragment)fragment, in, index, out);
        } else if (fragment.getClass() == XorFragment.class) {
            this.handleXorFragment((XorFragment)fragment, in, index, out);
        } else if (fragment.getClass() == IfNotStatementFragment.class) {
            this.handleIfNotStatementFragment((IfNotStatementFragment)fragment, in, index, out);
        } else if (fragment.getClass() == PopFragment.class) {
            this.handlePopFragment((PopFragment)fragment, in, index, out);
        } else if (fragment.getClass() == ReturnFragment.class) {
            this.handleReturnFragment((ReturnFragment)fragment, in, index, out);
        } else if (fragment.getClass() == DuplicateFragment.class) {
            this.handleDuplicateFragment((DuplicateFragment)fragment, in, index, out);
        } else if (fragment.getClass() == NewInstanceFragment.class) {
            this.handleNewInstanceFragment((NewInstanceFragment)fragment, in, index, out);
        } else if (fragment.getClass() == EqualCheckFragment.class) {
            this.handleEqualCheckFragment((EqualCheckFragment)fragment, in, index, out);
        } else if (fragment.getClass() == NotEqualCheckFragment.class) {
            this.handleNotEqualCheckFragment((NotEqualCheckFragment)fragment, in, index, out);
        } else if (fragment.getClass() == CompareFragment.class) {
            this.handleCompareFragment((CompareFragment)fragment, in, index, out);
        } else if (fragment.getClass() == StructFragment.class) {
            this.handleStructFragment((StructFragment)fragment, in, index, out);
        }
    }

    private void handleCompareFragment(CompareFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String right = this.stack.pop();
        String left = this.stack.pop();
        this.stack.push(left + this.space + (fragment.inferior ? "<" : ">") + this.space + right);
    }

    private void handleNotEqualCheckFragment(NotEqualCheckFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String right = this.stack.pop();
        String left = this.stack.pop();
        this.stack.push("(" + left + this.space + "!=" + this.space + right + ")");
    }

    private void handleEqualCheckFragment(EqualCheckFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String right = this.stack.pop();
        String left = this.stack.pop();
        this.stack.push("(" + left + this.space + "==" + this.space + right + ")");
    }

    private void handleNewInstanceFragment(NewInstanceFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        this.newInstances.push(fragment.type);
    }

    private void handleStructFragment(StructFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        this.println(this.getIndent() + "struct " + fragment.name);
        this.println(this.getIndent() + "{");
        ++this.indentation;
        for (String name : fragment.fields.keySet()) {
            String type = this.toGLSL(fragment.fields.get(name));
            this.println(this.getIndent() + type + this.space + name + ";");
        }
        --this.indentation;
        this.println(this.getIndent() + "};");
        StartOfMethodFragment currentMethod = null;
        String instanceName = ("" + fragment.name.charAt(0)).toLowerCase() + fragment.name.substring(1) + "Instance";
        for (int i = 0; i < fragment.getChildren().size(); ++i) {
            CodeFragment var;
            CodeFragment fragment1 = fragment.getChildren().get(i);
            if (fragment1 == null) continue;
            this.output = out;
            boolean bl = this.allowedToPrint = !fragment1.forbiddenToPrint;
            if (fragment1 instanceof StartOfMethodFragment) {
                StartOfMethodFragment method;
                currentMethod = method = (StartOfMethodFragment)fragment1;
                String oldName = currentMethod.name;
                method.varNameMap.put(0, instanceName);
                boolean isConstructor = false;
                if (currentMethod.name.equals("<init>") || currentMethod.name.equals(fragment.name + this.structOwnerMethodSeparator + "new")) {
                    currentMethod.name = "new";
                    method.returnType = fragment.name;
                    isConstructor = true;
                } else if (!method.argumentsNames.contains(instanceName)) {
                    method.argumentsNames.add(0, instanceName);
                    method.argumentsTypes.add(0, fragment.name);
                }
                if (!currentMethod.name.startsWith(fragment.name + this.structOwnerMethodSeparator)) {
                    currentMethod.name = fragment.name + this.structOwnerMethodSeparator + currentMethod.name;
                }
                String key = this.toGLSL(currentMethod.owner) + "." + oldName;
                this.methodReplacements.put(key, currentMethod.name);
                if (DEBUG && fragment1.getClass() == StartOfMethodFragment.class) {
                    System.out.println("GLSLEncoder > Mapped " + key + " to " + currentMethod.name);
                }
            }
            if (fragment1 instanceof LoadVariableFragment) {
                var = (LoadVariableFragment)fragment1;
                var.variableName = currentMethod.varNameMap.get(var.variableIndex);
            } else if (fragment1 instanceof StoreVariableFragment) {
                var = (StoreVariableFragment)fragment1;
                ((StoreVariableFragment)var).variableName = currentMethod.varNameMap.get(((StoreVariableFragment)var).variableIndex);
            }
            if (!this.waiting.isEmpty()) {
                this.handleCodeFragment(this.waiting.pop(), index, in, out);
            }
            boolean bl2 = this.allowedToPrint = !fragment1.forbiddenToPrint;
            if (fragment1.getClass() == EndOfMethodFragment.class && currentMethod.name.equals(fragment.name + this.structOwnerMethodSeparator + "new")) {
                this.println(this.getIndent() + "return " + instanceName + ";");
            }
            this.handleCodeFragment(fragment1, i, fragment.getChildren(), out);
            if (fragment1.getClass() != StartOfMethodFragment.class || !currentMethod.name.equals(fragment.name + this.structOwnerMethodSeparator + "new")) continue;
            this.println(this.getIndent() + fragment.name + this.space + instanceName + ";");
        }
    }

    private void handleDuplicateFragment(DuplicateFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        if (!this.newInstances.isEmpty()) {
            return;
        }
        if (fragment.wait > 0) {
            this.waiting.add(fragment);
            --fragment.wait;
        } else {
            String a = this.stack.pop();
            this.stack.push(a);
            this.stack.push(a);
        }
    }

    private void interpret(List<CodeFragment> in) {
        Stack<String> copy = this.stack;
        Stack tmpstack = new Stack();
        this.stack = tmpstack;
        StartOfMethodFragment currentMethod = null;
        PrintWriter nullPrinter = new PrintWriter(new StringWriter());
        for (int i = 0; i < in.size(); ++i) {
            CodeFragment fragment;
            boolean dontHandle;
            block6: {
                CodeFragment storeFrag;
                block8: {
                    block7: {
                        block5: {
                            dontHandle = false;
                            fragment = in.get(i);
                            if (fragment.getClass() != StartOfMethodFragment.class) break block5;
                            currentMethod = (StartOfMethodFragment)fragment;
                            break block6;
                        }
                        if (fragment.getClass() != FieldFragment.class) break block7;
                        FieldFragment fieldFrag = (FieldFragment)fragment;
                        if (!this.hasStructAttached(fieldFrag.type) || this.loadedStructs.contains(this.toGLSL(fieldFrag.type))) break block6;
                        this.loadedStructs.add(this.toGLSL(fieldFrag.type));
                        StructFragment struct = new StructFragment();
                        struct.name = this.conversionsToStructs.get(fieldFrag.type);
                        HashMap fields = new HashMap();
                        struct.fields = fields;
                        this.currentRequestType = 1;
                        this.requestData = struct;
                        String s = "/" + fieldFrag.type.replace(".", "/") + ".class";
                        this.context.requestAnalysisForEncoder(GLSLEncoder.class.getResourceAsStream(s));
                        in.add(i, struct);
                        this.currentRequestType = 0;
                        --i;
                        break block6;
                    }
                    if (fragment.getClass() != StoreVariableFragment.class) break block8;
                    storeFrag = (StoreVariableFragment)fragment;
                    String type = storeFrag.variableType;
                    if (!this.hasStructAttached(type) || this.loadedStructs.contains(this.toGLSL(type))) break block6;
                    this.loadedStructs.add(this.toGLSL(type));
                    StructFragment struct = new StructFragment();
                    struct.name = this.conversionsToStructs.get(type);
                    HashMap fields = new HashMap();
                    struct.fields = fields;
                    this.currentRequestType = 1;
                    this.requestData = struct;
                    String s = "/" + type.replace(".", "/") + ".class";
                    this.context.requestAnalysisForEncoder(GLSLEncoder.class.getResourceAsStream(s));
                    in.add(i, struct);
                    this.currentRequestType = 0;
                    --i;
                    break block6;
                }
                if (fragment.getClass() == PutFieldFragment.class) {
                    storeFrag = (PutFieldFragment)fragment;
                    if (currentMethod != null && currentMethod.name.equals("<init>")) {
                        for (int ii = 0; ii < in.size(); ++ii) {
                            CodeFragment fragment1 = in.get(ii);
                            if (fragment1.getClass() != FieldFragment.class) continue;
                            FieldFragment fieldFrag = (FieldFragment)fragment1;
                            if (!fieldFrag.name.equals(((PutFieldFragment)storeFrag).fieldName) || !fieldFrag.type.equals(((PutFieldFragment)storeFrag).fieldType) || fieldFrag.access.isFinal() && fieldFrag.initialValue != null) continue;
                            fieldFrag.initialValue = this.stack.peek();
                            dontHandle = true;
                            ((PutFieldFragment)storeFrag).forbiddenToPrint = true;
                            break;
                        }
                    }
                }
            }
            if (dontHandle) continue;
            this.output = nullPrinter;
            boolean bl = this.allowedToPrint = !fragment.forbiddenToPrint;
            if (!this.waiting.isEmpty()) {
                this.handleCodeFragment(this.waiting.pop(), i, in, nullPrinter);
            }
            this.handleCodeFragment(fragment, i, in, nullPrinter);
        }
        this.waiting.clear();
        this.currentLine = 0;
        this.indentation = 0;
        this.initialized.clear();
        this.name2type.clear();
        this.currentClass = null;
        this.typesStack.clear();
        this.extensions.clear();
        this.constants.clear();
        this.stack = copy;
    }

    private void println() {
        this.println("");
    }

    private void println(String s) {
        if (this.allowedToPrint) {
            this.output.println(s);
        }
    }

    private void handleReturnFragment(ReturnFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        if (in.size() > index + 1 && in.get(index + 1).getClass() != EndOfMethodFragment.class) {
            this.println(this.getIndent() + "return;" + this.getEndOfLine(this.currentLine));
        }
    }

    private void handlePopFragment(PopFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        this.println(this.getIndent() + this.stack.pop() + ";" + this.getEndOfLine(this.currentLine));
    }

    private int countChar(String str, char c) {
        int nbr = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            ++nbr;
        }
        return nbr;
    }

    private void handleIfNotStatementFragment(IfNotStatementFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String condition = this.stack.pop();
        this.println(this.getIndent() + "if(!" + condition + ")" + this.getEndOfLine(this.currentLine));
        this.println(this.getIndent() + "{");
        ++this.indentation;
    }

    private void handleXorFragment(XorFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String b = this.stack.pop();
        String a = this.stack.pop();
        this.stack.push("(" + a + " || " + b + ")");
    }

    private void handleOrFragment(OrFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String b = this.stack.pop();
        String a = this.stack.pop();
        this.stack.push("(" + a + this.space + (fragment.isDouble ? "||" : "|") + this.space + b + ")");
    }

    private void handleAndFragment(AndFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String b = this.stack.pop();
        String a = this.stack.pop();
        this.stack.push("(" + a + this.space + (fragment.isDouble ? "&&" : "&") + this.space + b + ")");
    }

    private void handleRightShiftFragment(RightShiftFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String b = this.stack.pop();
        String a = this.stack.pop();
        this.stack.push(a + ">>" + (!fragment.signed ? ">" : "") + b);
    }

    private void handleLeftShiftFragment(LeftShiftFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String b = this.stack.pop();
        String a = this.stack.pop();
        this.stack.push(a + "<<" + (!fragment.signed ? "<" : "") + b);
    }

    private void handleCastFragment(CastFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String toCast;
        String withoutPreviousCast = toCast = this.stack.pop();
        String previousType = null;
        previousType = withoutPreviousCast.startsWith("(") ? withoutPreviousCast.substring(1, withoutPreviousCast.indexOf(")") - 1) : this.toGLSL(this.currentMethod.varName2TypeMap.get(withoutPreviousCast));
        if (previousType.equals(this.toGLSL(fragment.to))) {
            if (DEBUG) {
                System.out.println("GLSLEncoder > Cancelling cast for " + toCast);
            }
            this.stack.push(withoutPreviousCast);
        } else {
            this.stack.push("(" + this.toGLSL(fragment.to) + ")" + toCast);
        }
    }

    private void handleModFragment(ModFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String a = this.stack.pop();
        String b = this.stack.pop();
        this.stack.push("mod(" + b + ", " + a + ")");
    }

    private void handleMethodCallFragment(MethodCallFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String key;
        String s = "";
        String n = fragment.methodName;
        String translatedOwner = this.toGLSL(fragment.methodOwner);
        boolean isConstructor = false;
        if (n.equals("<init>")) {
            n = translatedOwner;
            isConstructor = true;
            if (!this.newInstances.isEmpty()) {
                this.newInstances.pop();
            }
        }
        if (this.methodReplacements.containsKey(key = translatedOwner != null && !translatedOwner.equals("null") && !translatedOwner.trim().equals("") ? translatedOwner + "." + fragment.methodName : fragment.methodName)) {
            String nold = key;
            n = this.methodReplacements.get(key);
            if (DEBUG) {
                System.out.println("GLSLEncoder > Replacing " + nold + " by " + n);
            }
        }
        if (fragment.invokeType == MethodCallFragment.InvokeTypes.SPECIAL && this.currentMethod.name.equals("<init>") && fragment.methodOwner.equals(this.currentClass.superclass)) {
            this.allowedToPrint = false;
        }
        s = s + n + "(";
        ArrayList<String> args = new ArrayList<String>();
        for (String type : fragment.argumentsTypes) {
            String arg = this.stack.pop();
            if (arg.startsWith("(") && arg.endsWith(")") && this.countChar(arg, '(') == this.countChar(arg, ')')) {
                arg = arg.substring(1, arg.length() - 1);
            }
            args.add(arg);
        }
        String argsStr = "";
        for (int i = 0; i < args.size(); ++i) {
            if (i != 0) {
                argsStr = argsStr + ", ";
            }
            argsStr = argsStr + (String)args.get(args.size() - 1 - i);
        }
        s = s + argsStr;
        s = s + ")";
        boolean ownerBefore = false;
        boolean parenthesis = true;
        int ownerPosition = 0;
        boolean actsAsField = false;
        for (CodeFragment child : fragment.getChildren()) {
            if (child.getClass() != AnnotationFragment.class) continue;
            AnnotationFragment annot = (AnnotationFragment)child;
            if (!annot.name.equals(GLSL.Substitute.class.getCanonicalName())) continue;
            if (!annot.values.get("value").equals("$")) {
                n = (String)annot.values.get("value");
            }
            if (annot.values.containsKey("ownerBefore")) {
                ownerBefore = (Boolean)annot.values.get("ownerBefore");
            }
            if (annot.values.containsKey("ownerPosition")) {
                ownerPosition = (Integer)annot.values.get("ownerPosition");
            }
            if (annot.values.containsKey("actsAsField")) {
                actsAsField = (Boolean)annot.values.get("actsAsField");
            }
            if (!annot.values.containsKey("usesParenthesis")) continue;
            parenthesis = (Boolean)annot.values.get("usesParenthesis");
        }
        if (fragment.invokeType == MethodCallFragment.InvokeTypes.VIRTUAL) {
            String owner = this.stack.pop();
            if (owner.equals(this.currentClass.className) || owner.equals("this")) {
                owner = null;
            } else if (owner.startsWith("(") && owner.endsWith(")") && this.countChar(owner, '(') == this.countChar(owner, ')')) {
                owner = owner.substring(1, owner.length() - 1);
            }
            if (!ownerBefore) {
                if (actsAsField) {
                    if (n.length() >= 1) {
                        s = (owner != null ? owner : "") + "." + n;
                    } else {
                        String string = s = owner != null ? owner : "";
                    }
                    if (argsStr.length() > 0) {
                        s = s + " = " + argsStr;
                    }
                } else {
                    s = n + (parenthesis ? "(" : "") + (owner != null ? owner + (argsStr.length() > 0 ? ", " : "") : "") + argsStr + (parenthesis ? ")" : "");
                }
            } else {
                s = (owner != null ? owner : "") + n + (parenthesis ? "(" : "") + argsStr + (parenthesis ? ")" : "");
            }
            if (fragment.returnType.equals("void")) {
                this.println(this.getIndent() + s + ";" + this.getEndOfLine(this.currentLine));
            } else {
                this.stack.push("(" + s + ")");
            }
        } else if (fragment.invokeType == MethodCallFragment.InvokeTypes.STATIC) {
            String ownership = "";
            String owner = this.toGLSL(fragment.methodOwner);
            if (owner != null && !owner.trim().equals("") && !owner.equals("null")) {
                ownership = owner + (n.length() > 0 ? "." : "");
            }
            this.stack.push(ownership + n + (parenthesis ? "(" : "") + argsStr + (parenthesis ? ")" : ""));
        } else {
            this.stack.push(n + (parenthesis ? "(" : "") + argsStr + (parenthesis ? ")" : ""));
        }
    }

    private void handleElseStatementFragment(ElseStatementFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        this.println(this.getIndent() + "else" + this.getEndOfLine(this.currentLine));
        this.println(this.getIndent() + "{");
        ++this.indentation;
    }

    private void handleEndOfBlockFragment(EndOfBlockFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        --this.indentation;
        this.println(this.getIndent() + "}");
    }

    private void handleIfStatementFragment(IfStatementFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String condition = this.stack.pop();
        this.println(this.getIndent() + "if(" + condition + ")" + this.getEndOfLine(this.currentLine));
        this.println(this.getIndent() + "{");
        ++this.indentation;
    }

    private void handleArrayStoreFragment(ArrayStoreFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String result = "";
        String toAdd = "";
        for (int i = 0; i < 2; ++i) {
            String lastType;
            String copy = lastType = this.typesStack.pop();
            int dimensions = 0;
            if (copy != null) {
                while (copy.indexOf("[]") >= 0) {
                    copy = copy.substring(copy.indexOf("[]") + 2);
                    ++dimensions;
                }
            }
            String val = this.stack.pop();
            String arrayIndex = "";
            for (int dim = 0; dim < dimensions; ++dim) {
                arrayIndex = "[" + this.stack.pop() + "]" + arrayIndex;
            }
            String name = this.stack.pop();
            if (i == 1) {
                result = val + toAdd + " = " + result;
                continue;
            }
            if (i != 0) continue;
            result = val + result;
            toAdd = "[" + name + "]";
        }
        this.println(this.getIndent() + result + ";" + this.getEndOfLine(this.currentLine));
    }

    private void handleArrayOfArrayLoadFragment(ArrayOfArrayLoadFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String value = this.stack.pop();
        String name = this.stack.pop();
        this.stack.push(name + "[" + value + "]");
        if (this.name2type.containsKey(name + "[" + value + "]")) {
            this.name2type.put(name + "[" + value + "]", name.substring(0, name.indexOf("[")));
        }
        this.typesStack.push(this.name2type.get(name + "[" + value + "]"));
    }

    private void handleDivFragment(DivFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String a = this.stack.pop();
        String b = this.stack.pop();
        this.stack.push(b + "/" + a);
    }

    private void handleMulFragment(MulFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String a = this.stack.pop();
        String b = this.stack.pop();
        this.stack.push(b + "*" + a);
    }

    private void handleSubFragment(SubFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String a = this.stack.pop();
        String b = this.stack.pop();
        this.stack.push(b + "-" + a);
    }

    private void handleAddFragment(AddFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String a = this.stack.pop();
        String b = this.stack.pop();
        this.stack.push(b + "+" + a);
    }

    private void handleReturnValueFragment(ReturnValueFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        this.println(this.getIndent() + "return" + this.space + this.stack.pop() + ";" + this.getEndOfLine(this.currentLine));
    }

    private void handleLoadConstantFragment(LoadConstantFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        this.stack.push(fragment.value + "");
    }

    private void handleLdcFragment(LdcFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        if (this.constants.containsKey(fragment.value)) {
            this.stack.push("" + this.constants.get(fragment.value));
        } else if (fragment.value instanceof String) {
            this.stack.push("\"" + fragment.value + "\"");
        } else if (fragment.value instanceof Number) {
            this.stack.push("" + fragment.value);
        } else if (DEBUG) {
            System.out.println("GLSLEncoder > Invalid value: " + fragment.value + " of type " + fragment.value.getClass().getCanonicalName());
        }
    }

    private void handleStoreVariableFragment(StoreVariableFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String value = this.stack.pop();
        if (value.startsWith("(") && value.endsWith(")") && this.countChar(value, '(') == this.countChar(value, ')')) {
            value = value.substring(1, value.length() - 1);
        }
        if (value.equals(fragment.variableName + "+1")) {
            this.println(this.getIndent() + fragment.variableName + "++;" + this.getEndOfLine(this.currentLine));
            return;
        }
        if (value.equals(fragment.variableName + "-1")) {
            this.println(this.getIndent() + fragment.variableName + "--;" + this.getEndOfLine(this.currentLine));
            return;
        }
        String glslType = this.toGLSL(this.currentMethod.varName2TypeMap.get(fragment.variableName));
        if (glslType.equals("bool")) {
            if (value.equals("0")) {
                value = "false";
            } else if (value.equals("1")) {
                value = "true";
            }
        } else if (glslType.equals("char") && this.convertNumbersToChars) {
            try {
                value = "'" + Character.valueOf((char)Integer.parseInt(value)) + "'";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.initialized.contains(fragment.variableName)) {
            this.println(this.getIndent() + fragment.variableName + " = " + value + ";" + this.getEndOfLine(this.currentLine));
        } else {
            this.initialized.add(fragment.variableName);
            this.println(this.getIndent() + this.toGLSL(this.currentMethod.varName2TypeMap.get(fragment.variableName)) + this.space + fragment.variableName + " = " + value + ";" + this.getEndOfLine(this.currentLine));
        }
    }

    private void handleLoadVariableFragment(LoadVariableFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        this.stack.push(fragment.variableName);
    }

    private void handleNewPrimitiveArrayFragment(NewPrimitiveArrayFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String dimension = "[" + this.stack.pop() + "]";
        this.stack.push(fragment.type + dimension);
    }

    private void handleBiPushFragment(IntPushFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        this.stack.push(fragment.value + "");
    }

    private void handleGetFieldFragment(GetFieldFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String owner = this.toGLSL(this.stack.pop());
        String ownership = owner + ".";
        if (owner.equals("this")) {
            ownership = "";
        }
        this.stack.push(ownership + fragment.fieldName);
        this.typesStack.push(fragment.fieldType);
    }

    private void handlePutFieldFragment(PutFieldFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String value = this.stack.pop();
        if (value.startsWith("(") && value.endsWith(")") && this.countChar(value, '(') == this.countChar(value, ')')) {
            value = value.substring(1, value.length() - 1);
        }
        if (value.equals(fragment.fieldName + "+1")) {
            this.println(this.getIndent() + fragment.fieldName + "++;" + this.getEndOfLine(this.currentLine));
            return;
        }
        if (value.equals(fragment.fieldName + "-1")) {
            this.println(this.getIndent() + fragment.fieldName + "--;" + this.getEndOfLine(this.currentLine));
            return;
        }
        String glslType = this.toGLSL(this.currentMethod.varName2TypeMap.get(fragment.fieldName));
        if (glslType.equals("bool")) {
            if (value.equals("0")) {
                value = "false";
            } else if (value.equals("1")) {
                value = "true";
            }
        }
        String owner = this.stack.pop();
        String ownership = owner + ".";
        for (int i = 0; i < index; ++i) {
            CodeFragment frag = in.get(i);
            if (frag.getClass() != FieldFragment.class) continue;
            FieldFragment fieldFrag = (FieldFragment)frag;
            if (!fieldFrag.access.isFinal() || !fieldFrag.name.equals(fragment.fieldName)) continue;
            return;
        }
        if (owner.equals("this")) {
            ownership = "";
        }
        this.println(this.getIndent() + ownership + fragment.fieldName + this.space + "=" + this.space + value + ";" + this.getEndOfLine(this.currentLine));
    }

    private void handleNewMultiArrayFragment(NewMultiArrayFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        int dim;
        String s = "";
        ArrayList<String> list = new ArrayList<String>();
        for (dim = 0; dim < fragment.dimensions; ++dim) {
            list.add(this.stack.pop());
        }
        for (dim = 0; dim < fragment.dimensions; ++dim) {
            s = s + "[" + (String)list.get(list.size() - dim - 1) + "]";
        }
        this.stack.push(this.toGLSL(fragment.type) + s);
    }

    private void handleNewArrayFragment(NewArrayFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String s = "[" + this.stack.pop() + "]";
        this.stack.push(this.toGLSL(fragment.type) + s);
    }

    private void handleEndOfMethodFragment(EndOfMethodFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        if (fragment.name.equals("<init>")) {
            return;
        }
        this.println("}");
        --this.indentation;
    }

    private void handleStartOfMethodFragment(StartOfMethodFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        if (fragment.name.equals("<init>")) {
            return;
        }
        this.initialized.clear();
        this.println();
        String args = "";
        for (int i = 0; i < fragment.argumentsNames.size(); ++i) {
            String s = this.toGLSL(fragment.argumentsTypes.get(i)) + this.space + fragment.argumentsNames.get(i);
            if (i != 0) {
                args = args + ", ";
            }
            args = args + s;
        }
        this.println(this.toGLSL(fragment.returnType) + this.space + fragment.name + "(" + args + ")\n{");
        ++this.indentation;
    }

    private void handleFieldFragment(FieldFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        String allStorageQualifiers;
        String storageQualifier = null;
        String auxiliaryStorageQualifier = null;
        for (CodeFragment child : fragment.getChildren()) {
            if (!(child instanceof AnnotationFragment)) continue;
            AnnotationFragment annot = (AnnotationFragment)child;
            if (annot.name.equals(GLSL.Uniform.class.getCanonicalName())) {
                GLSLEncoder.enforceCompatibleAnnotations(storageQualifier, "uniform");
                storageQualifier = "uniform";
                continue;
            }
            if (annot.name.equals(GLSL.Attribute.class.getCanonicalName())) {
                GLSLEncoder.enforceCompatibleAnnotations(storageQualifier, "attribute");
                storageQualifier = "attribute";
                if (!this.currentClass.superclass.equals(FragmentShader.class.getCanonicalName())) continue;
                throw new JLSLException("Attributes are not allowed in fragment shaders");
            }
            if (annot.name.equals(GLSL.In.class.getCanonicalName())) {
                GLSLEncoder.enforceCompatibleAnnotations(storageQualifier, "in");
                storageQualifier = "in";
                continue;
            }
            if (annot.name.equals(GLSL.Out.class.getCanonicalName())) {
                GLSLEncoder.enforceCompatibleAnnotations(storageQualifier, "out");
                storageQualifier = "out";
                continue;
            }
            if (annot.name.equals(GLSL.Varying.class.getCanonicalName())) {
                GLSLEncoder.enforceCompatibleAnnotations(storageQualifier, "varying");
                storageQualifier = "varying";
                continue;
            }
            if (annot.name.equals(GLSL.Flat.class.getCanonicalName())) {
                GLSLEncoder.enforceCompatibleAnnotations(auxiliaryStorageQualifier, "flat");
                auxiliaryStorageQualifier = "flat";
                continue;
            }
            if (!annot.name.equals(GLSL.Layout.class.getCanonicalName())) continue;
            int location = (Integer)annot.values.get("location");
            if (this.glslversion <= 430 && !this.extensions.contains("GL_ARB_explicit_uniform_location")) continue;
            out.print("layout(location = " + location + ") ");
        }
        if (storageQualifier == null) {
            storageQualifier = "uniform";
        }
        String string = allStorageQualifiers = auxiliaryStorageQualifier == null ? storageQualifier : auxiliaryStorageQualifier + this.space + storageQualifier;
        if (fragment.access.isFinal()) {
            if (fragment.access.isStatic()) {
                this.println("#define" + this.space + fragment.name + this.space + fragment.initialValue);
                this.constants.put(fragment.initialValue, fragment.name);
            } else {
                this.println("const" + this.space + this.toGLSL(fragment.type) + this.space + fragment.name + this.space + "=" + this.space + fragment.initialValue + ";");
                this.constants.put(fragment.initialValue, fragment.name);
            }
        } else if (fragment.initialValue != null) {
            this.println(allStorageQualifiers + this.space + this.toGLSL(fragment.type) + this.space + fragment.name + this.space + "=" + this.space + fragment.initialValue + ";");
        } else {
            this.println(allStorageQualifiers + this.space + this.toGLSL(fragment.type) + this.space + fragment.name + ";");
        }
    }

    private void handleClassFragment(NewClassFragment fragment, List<CodeFragment> in, int index, PrintWriter out) {
        this.println("// Original class name: " + fragment.className + " compiled from " + fragment.sourceFile + " and of version " + fragment.classVersion);
        for (CodeFragment child : fragment.getChildren()) {
            if (!(child instanceof AnnotationFragment)) continue;
            AnnotationFragment annotFragment = (AnnotationFragment)child;
            this.println();
            if (!annotFragment.name.equals(GLSL.Extensions.class.getCanonicalName())) continue;
            ArrayList values = (ArrayList)annotFragment.values.get("value");
            for (String extension : values) {
                this.println("#extension " + extension + " : enable" + this.getEndOfLine(this.currentLine));
            }
        }
    }

    private String getIndent() {
        String s = "";
        for (int i = 0; i < this.indentation; ++i) {
            s = s + this.tab;
        }
        return s;
    }
}

