/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.jlsl.conversion.glslbytecode;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.jlsl.conversion.IndentedStringWriter;

public class GLSLBytecode {
    public static final Type INT = new Type("int");
    public static final Type FLOAT = new Type("float");
    public static final Type BOOL = new Type("bool");

    public record Type(String name) implements Node
    {
        public static final Type VOID = new Type("void");
        public static final Type INT = new Type("int");
        public static final Type LONG = new Type("long");
        public static final Type FLOAT = new Type("float");
        public static final Type DOUBLE = new Type("double");

        @Override
        public void generateSource(@NotNull IndentedStringWriter writer) {
            writer.write(this.name);
        }
    }

    public static interface TopLevelNode
    extends Node {
    }

    public static interface Comment
    extends Statement {

        public record Block(@NotNull String comment) implements Comment
        {
            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                writer.write("/* ");
                writer.write(this.comment);
                writer.write(" */");
            }
        }

        public record Line(@NotNull String comment) implements Comment
        {
            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                writer.write("// ");
                writer.write(this.comment);
                writer.newLine();
            }
        }
    }

    public static interface Value
    extends Node {
        @NotNull
        default public Reference.Index index(@NotNull String index) {
            return new Reference.Index(this, index);
        }

        public static interface Reference
        extends Value {

            public record Index(@NotNull Value previous, @NotNull String index) implements Reference
            {
                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.previous.generateSource(writer);
                    writer.write(".");
                    writer.write(this.index);
                }
            }

            public record Variable(@NotNull String reference) implements Reference
            {
                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    writer.write(this.reference);
                }
            }
        }

        public record MethodCall(@Nullable Value callingField, boolean listened, @NotNull List<? extends Value> parameters) implements Value,
        Statement
        {
            public MethodCall(@Nullable Value callingField, boolean listened, Value ... parameters) {
                this(callingField, listened, List.of(parameters));
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                if (this.callingField != null) {
                    this.callingField.generateSource(writer);
                }
                writer.write("(");
                for (int i = 0; i < this.parameters.size(); ++i) {
                    if (i > 0) {
                        writer.write(", ");
                    }
                    this.parameters.get(i).generateSource(writer);
                }
                writer.write(")");
                if (!this.listened) {
                    writer.write(";");
                    writer.newLine();
                }
            }
        }

        public record Constant(@NotNull String value, boolean quotations) implements Value
        {
            public static final Constant Null = new Constant("null", false);

            public Constant(@NotNull String value) {
                this(value, true);
            }

            public Constant(int value) {
                this(Integer.toString(value), false);
            }

            public Constant(@NotNull Object object) {
                this(Objects.toString(object), false);
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                if (this.quotations) {
                    writer.write("\"");
                    writer.write(this.value);
                    writer.write("\"");
                } else {
                    writer.write(this.value);
                }
            }
        }
    }

    public static interface Statement
    extends Node {

        public record Return(@Nullable Value value) implements Statement
        {
            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                writer.write("return");
                if (this.value != null) {
                    writer.write(" ");
                    this.value.generateSource(writer);
                }
                writer.write(";");
                writer.newLine();
            }
        }

        public record UpdateVariable(@NotNull Value.Reference reference, @NotNull Value value) implements Statement
        {
            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                this.reference.generateSource(writer);
                writer.write(" = ");
                this.value.generateSource(writer);
                writer.write(";");
                writer.newLine();
            }
        }

        public record DeclareVariable(@NotNull Type type, @NotNull String name, @Nullable Value value) implements Statement
        {
            public DeclareVariable(@NotNull Type type, @NotNull String name) {
                this(type, name, null);
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                this.type.generateSource(writer);
                writer.write(" ");
                writer.write(this.name);
                if (this.value != null) {
                    writer.write(" = ");
                    this.value.generateSource(writer);
                }
                writer.write(";");
                writer.newLine();
            }
        }

        public record If(@NotNull Condition condition, @NotNull Body body, @Nullable Body elseBody) implements Statement
        {
            public If(@NotNull Condition condition, @NotNull Body body) {
                this(condition, body, null);
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                writer.write("if (");
                this.condition.generateSource(writer);
                writer.write(") {");
                writer.indent();
                writer.newLine();
                this.body.generateSource(writer);
                writer.unindent();
                if (this.elseBody == null) {
                    writer.write("}");
                } else {
                    writer.write("} else {");
                    writer.indent();
                    writer.newLine();
                    this.elseBody.generateSource(writer);
                    writer.unindent();
                    writer.write("}");
                }
                writer.newLine();
            }
        }

        public static interface Condition
        extends Statement {

            public record LessThanOrEqualTo(@NotNull Value left, @NotNull Value right) implements Condition
            {
                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.left.generateSource(writer);
                    writer.write(" <= ");
                    this.right.generateSource(writer);
                }
            }

            public record LessThan(@NotNull Value leftValue, @NotNull Value rightValue) implements Condition
            {
                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.leftValue.generateSource(writer);
                    writer.write(" < ");
                    this.rightValue.generateSource(writer);
                }
            }

            public record GreaterThanOrEqualTo(@NotNull Value left, @NotNull Value right) implements Condition
            {
                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.left.generateSource(writer);
                    writer.write(" >= ");
                    this.right.generateSource(writer);
                }
            }

            public record GreaterThan(@NotNull Value leftValue, @NotNull Value rightValue) implements Condition
            {
                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.leftValue.generateSource(writer);
                    writer.write(" > ");
                    this.rightValue.generateSource(writer);
                }
            }

            public record Or(@NotNull Condition left, @NotNull Condition right) implements Condition
            {
                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    writer.write("(");
                    this.left.generateSource(writer);
                    writer.write(" || ");
                    this.right.generateSource(writer);
                    writer.write(")");
                }
            }

            public record And(@NotNull Condition left, @NotNull Condition right) implements Condition
            {
                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.left.generateSource(writer);
                    writer.write(" && ");
                    this.right.generateSource(writer);
                }
            }

            public record NotEqualTo(@NotNull Value left, @NotNull Value right) implements Condition
            {
                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.left.generateSource(writer);
                    writer.write(" != ");
                    this.right.generateSource(writer);
                }
            }

            public record Not(@NotNull Condition condition) implements Condition
            {
                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    writer.write("!(");
                    this.condition.generateSource(writer);
                    writer.write(")");
                }
            }

            public record EqualTo(@NotNull Value left, @NotNull Value right) implements Condition
            {
                @Override
                public void generateSource(@NotNull IndentedStringWriter writer) {
                    this.left.generateSource(writer);
                    writer.write(" == ");
                    this.right.generateSource(writer);
                }
            }
        }
    }

    public record Body(@NotNull @NotNull List<@NotNull Statement> statements) implements Node
    {
        public Body(Statement ... statements) {
            this(List.of(statements));
        }

        @Override
        public void generateSource(@NotNull IndentedStringWriter writer) {
            for (Statement statement : this.statements) {
                statement.generateSource(writer);
            }
        }
    }

    public record Method(@NotNull Type returnType, @NotNull String name, @NotNull @NotNull List<@NotNull Parameter> parameters, @NotNull Body body) implements TopLevelNode
    {
        @Override
        public void generateSource(@NotNull IndentedStringWriter writer) {
            this.returnType.generateSource(writer);
            writer.write(" ");
            writer.write(this.name);
            writer.write("(");
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                }
                this.parameters.get(i).generateSource(writer);
            }
            writer.write(") {");
            writer.indent();
            writer.newLine();
            this.body.generateSource(writer);
            writer.unindent();
            writer.write("}");
            writer.newLine();
        }

        public record Parameter(@NotNull Type type, @NotNull String name) implements Node
        {
            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                this.type.generateSource(writer);
                writer.write(" ");
                writer.write(this.name);
            }
        }
    }

    public record Field(@Nullable Type fieldType, @NotNull String name, @NotNull org.jglrxavpok.jlsl.conversion.glslbytecode.GLSLBytecode$Type valueType) implements TopLevelNode
    {
        @Override
        public void generateSource(@NotNull IndentedStringWriter writer) {
            if (this.fieldType != null) {
                this.fieldType.generateSource(writer);
                writer.write(" ");
            }
            this.valueType.generateSource(writer);
            writer.write(" ");
            writer.write(this.name);
            writer.write(";\n");
        }

        public static enum Type implements Node
        {
            UNIFORM("uniform"),
            IN("in"),
            OUT("out");

            private final String display;

            private Type(String display) {
                this.display = display;
            }

            @Override
            public void generateSource(@NotNull IndentedStringWriter writer) {
                writer.write(this.display);
            }
        }
    }

    public record Root(int version, @NotNull @NotNull List<? extends @NotNull TopLevelNode> nodes) implements Node
    {
        public Root(int version, TopLevelNode ... nodes) {
            this(version, List.of(nodes));
        }

        public Root(int version, Collection<? extends TopLevelNode> ... nodeCollections) {
            this(version, Stream.of(nodeCollections).flatMap(Collection::stream).toList());
        }

        @Override
        public void generateSource(@NotNull IndentedStringWriter writer) {
            writer.write("#version " + this.version + " core\n");
            writer.write("// Generated by JLSL\n");
            writer.write("\n");
            for (TopLevelNode topLevelNode : this.nodes) {
                topLevelNode.generateSource(writer);
            }
        }
    }

    public static interface Node {
        public void generateSource(@NotNull IndentedStringWriter var1);

        @NotNull
        default public String generateSource(@NotNull String indent) {
            IndentedStringWriter writer = new IndentedStringWriter(indent);
            this.generateSource(writer);
            return writer.toString();
        }
    }
}

