/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.jlsl;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OpcodeUtils {
    private static final Map<Integer, String> opcodeNames = new HashMap<Integer, String>();

    @NotNull
    public static String name(int opcode) {
        return opcodeNames.get(opcode);
    }

    static {
        opcodeNames.put(0, "NOP");
        opcodeNames.put(1, "ACONST_NULL");
        opcodeNames.put(2, "ICONST_M1");
        opcodeNames.put(3, "ICONST_0");
        opcodeNames.put(4, "ICONST_1");
        opcodeNames.put(5, "ICONST_2");
        opcodeNames.put(6, "ICONST_3");
        opcodeNames.put(7, "ICONST_4");
        opcodeNames.put(8, "ICONST_5");
        opcodeNames.put(9, "LCONST_0");
        opcodeNames.put(10, "LCONST_1");
        opcodeNames.put(11, "FCONST_0");
        opcodeNames.put(12, "FCONST_1");
        opcodeNames.put(13, "FCONST_2");
        opcodeNames.put(14, "DCONST_0");
        opcodeNames.put(15, "DCONST_1");
        opcodeNames.put(16, "BIPUSH");
        opcodeNames.put(17, "SIPUSH");
        opcodeNames.put(18, "LDC");
        opcodeNames.put(21, "ILOAD");
        opcodeNames.put(22, "LLOAD");
        opcodeNames.put(23, "FLOAD");
        opcodeNames.put(24, "DLOAD");
        opcodeNames.put(25, "ALOAD");
        opcodeNames.put(46, "IALOAD");
        opcodeNames.put(47, "LALOAD");
        opcodeNames.put(48, "FALOAD");
        opcodeNames.put(49, "DALOAD");
        opcodeNames.put(50, "AALOAD");
        opcodeNames.put(51, "BALOAD");
        opcodeNames.put(52, "CALOAD");
        opcodeNames.put(53, "SALOAD");
        opcodeNames.put(54, "ISTORE");
        opcodeNames.put(55, "LSTORE");
        opcodeNames.put(56, "FSTORE");
        opcodeNames.put(57, "DSTORE");
        opcodeNames.put(58, "ASTORE");
        opcodeNames.put(79, "IASTORE");
        opcodeNames.put(80, "LASTORE");
        opcodeNames.put(81, "FASTORE");
        opcodeNames.put(82, "DASTORE");
        opcodeNames.put(83, "AASTORE");
        opcodeNames.put(84, "BASTORE");
        opcodeNames.put(85, "CASTORE");
        opcodeNames.put(86, "SASTORE");
        opcodeNames.put(87, "POP");
        opcodeNames.put(88, "POP2");
        opcodeNames.put(89, "DUP");
        opcodeNames.put(90, "DUP_X1");
        opcodeNames.put(91, "DUP_X2");
        opcodeNames.put(92, "DUP2");
        opcodeNames.put(93, "DUP2_X1");
        opcodeNames.put(94, "DUP2_X2");
        opcodeNames.put(95, "SWAP");
        opcodeNames.put(96, "IADD");
        opcodeNames.put(97, "LADD");
        opcodeNames.put(98, "FADD");
        opcodeNames.put(99, "DADD");
        opcodeNames.put(100, "ISUB");
        opcodeNames.put(101, "LSUB");
        opcodeNames.put(102, "FSUB");
        opcodeNames.put(103, "DSUB");
        opcodeNames.put(104, "IMUL");
        opcodeNames.put(105, "LMUL");
        opcodeNames.put(106, "FMUL");
        opcodeNames.put(107, "DMUL");
        opcodeNames.put(108, "IDIV");
        opcodeNames.put(109, "LDIV");
        opcodeNames.put(110, "FDIV");
        opcodeNames.put(111, "DDIV");
        opcodeNames.put(112, "IREM");
        opcodeNames.put(113, "LREM");
        opcodeNames.put(114, "FREM");
        opcodeNames.put(115, "DREM");
        opcodeNames.put(116, "INEG");
        opcodeNames.put(117, "LNEG");
        opcodeNames.put(118, "FNEG");
        opcodeNames.put(119, "DNEG");
        opcodeNames.put(120, "ISHL");
        opcodeNames.put(121, "LSHL");
        opcodeNames.put(122, "ISHR");
        opcodeNames.put(123, "LSHR");
        opcodeNames.put(124, "IUSHR");
        opcodeNames.put(125, "LUSHR");
        opcodeNames.put(126, "IAND");
        opcodeNames.put(127, "LAND");
        opcodeNames.put(128, "IOR");
        opcodeNames.put(129, "LOR");
        opcodeNames.put(130, "IXOR");
        opcodeNames.put(131, "LXOR");
        opcodeNames.put(132, "IINC");
        opcodeNames.put(133, "I2L");
        opcodeNames.put(134, "I2F");
        opcodeNames.put(135, "I2D");
        opcodeNames.put(136, "L2I");
        opcodeNames.put(137, "L2F");
        opcodeNames.put(138, "L2D");
        opcodeNames.put(139, "F2I");
        opcodeNames.put(140, "F2L");
        opcodeNames.put(141, "F2D");
        opcodeNames.put(142, "D2I");
        opcodeNames.put(143, "D2L");
        opcodeNames.put(144, "D2F");
        opcodeNames.put(145, "I2B");
        opcodeNames.put(146, "I2C");
        opcodeNames.put(147, "I2S");
        opcodeNames.put(148, "LCMP");
        opcodeNames.put(149, "FCMPL");
        opcodeNames.put(150, "FCMPG");
        opcodeNames.put(151, "DCMPL");
        opcodeNames.put(152, "DCMPG");
        opcodeNames.put(153, "IFEQ");
        opcodeNames.put(154, "IFNE");
        opcodeNames.put(155, "IFLT");
        opcodeNames.put(156, "IFGE");
        opcodeNames.put(157, "IFGT");
        opcodeNames.put(158, "IFLE");
        opcodeNames.put(159, "IF_ICMPEQ");
        opcodeNames.put(160, "IF_ICMPNE");
        opcodeNames.put(161, "IF_ICMPLT");
        opcodeNames.put(162, "IF_ICMPGE");
        opcodeNames.put(163, "IF_ICMPGT");
        opcodeNames.put(164, "IF_ICMPLE");
        opcodeNames.put(165, "IF_ACMPEQ");
        opcodeNames.put(166, "IF_ACMPNE");
        opcodeNames.put(167, "GOTO");
        opcodeNames.put(168, "JSR");
        opcodeNames.put(169, "RET");
        opcodeNames.put(170, "TABLESWITCH");
        opcodeNames.put(171, "LOOKUPSWITCH");
        opcodeNames.put(172, "IRETURN");
        opcodeNames.put(173, "LRETURN");
        opcodeNames.put(174, "FRETURN");
        opcodeNames.put(175, "DRETURN");
        opcodeNames.put(176, "ARETURN");
        opcodeNames.put(177, "RETURN");
        opcodeNames.put(178, "GETSTATIC");
        opcodeNames.put(179, "PUTSTATIC");
        opcodeNames.put(180, "GETFIELD");
        opcodeNames.put(181, "PUTFIELD");
        opcodeNames.put(182, "INVOKEVIRTUAL");
        opcodeNames.put(183, "INVOKESPECIAL");
        opcodeNames.put(184, "INVOKESTATIC");
        opcodeNames.put(185, "INVOKEINTERFACE");
        opcodeNames.put(186, "INVOKEDYNAMIC");
        opcodeNames.put(187, "NEW");
        opcodeNames.put(188, "NEWARRAY");
        opcodeNames.put(189, "ANEWARRAY");
        opcodeNames.put(190, "ARRAYLENGTH");
        opcodeNames.put(191, "ATHROW");
        opcodeNames.put(192, "CHECKCAST");
        opcodeNames.put(193, "INSTANCEOF");
        opcodeNames.put(194, "MONITORENTER");
        opcodeNames.put(195, "MONITOREXIT");
        opcodeNames.put(197, "MULTIANEWARRAY");
        opcodeNames.put(198, "IFNULL");
        opcodeNames.put(199, "IFNONNULL");
    }
}

