/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.jlsl.conversion;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.jlsl.OpcodeUtils;
import org.jglrxavpok.jlsl.Stacker;
import org.jglrxavpok.jlsl.conversion.ASMClassnode2GLSL;
import org.jglrxavpok.jlsl.conversion.JavaUtils;
import org.jglrxavpok.jlsl.conversion.glslbytecode.GLSLBytecode;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

class StatementGenerator {
    private final ASMClassnode2GLSL.Settings settings;
    private List<LocalVariableNode> locals;
    private Stacker<GLSLBytecode.Statement> stacker;
    private Deque<GLSLBytecode.Node> stack;
    private Queue<AbstractInsnNode> nodeQueue;
    private final Map<Object, Object> processors = new HashMap<Object, Object>();
    public static final /* synthetic */ String jvmdowngrader$nestMembers = "org/jglrxavpok/jlsl/conversion/StatementGenerator$Context";

    public StatementGenerator(@NotNull ASMClassnode2GLSL.Settings settings) {
        this.settings = settings;
        this.setup();
    }

    private void debug(Object text) {
        if (this.settings.debug()) {
            this.stacker.stack(new GLSLBytecode.Comment.Line(StatementGenerator.jvmdowngrader$concat(text)));
        }
    }

    @NotNull
    public List<GLSLBytecode.Statement> generate(@NotNull Context context) {
        MethodNode method = context.jvmdowngrader$nest$org_jglrxavpok_jlsl_conversion_StatementGenerator$Context$get$method();
        this.locals = method.localVariables;
        InsnList instructions = method.instructions;
        List nodes = Stream.of(instructions.toArray()).collect(Collectors.toCollection(ArrayList::new));
        ArrayList<GLSLBytecode.Statement> statements = new ArrayList<GLSLBytecode.Statement>();
        Stacker<GLSLBytecode.Statement> stacker = new Stacker<GLSLBytecode.Statement>(statements);
        ArrayDeque<GLSLBytecode.Node> stack = new ArrayDeque<GLSLBytecode.Node>();
        ArrayDeque<AbstractInsnNode> nodeQueue = new ArrayDeque<AbstractInsnNode>(nodes);
        this.stacker = stacker;
        this.stack = stack;
        this.nodeQueue = nodeQueue;
        while (!nodeQueue.isEmpty()) {
            this.process();
        }
        if (!stack.isEmpty()) {
            this.debug("Auxiliary stack has leftover components: ");
            ArrayList<GLSLBytecode.Node> leftover = new ArrayList<GLSLBytecode.Node>(stack);
            Collections.reverse(leftover);
            for (GLSLBytecode.Node node : leftover) {
                this.debug(StatementGenerator.jvmdowngrader$concat(node));
                if (!(node instanceof GLSLBytecode.Statement)) continue;
                GLSLBytecode.Statement statement = (GLSLBytecode.Statement)node;
                stacker.stack(statement);
            }
        }
        return statements;
    }

    private <N extends AbstractInsnNode> void registerProcessor(Class<N> key, Consumer<? super N> processor) {
        this.processors.put(key, processor);
    }

    private void process() {
        AbstractInsnNode current = this.nodeQueue.poll();
        Objects.requireNonNull(current);
        Class<?> clazz = current.getClass();
        Object processor = this.processors.get(clazz);
        this.debug(StatementGenerator.jvmdowngrader$concat(clazz.getSimpleName(), OpcodeUtils.name(current.getOpcode())));
        if (processor == null) {
            throw new IllegalArgumentException(StatementGenerator.jvmdowngrader$concat(clazz.getSimpleName()));
        }
        ((Consumer)processor).accept(current);
    }

    private void setup() {
        this.registerProcessor(LabelNode.class, this::processLabelNode);
        this.registerProcessor(LineNumberNode.class, this::processLineNumberNode);
        this.registerProcessor(VarInsnNode.class, this::processVarInsnNode);
        this.registerProcessor(FieldInsnNode.class, this::processFieldInsnNode);
        this.registerProcessor(MethodInsnNode.class, this::processMethodInsnNode);
        this.registerProcessor(LdcInsnNode.class, this::processLdcInsnNode);
        this.registerProcessor(InsnNode.class, this::processInsnNode);
        this.registerProcessor(JumpInsnNode.class, this::processJumpInsnNode);
        this.registerProcessor(FrameNode.class, this::processFrameNode);
    }

    private void processLabelNode(LabelNode node) {
    }

    private void processLineNumberNode(LineNumberNode node) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processVarInsnNode(VarInsnNode node) {
        int index = node.var;
        int opcode = node.getOpcode();
        LocalVariableNode local = this.locals.get(index);
        if (opcode == 58) {
            String type = JavaUtils.getTypeFromDescription(local.desc);
            GLSLBytecode.Node previous = this.stack.poll();
            Objects.requireNonNull(previous, "ASTORE without previous value");
            if (!(previous instanceof GLSLBytecode.Value)) throw new IllegalArgumentException("ASTORE without previous value");
            GLSLBytecode.Value value = (GLSLBytecode.Value)previous;
            this.stacker.stack(new GLSLBytecode.Statement.DeclareVariable(new GLSLBytecode.Type(type), local.name, value));
            return;
        } else {
            this.stack.push(new GLSLBytecode.Value.Reference.Variable(local.name));
        }
    }

    private void processFieldInsnNode(FieldInsnNode node) {
        int opcode = node.getOpcode();
        switch (opcode) {
            case 180: {
                GLSLBytecode.Node next = this.stack.poll();
                Objects.requireNonNull(next, "FieldInsnNode without a previous node");
                if (next instanceof GLSLBytecode.Value) {
                    GLSLBytecode.Value.Reference.Variable variable;
                    GLSLBytecode.Value value = (GLSLBytecode.Value)next;
                    value = this.settings.removeThisKeyword() && value instanceof GLSLBytecode.Value.Reference.Variable && (variable = (GLSLBytecode.Value.Reference.Variable)value).reference().equals("this") ? new GLSLBytecode.Value.Reference.Variable(node.name) : value.index(node.name);
                    this.stack.push(value);
                    break;
                }
                throw new IllegalStateException(StatementGenerator.jvmdowngrader$concat1(next));
            }
            case 181: {
                GLSLBytecode.Node assignment = this.stack.poll();
                GLSLBytecode.Node assignTo = this.stack.poll();
                Objects.requireNonNull(assignment, "FieldInsnNode without a previous node");
                Objects.requireNonNull(assignTo, "FieldInsnNode without a previous node");
                if (assignTo instanceof GLSLBytecode.Value.Reference) {
                    GLSLBytecode.Value.Reference reference = (GLSLBytecode.Value.Reference)assignTo;
                    if (assignment instanceof GLSLBytecode.Value) {
                        GLSLBytecode.Value value = (GLSLBytecode.Value)assignment;
                        this.stack.push(new GLSLBytecode.Statement.UpdateVariable(reference.index(node.name), value));
                        break;
                    }
                }
                throw new IllegalStateException("FieldInsnNode invalid state");
            }
        }
    }

    private void processMethodInsnNode(MethodInsnNode node) {
        int opcode = node.getOpcode();
        switch (opcode) {
            case 182: {
                J_L_Record previousValue;
                JavaUtils.MethodSignature signature = JavaUtils.toSignature(node.desc);
                ArrayList<GLSLBytecode.Value> parameters = new ArrayList<GLSLBytecode.Value>(signature.argTypes().size());
                for (int i = 0; i < signature.argTypes().size(); ++i) {
                    GLSLBytecode.Node prev = this.stack.pop();
                    if (!(prev instanceof GLSLBytecode.Value)) {
                        throw new IllegalStateException("MethodInsnNode invalid state");
                    }
                    GLSLBytecode.Value variable = (GLSLBytecode.Value)prev;
                    parameters.add(variable);
                }
                Collections.reverse(parameters);
                GLSLBytecode.Node prev = this.stack.peek();
                if (prev instanceof GLSLBytecode.Value) {
                    GLSLBytecode.Value.Reference.Variable variable;
                    GLSLBytecode.Value value = (GLSLBytecode.Value)prev;
                    this.stack.poll();
                    previousValue = this.settings.removeThisKeyword() && value instanceof GLSLBytecode.Value.Reference.Variable && (variable = (GLSLBytecode.Value.Reference.Variable)value).reference().equals("this") ? new GLSLBytecode.Value.Reference.Variable(node.name) : value.index(node.name);
                } else {
                    previousValue = new GLSLBytecode.Value.Reference.Variable(node.name);
                }
                boolean listenedTo = this.nodeQueue.peek() instanceof VarInsnNode || this.nodeQueue.peek() instanceof FieldInsnNode;
                this.stack.addFirst(new GLSLBytecode.Value.MethodCall((GLSLBytecode.Value)previousValue, listenedTo, parameters));
            }
        }
    }

    private void processLdcInsnNode(LdcInsnNode node) {
        this.stack.push(new GLSLBytecode.Value.Constant(node.cst));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processInsnNode(InsnNode node) {
        int opcode = node.getOpcode();
        switch (opcode) {
            case 14: {
                this.stack.push(new GLSLBytecode.Value.Constant(0.0));
                return;
            }
            case 15: {
                this.stack.push(new GLSLBytecode.Value.Constant(1.0));
                return;
            }
            case 11: {
                this.stack.push(new GLSLBytecode.Value.Constant(Float.valueOf(0.0f)));
                return;
            }
            case 12: {
                this.stack.push(new GLSLBytecode.Value.Constant(Float.valueOf(1.0f)));
                return;
            }
            case 13: {
                this.stack.push(new GLSLBytecode.Value.Constant(Float.valueOf(2.0f)));
                return;
            }
            case 3: {
                this.stack.push(new GLSLBytecode.Value.Constant(0));
                return;
            }
            case 4: {
                this.stack.push(new GLSLBytecode.Value.Constant(1));
                return;
            }
            case 5: {
                this.stack.push(new GLSLBytecode.Value.Constant(2));
                return;
            }
            case 6: {
                this.stack.push(new GLSLBytecode.Value.Constant(3));
                return;
            }
            case 177: {
                this.stack.push(new GLSLBytecode.Statement.Return(null));
                return;
            }
            case 151: 
            case 152: {
                AbstractInsnNode nextNode = this.nodeQueue.poll();
                if (!(nextNode instanceof JumpInsnNode)) throw new IllegalStateException("InsnNode invalid state");
                JumpInsnNode jumpNode = (JumpInsnNode)nextNode;
                int jumpOpcode = jumpNode.getOpcode();
                switch (jumpOpcode) {
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: {
                        J_L_Record j_L_Record;
                        GLSLBytecode.Node left = this.stack.pop();
                        GLSLBytecode.Node right = this.stack.pop();
                        if (!(left instanceof GLSLBytecode.Value)) throw new IllegalStateException("InsnNode invalid state");
                        GLSLBytecode.Value leftValue = (GLSLBytecode.Value)left;
                        if (!(right instanceof GLSLBytecode.Value)) {
                            throw new IllegalStateException("InsnNode invalid state");
                        }
                        GLSLBytecode.Value rightValue = (GLSLBytecode.Value)right;
                        switch (jumpOpcode) {
                            case 156: {
                                j_L_Record = new GLSLBytecode.Statement.Condition.GreaterThanOrEqualTo(leftValue, rightValue);
                                break;
                            }
                            case 157: {
                                j_L_Record = new GLSLBytecode.Statement.Condition.GreaterThan(leftValue, rightValue);
                                break;
                            }
                            case 158: {
                                j_L_Record = new GLSLBytecode.Statement.Condition.LessThanOrEqualTo(leftValue, rightValue);
                                break;
                            }
                            case 155: {
                                j_L_Record = new GLSLBytecode.Statement.Condition.LessThan(leftValue, rightValue);
                                break;
                            }
                            case 153: {
                                j_L_Record = new GLSLBytecode.Statement.Condition.EqualTo(leftValue, rightValue);
                                break;
                            }
                            case 154: {
                                j_L_Record = new GLSLBytecode.Statement.Condition.NotEqualTo(leftValue, rightValue);
                                break;
                            }
                            default: {
                                throw new IllegalStateException(StatementGenerator.jvmdowngrader$concat(jumpOpcode));
                            }
                        }
                        J_L_Record j_L_Record2 = j_L_Record;
                        this.stack.push((GLSLBytecode.Node)j_L_Record2);
                    }
                }
                return;
            }
        }
    }

    private void processJumpInsnNode(JumpInsnNode node) {
    }

    private void processFrameNode(FrameNode node) {
        switch (node.type) {
            case -1: {
                this.debug("FrameNode: F_NEW");
                break;
            }
            case 0: {
                this.debug("FrameNode: F_FULL");
                break;
            }
            case 2: {
                this.debug("FrameNode: F_CHOP");
                break;
            }
            case 4: {
                this.debug("FrameNode: F_SAME1");
                break;
            }
            case 1: 
            case 3: {
                GLSLBytecode.Node node2;
                ArrayList<GLSLBytecode.Statement> body = new ArrayList<GLSLBytecode.Statement>();
                while (true) {
                    if ((node2 = this.stack.peek()) instanceof GLSLBytecode.Statement.Condition) break;
                    GLSLBytecode.Statement statement = (GLSLBytecode.Statement)this.stack.poll();
                    if (statement == null) {
                        throw new IllegalStateException("FrameNode invalid state");
                    }
                    body.add(statement);
                }
                GLSLBytecode.Statement.Condition condition = (GLSLBytecode.Statement.Condition)node2;
                this.stack.poll();
                Collections.reverse(body);
                this.stacker.stack(new GLSLBytecode.Statement.If(condition, new GLSLBytecode.Body(body)));
            }
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat(Object object) {
        return "" + object;
    }

    private static /* synthetic */ String jvmdowngrader$concat(GLSLBytecode.Node node) {
        return " - " + node;
    }

    private static /* synthetic */ String jvmdowngrader$concat(String string, String string2) {
        return "NODE - " + string + " -> " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat(String string) {
        return "Unknown instruction: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat1(GLSLBytecode.Node node) {
        return "FieldInsnNode invalid state: " + node;
    }

    private static /* synthetic */ String jvmdowngrader$concat(int n) {
        return "Unexpected value: " + n;
    }

    static final class Context
    extends J_L_Record {
        @NotNull
        private final MethodNode method;
        public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/StatementGenerator";

        Context(@NotNull MethodNode method) {
            this.method = method;
        }

        public final String toString() {
            return Context.jvmdowngrader$toString(this);
        }

        public final int hashCode() {
            return Context.jvmdowngrader$hashCode(this);
        }

        public final boolean equals(Object o) {
            return Context.jvmdowngrader$equals(this, o);
        }

        @NotNull
        public MethodNode method() {
            return this.method;
        }

        private static /* synthetic */ String jvmdowngrader$toString(Context context) {
            Context context2 = context;
            return "StatementGenerator$Context[" + "method=" + context.method + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode(Context context) {
            Object[] objectArray = new Object[]{context.method};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals(Context context, Object object) {
            if (context == object) {
                return true;
            }
            if (object != null && object instanceof Context) {
                Context context2 = (Context)((Object)object);
                if (Objects.equals(context.method, context2.method)) {
                    return true;
                }
            }
            return false;
        }

        /* synthetic */ MethodNode jvmdowngrader$nest$org_jglrxavpok_jlsl_conversion_StatementGenerator$Context$get$method() {
            return this.method;
        }

        /* synthetic */ void jvmdowngrader$nest$org_jglrxavpok_jlsl_conversion_StatementGenerator$Context$set$method(MethodNode methodNode) {
            this.method = methodNode;
        }
    }
}

