/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.jlsl.conversion;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.jlsl.conversion.GLSLEncoder;
import org.jglrxavpok.jlsl.conversion.JavaUtils;
import org.jglrxavpok.jlsl.conversion.StatementGenerator;
import org.jglrxavpok.jlsl.conversion.glslbytecode.GLSLBytecode;
import org.jglrxavpok.jlsl.glsl.GLSL;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;

public enum ASMClassnode2GLSL implements GLSLEncoder<ClassNode>
{
    INSTANCE;

    public static final /* synthetic */ String jvmdowngrader$nestMembers = "org/jglrxavpok/jlsl/conversion/ASMClassnode2GLSL$Settings";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GLSLBytecode.Root encode(@NotNull ClassNode input, @NotNull Settings settings) {
        ASMClassnode2GLSL aSMClassnode2GLSL = INSTANCE;
        synchronized (aSMClassnode2GLSL) {
            List<GLSLBytecode.Field> fields = this.getFields(input, settings);
            List<GLSLBytecode.Method> methods = this.getMethods(input, settings);
            return new GLSLBytecode.Root(330, fields, methods);
        }
    }

    @Override
    @NotNull
    public GLSLBytecode.Root encode(@NotNull ClassNode input) {
        return this.encode(input, Settings.DEFAULT);
    }

    private List<GLSLBytecode.Field> getFields(ClassNode input, @NotNull Settings settings) {
        ArrayList<GLSLBytecode.Field> fields = new ArrayList<GLSLBytecode.Field>();
        for (FieldNode field : input.fields) {
            GLSLBytecode.Field.Type type = null;
            if (this.hasAnnotation(field, GLSL.Uniform.class)) {
                type = GLSLBytecode.Field.Type.UNIFORM;
            }
            if (this.hasAnnotation(field, GLSL.In.class)) {
                type = GLSLBytecode.Field.Type.IN;
            }
            if (this.hasAnnotation(field, GLSL.Out.class)) {
                type = GLSLBytecode.Field.Type.OUT;
            }
            String fieldTypeStr = JavaUtils.getTypeFromDescription(field.desc);
            GLSLBytecode.Type fieldType = new GLSLBytecode.Type(fieldTypeStr);
            fields.add(new GLSLBytecode.Field(type, field.name, fieldType));
        }
        return fields;
    }

    private List<GLSLBytecode.Method> getMethods(ClassNode input, @NotNull Settings settings) {
        ArrayList<GLSLBytecode.Method> methods = new ArrayList<GLSLBytecode.Method>();
        for (MethodNode method : input.methods) {
            JavaUtils.MethodSignature sig = JavaUtils.toSignature(method.desc);
            String returnTypeStr = sig.returnType();
            List parameterTypes = J_U_S_Stream.toList(sig.argTypes().stream().map(GLSLBytecode.Type::new));
            int parameterCount = parameterTypes.size();
            if (method.name.equals("<init>")) continue;
            ArrayList<GLSLBytecode.Method.Parameter> parameters = new ArrayList<GLSLBytecode.Method.Parameter>();
            for (int i = 1; i < parameterCount + 1; ++i) {
                LocalVariableNode parameter = (LocalVariableNode)method.localVariables.get(i);
                parameters.add(new GLSLBytecode.Method.Parameter((GLSLBytecode.Type)parameterTypes.get(i - 1), parameter.name));
            }
            GLSLBytecode.Type returnType = new GLSLBytecode.Type(returnTypeStr);
            StatementGenerator.Context context = new StatementGenerator.Context(method);
            StatementGenerator statementGenerator = new StatementGenerator(settings);
            List<GLSLBytecode.Statement> statements = statementGenerator.generate(context);
            methods.add(new GLSLBytecode.Method(returnType, method.name, parameters, new GLSLBytecode.Body(statements)));
        }
        return methods;
    }

    private boolean hasAnnotation(FieldNode field, Class<? extends Annotation> annotation) {
        String uniformAnnotationName = ASMClassnode2GLSL.jvmdowngrader$concat(annotation.getTypeName().replace('.', '/'));
        if (field.visibleAnnotations == null) {
            return false;
        }
        for (AnnotationNode annotationNode : field.visibleAnnotations) {
            if (!Objects.equals(annotationNode.desc, uniformAnnotationName)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ String jvmdowngrader$concat(String string) {
        return "L" + string + ";";
    }

    public static final class Settings
    extends J_L_Record {
        private final int version;
        private final boolean debug;
        private final boolean removeThisKeyword;
        public static final Settings DEFAULT = new Settings(330, false, true);
        public static final /* synthetic */ String jvmdowngrader$nestHost = "org/jglrxavpok/jlsl/conversion/ASMClassnode2GLSL";

        public Settings(int version, boolean debug, boolean removeThisKeyword) {
            this.version = version;
            this.debug = debug;
            this.removeThisKeyword = removeThisKeyword;
        }

        public final String toString() {
            return Settings.jvmdowngrader$toString(this);
        }

        public final int hashCode() {
            return Settings.jvmdowngrader$hashCode(this);
        }

        public final boolean equals(Object o) {
            return Settings.jvmdowngrader$equals(this, o);
        }

        public int version() {
            return this.version;
        }

        public boolean debug() {
            return this.debug;
        }

        public boolean removeThisKeyword() {
            return this.removeThisKeyword;
        }

        private static /* synthetic */ String jvmdowngrader$toString(Settings settings) {
            Settings settings2 = settings;
            return "ASMClassnode2GLSL$Settings[" + "version=" + settings.version + ", " + "debug=" + settings.debug + ", " + "removeThisKeyword=" + settings.removeThisKeyword + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode(Settings settings) {
            Object[] objectArray = new Object[]{settings.version, settings.debug, settings.removeThisKeyword};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals(Settings settings, Object object) {
            if (settings == object) {
                return true;
            }
            if (object != null && object instanceof Settings) {
                Settings settings2 = (Settings)((Object)object);
                if (settings.version == settings2.version && settings.debug == settings2.debug && settings.removeThisKeyword == settings2.removeThisKeyword) {
                    return true;
                }
            }
            return false;
        }
    }
}

