/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve.version;

import org.stianloader.picoresolve.internal.ConfusedResolverException;
import org.stianloader.picoresolve.internal.JavaInterop;
import org.stianloader.picoresolve.version.MavenVersionPart;
import org.stianloader.picoresolve.version.PrereleaseVersionPart;
import org.stianloader.picoresolve.version.QualifierVersionPart;

final class NumericVersionPart
implements MavenVersionPart {
    private int prefixCodepoint;
    private int value;

    public NumericVersionPart(int prefixCodepoint, int value) {
        this.prefixCodepoint = prefixCodepoint;
        this.value = value;
    }

    @Override
    public int compareTo(MavenVersionPart o) {
        if (o instanceof NumericVersionPart) {
            NumericVersionPart other = (NumericVersionPart)o;
            if (other.prefixCodepoint != this.prefixCodepoint) {
                if (this.prefixCodepoint == 46 && other.prefixCodepoint == 45) {
                    return 1;
                }
                if (this.prefixCodepoint == 45 && other.prefixCodepoint == 46) {
                    return -1;
                }
                throw new ConfusedResolverException("Prefix codepoint confusion");
            }
            return Integer.compareUnsigned(this.value, other.value);
        }
        if (o instanceof QualifierVersionPart || o instanceof PrereleaseVersionPart) {
            return 1;
        }
        throw new IllegalArgumentException("Cannot compare a numeric version part to a " + o.getClass().getTypeName());
    }

    @Override
    public int getPrefixCodepoint() {
        return this.prefixCodepoint;
    }

    @Override
    public String stringifyContent() {
        return Integer.toString(this.value);
    }

    public String toString() {
        return JavaInterop.codepointToString(this.getPrefixCodepoint()) + this.stringifyContent();
    }
}

