/*
 * Decompiled with CFR 0.152.
 */
package org.stianloader.picoresolve.version;

import org.stianloader.picoresolve.internal.ConfusedResolverException;
import org.stianloader.picoresolve.internal.JavaInterop;
import org.stianloader.picoresolve.version.MavenVersionPart;
import org.stianloader.picoresolve.version.NumericVersionPart;
import org.stianloader.picoresolve.version.PrereleaseVersionPart;

final class QualifierVersionPart
implements MavenVersionPart {
    private int prefixCodepoint;
    private String qualifier;

    public QualifierVersionPart(int prefix, String qualifier) {
        this.prefixCodepoint = prefix;
        this.qualifier = qualifier;
    }

    @Override
    public int compareTo(MavenVersionPart o) {
        if (o instanceof NumericVersionPart) {
            return -1;
        }
        if (o instanceof PrereleaseVersionPart) {
            return 1;
        }
        if (o instanceof QualifierVersionPart) {
            QualifierVersionPart other = (QualifierVersionPart)o;
            if (other.prefixCodepoint != this.prefixCodepoint) {
                if (this.prefixCodepoint == 46 && other.prefixCodepoint == 45) {
                    return -1;
                }
                if (this.prefixCodepoint == 45 && other.prefixCodepoint == 46) {
                    return 1;
                }
                throw new ConfusedResolverException("Prefix codepoint confusion");
            }
            return this.qualifier.compareTo(other.qualifier);
        }
        throw new IllegalArgumentException("Cannot compare a qualifier version part to a " + o.getClass().getTypeName());
    }

    @Override
    public int getPrefixCodepoint() {
        return this.prefixCodepoint;
    }

    @Override
    public String stringifyContent() {
        return this.qualifier;
    }

    public String toString() {
        return JavaInterop.codepointToString(this.getPrefixCodepoint()) + this.stringifyContent();
    }
}

